/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api.hometax;

import com.popbill.api.BaseServiceImp;
import com.popbill.api.ChargeInfo;
import com.popbill.api.FlatRateState;
import com.popbill.api.HTCashbillService;
import com.popbill.api.PopbillException;
import com.popbill.api.Response;
import com.popbill.api.hometax.HTCashbillJobState;
import com.popbill.api.hometax.HTCashbillSearchResult;
import com.popbill.api.hometax.HTCashbillSummary;
import com.popbill.api.hometax.QueryType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class HTCashbillServiceImp
extends BaseServiceImp
implements HTCashbillService {
    @Override
    protected List<String> getScopes() {
        return Arrays.asList("141");
    }

    @Override
    public ChargeInfo getChargeInfo(String CorpNum) throws PopbillException {
        return this.httpget("/HomeTax/Cashbill/ChargeInfo", CorpNum, null, ChargeInfo.class);
    }

    @Override
    public String requestJob(String CorpNum, QueryType queryType, String SDate, String EDate) throws PopbillException {
        return this.requestJob(CorpNum, queryType, SDate, EDate, null);
    }

    @Override
    public String requestJob(String CorpNum, QueryType queryType, String SDate, String EDate, String UserID) throws PopbillException {
        if (SDate == null || SDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc2dc\uc791\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EDate == null || EDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc885\ub8cc\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        JobIDResponse response = this.httppost("/HomeTax/Cashbill/" + queryType.name() + "?SDate=" + SDate + "&EDate=" + EDate, CorpNum, null, UserID, JobIDResponse.class);
        return response.jobID;
    }

    @Override
    public HTCashbillJobState getJobState(String CorpNum, String JobID) throws PopbillException {
        return this.getJobState(CorpNum, JobID, null);
    }

    @Override
    public HTCashbillJobState getJobState(String CorpNum, String JobID, String UserID) throws PopbillException {
        if (JobID.length() != 18) {
            throw new PopbillException(-99999999L, "\uc791\uc5c5\uc544\uc774\ub514\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/HomeTax/Cashbill/" + JobID + "/State", CorpNum, UserID, HTCashbillJobState.class);
    }

    @Override
    public HTCashbillJobState[] listActiveJob(String CorpNum) throws PopbillException {
        return this.listActiveJob(CorpNum, null);
    }

    @Override
    public HTCashbillJobState[] listActiveJob(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/HomeTax/Cashbill/JobList", CorpNum, UserID, HTCashbillJobState[].class);
    }

    @Override
    public HTCashbillSearchResult search(String CorpNum, String JobID, String[] TradeUsage, String[] TradeType, Integer Page, Integer PerPage, String Order) throws PopbillException {
        return this.search(CorpNum, JobID, TradeUsage, TradeType, Page, PerPage, Order, null);
    }

    @Override
    public HTCashbillSearchResult search(String CorpNum, String JobID, String[] TradeUsage, String[] TradeType, Integer Page, Integer PerPage, String Order, String UserID) throws PopbillException {
        if (JobID.length() != 18) {
            throw new PopbillException(-99999999L, "\uc791\uc5c5\uc544\uc774\ub514\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/HomeTax/Cashbill/" + JobID;
        uri = uri + "?TradeUsage=" + Arrays.toString(TradeUsage).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&TradeType=" + Arrays.toString(TradeType).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&Page=" + Integer.toString(Page);
        uri = uri + "&PerPage=" + Integer.toString(PerPage);
        uri = uri + "&Order=" + Order;
        return this.httpget(uri, CorpNum, UserID, HTCashbillSearchResult.class);
    }

    @Override
    public HTCashbillSummary summary(String CorpNum, String JobID, String[] TradeUsage, String[] TradeType) throws PopbillException {
        return this.summary(CorpNum, JobID, TradeUsage, TradeType, null);
    }

    @Override
    public HTCashbillSummary summary(String CorpNum, String JobID, String[] TradeUsage, String[] TradeType, String UserID) throws PopbillException {
        if (JobID.length() != 18) {
            throw new PopbillException(-99999999L, "\uc791\uc5c5\uc544\uc774\ub514\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/HomeTax/Cashbill/" + JobID + "/Summary";
        uri = uri + "?TradeUsage=" + Arrays.toString(TradeUsage).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&TradeType=" + Arrays.toString(TradeType).replaceAll("\\[|\\]|\\s", "");
        return this.httpget(uri, CorpNum, UserID, HTCashbillSummary.class);
    }

    @Override
    public String getFlatRatePopUpURL(String CorpNum) throws PopbillException {
        return this.getFlatRatePopUpURL(CorpNum, null);
    }

    @Override
    public String getFlatRatePopUpURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/HomeTax/Cashbill?TG=CHRG", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getCertificatePopUpURL(String CorpNum) throws PopbillException {
        return this.getCertificatePopUpURL(CorpNum, null);
    }

    @Override
    public String getCertificatePopUpURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/HomeTax/Cashbill?TG=CERT", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public FlatRateState getFlatRateState(String CorpNum) throws PopbillException {
        return this.getFlatRateState(CorpNum, null);
    }

    @Override
    public FlatRateState getFlatRateState(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/HomeTax/Cashbill/Contract", CorpNum, UserID, FlatRateState.class);
    }

    @Override
    public Date getCertificateExpireDate(String CorpNum) throws PopbillException {
        CertResponse response = this.httpget("/HomeTax/Cashbill/CertInfo", CorpNum, null, CertResponse.class);
        try {
            return new SimpleDateFormat("yyyyMMddHHmmss").parse(response.certificateExpiration);
        }
        catch (ParseException e) {
            throw new PopbillException(-99999999L, "\ub0a0\uc790\ud615\uc2dd \ud3ec\ub9f7\ubcc0\ud658 \uc2e4\ud328[" + response.certificateExpiration + "]", e);
        }
    }

    @Override
    public Response checkCertValidation(String CorpNum) throws PopbillException {
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(CorpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/HomeTax/Cashbill/CertCheck", CorpNum, null, Response.class);
    }

    @Override
    public Response registDeptUser(String CorpNum, String DeptUserID, String DeptUserPWD) throws PopbillException {
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(CorpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (DeptUserID == null || DeptUserID.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud648\ud0dd\uc2a4 \ubd80\uc11c\uc0ac\uc6a9\uc790 \uacc4\uc815 \uc544\uc774\ub514(DeptUserID)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (DeptUserPWD == null || DeptUserPWD.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud648\ud0dd\uc2a4 \ubd80\uc11c\uc0ac\uc6a9\uc790 \uacc4\uc815 \ube44\ubc00\ubc88\ud638(DeptUserPWD)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        DeptRequest request = new DeptRequest();
        request.id = DeptUserID;
        request.pwd = DeptUserPWD;
        String PostData = this.toJsonString(request);
        return this.httppost("/HomeTax/Cashbill/DeptUser", CorpNum, PostData, null, Response.class);
    }

    @Override
    public Response checkDeptUser(String CorpNum) throws PopbillException {
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(CorpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/HomeTax/Cashbill/DeptUser", CorpNum, null, Response.class);
    }

    @Override
    public Response checkLoginDeptUser(String CorpNum) throws PopbillException {
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(CorpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/HomeTax/Cashbill/DeptUser/Check", CorpNum, null, Response.class);
    }

    @Override
    public Response deleteDeptUser(String CorpNum) throws PopbillException {
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(CorpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/HomeTax/Cashbill/DeptUser", CorpNum, null, null, "DELETE", Response.class);
    }

    protected class DeptRequest {
        public String id;
        public String pwd;

        protected DeptRequest() {
        }
    }

    protected class CertResponse {
        public String certificateExpiration;

        protected CertResponse() {
        }
    }

    protected class JobIDResponse {
        public String jobID;

        protected JobIDResponse() {
        }
    }
}

