/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api.hometax;

import com.popbill.api.BaseServiceImp;
import com.popbill.api.ChargeInfo;
import com.popbill.api.FlatRateState;
import com.popbill.api.HTTaxinvoiceService;
import com.popbill.api.PopbillException;
import com.popbill.api.Response;
import com.popbill.api.hometax.HTTaxinvoice;
import com.popbill.api.hometax.HTTaxinvoiceJobState;
import com.popbill.api.hometax.HTTaxinvoiceSearchResult;
import com.popbill.api.hometax.HTTaxinvoiceSummary;
import com.popbill.api.hometax.HTTaxinvoiceXMLResponse;
import com.popbill.api.hometax.QueryType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class HTTaxinvoiceServiceImp
extends BaseServiceImp
implements HTTaxinvoiceService {
    @Override
    protected List<String> getScopes() {
        return Arrays.asList("111");
    }

    @Override
    public String getFlatRatePopUpURL(String CorpNum) throws PopbillException {
        return this.getFlatRatePopUpURL(CorpNum, null);
    }

    @Override
    public String getFlatRatePopUpURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/HomeTax/Taxinvoice?TG=CHRG", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public ChargeInfo getChargeInfo(String CorpNum) throws PopbillException {
        return this.httpget("/HomeTax/Taxinvoice/ChargeInfo", CorpNum, null, ChargeInfo.class);
    }

    @Override
    public String requestJob(String CorpNum, QueryType queryType, String DType, String SDate, String EDate) throws PopbillException {
        return this.requestJob(CorpNum, queryType, DType, SDate, EDate, null);
    }

    @Override
    public String requestJob(String CorpNum, QueryType queryType, String DType, String SDate, String EDate, String UserID) throws PopbillException {
        if (DType == null || DType.isEmpty()) {
            throw new PopbillException(-99999999L, "\uac80\uc0c9\uc77c\uc790 \uc720\ud615\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (SDate == null || SDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc2dc\uc791\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EDate == null || EDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc885\ub8cc\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        JobIDResponse response = this.httppost("/HomeTax/Taxinvoice/" + queryType.name() + "?DType=" + DType + "&SDate=" + SDate + "&EDate=" + EDate, CorpNum, null, UserID, JobIDResponse.class);
        return response.jobID;
    }

    @Override
    public HTTaxinvoiceJobState getJobState(String CorpNum, String JobID) throws PopbillException {
        return this.getJobState(CorpNum, JobID, null);
    }

    @Override
    public HTTaxinvoiceJobState getJobState(String CorpNum, String JobID, String UserID) throws PopbillException {
        if (JobID.length() != 18) {
            throw new PopbillException(-99999999L, "\uc791\uc5c5\uc544\uc774\ub514\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/HomeTax/Taxinvoice/" + JobID + "/State", CorpNum, UserID, HTTaxinvoiceJobState.class);
    }

    @Override
    public HTTaxinvoiceJobState[] listActiveJob(String CorpNum) throws PopbillException {
        return this.listActiveJob(CorpNum, null);
    }

    @Override
    public HTTaxinvoiceJobState[] listActiveJob(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/HomeTax/Taxinvoice/JobList", CorpNum, UserID, HTTaxinvoiceJobState[].class);
    }

    @Override
    public HTTaxinvoiceSearchResult search(String CorpNum, String JobID, String[] Type2, String[] TaxType, String[] PurposeType, String TaxRegIDYN, String TaxRegIDType, String TaxRegID, Integer Page, Integer PerPage, String Order) throws PopbillException {
        return this.search(CorpNum, JobID, Type2, TaxType, PurposeType, TaxRegIDYN, TaxRegIDType, TaxRegID, Page, PerPage, Order, null);
    }

    @Override
    public HTTaxinvoiceSearchResult search(String CorpNum, String JobID, String[] Type2, String[] TaxType, String[] PurposeType, String TaxRegIDYN, String TaxRegIDType, String TaxRegID, Integer Page, Integer PerPage, String Order, String UserID) throws PopbillException {
        return this.search(CorpNum, JobID, Type2, TaxType, PurposeType, TaxRegIDYN, TaxRegIDType, TaxRegID, Page, PerPage, Order, null, null);
    }

    @Override
    public HTTaxinvoiceSearchResult search(String CorpNum, String JobID, String[] Type2, String[] TaxType, String[] PurposeType, String TaxRegIDYN, String TaxRegIDType, String TaxRegID, Integer Page, Integer PerPage, String Order, String UserID, String SearchString) throws PopbillException {
        if (JobID.length() != 18) {
            throw new PopbillException(-99999999L, "\uc791\uc5c5\uc544\uc774\ub514\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/HomeTax/Taxinvoice/" + JobID;
        uri = uri + "?Type=" + Arrays.toString(Type2).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&TaxType=" + Arrays.toString(TaxType).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&PurposeType=" + Arrays.toString(PurposeType).replaceAll("\\[|\\]|\\s", "");
        if (TaxRegIDType != "" && TaxRegIDType != null) {
            uri = uri + "&TaxRegIDType=" + TaxRegIDType;
        }
        if (TaxRegIDYN != "" && TaxRegIDYN != null) {
            uri = uri + "&TaxRegIDYN=" + TaxRegIDYN;
        }
        if (TaxRegID != "" && TaxRegID != null) {
            uri = uri + "&TaxRegID=" + TaxRegID;
        }
        if (SearchString != "" && SearchString != null) {
            try {
                uri = uri + "&SearchString=" + URLEncoder.encode(SearchString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PopbillException(-99999999L, "\uac80\uc0c9\uc5b4(SearchString) \uc778\ucf54\ub529 \uc624\ub958");
            }
        }
        uri = uri + "&Page=" + Integer.toString(Page);
        uri = uri + "&PerPage=" + Integer.toString(PerPage);
        uri = uri + "&Order=" + Order;
        return this.httpget(uri, CorpNum, UserID, HTTaxinvoiceSearchResult.class);
    }

    @Override
    public HTTaxinvoiceSummary summary(String CorpNum, String JobID, String[] Type2, String[] TaxType, String[] PurposeType, String TaxRegIDYN, String TaxRegIDType, String TaxRegID) throws PopbillException {
        return this.summary(CorpNum, JobID, Type2, TaxType, PurposeType, TaxRegIDYN, TaxRegIDType, TaxRegID, null);
    }

    @Override
    public HTTaxinvoiceSummary summary(String CorpNum, String JobID, String[] Type2, String[] TaxType, String[] PurposeType, String TaxRegIDYN, String TaxRegIDType, String TaxRegID, String UserID) throws PopbillException {
        return this.summary(CorpNum, JobID, Type2, TaxType, PurposeType, TaxRegIDYN, TaxRegIDType, TaxRegID, null, null);
    }

    @Override
    public HTTaxinvoiceSummary summary(String CorpNum, String JobID, String[] Type2, String[] TaxType, String[] PurposeType, String TaxRegIDYN, String TaxRegIDType, String TaxRegID, String UserID, String SearchString) throws PopbillException {
        if (JobID.length() != 18) {
            throw new PopbillException(-99999999L, "\uc791\uc5c5\uc544\uc774\ub514\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/HomeTax/Taxinvoice/" + JobID + "/Summary";
        uri = uri + "?Type=" + Arrays.toString(Type2).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&TaxType=" + Arrays.toString(TaxType).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&PurposeType=" + Arrays.toString(PurposeType).replaceAll("\\[|\\]|\\s", "");
        if (TaxRegIDType != "" && TaxRegIDType != null) {
            uri = uri + "&TaxRegIDType=" + TaxRegIDType;
        }
        if (TaxRegIDYN != "" && TaxRegIDYN != null) {
            uri = uri + "&TaxRegIDYN=" + TaxRegIDYN;
        }
        if (TaxRegID != "" && TaxRegID != null) {
            uri = uri + "&TaxRegID=" + TaxRegID;
        }
        if (SearchString != "" && SearchString != null) {
            try {
                uri = uri + "&SearchString=" + URLEncoder.encode(SearchString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PopbillException(-99999999L, "\uac80\uc0c9\uc5b4(SearchString) \uc778\ucf54\ub529 \uc624\ub958");
            }
        }
        return this.httpget(uri, CorpNum, UserID, HTTaxinvoiceSummary.class);
    }

    @Override
    public HTTaxinvoice getTaxinvoice(String CorpNum, String NTSConfirmNum) throws PopbillException {
        return this.getTaxinvoice(CorpNum, NTSConfirmNum, null);
    }

    @Override
    public HTTaxinvoice getTaxinvoice(String CorpNum, String NTSConfirmNum, String UserID) throws PopbillException {
        if (NTSConfirmNum.length() != 24) {
            throw new PopbillException(-99999999L, "\uad6d\uc138\uccad\uc2b9\uc778\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/HomeTax/Taxinvoice/" + NTSConfirmNum, CorpNum, UserID, HTTaxinvoice.class);
    }

    @Override
    public HTTaxinvoiceXMLResponse getXML(String CorpNum, String NTSConfirmNum) throws PopbillException {
        return this.getXML(CorpNum, NTSConfirmNum, null);
    }

    @Override
    public HTTaxinvoiceXMLResponse getXML(String CorpNum, String NTSConfirmNum, String UserID) throws PopbillException {
        if (NTSConfirmNum.length() != 24) {
            throw new PopbillException(-99999999L, "\uad6d\uc138\uccad\uc2b9\uc778\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/HomeTax/Taxinvoice/" + NTSConfirmNum + "?T=xml", CorpNum, UserID, HTTaxinvoiceXMLResponse.class);
    }

    @Override
    public FlatRateState getFlatRateState(String CorpNum) throws PopbillException {
        return this.getFlatRateState(CorpNum, null);
    }

    @Override
    public FlatRateState getFlatRateState(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/HomeTax/Taxinvoice/Contract", CorpNum, UserID, FlatRateState.class);
    }

    @Override
    public String getCertificatePopUpURL(String CorpNum) throws PopbillException {
        return this.getCertificatePopUpURL(CorpNum, null);
    }

    @Override
    public String getCertificatePopUpURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/HomeTax/Taxinvoice?TG=CERT", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public Date getCertificateExpireDate(String CorpNum) throws PopbillException {
        CertResponse response = this.httpget("/HomeTax/Taxinvoice/CertInfo", CorpNum, null, CertResponse.class);
        try {
            return new SimpleDateFormat("yyyyMMddHHmmss").parse(response.certificateExpiration);
        }
        catch (ParseException e) {
            throw new PopbillException(-99999999L, "\ub0a0\uc790\ud615\uc2dd \ud3ec\ub9f7\ubcc0\ud658 \uc2e4\ud328[" + response.certificateExpiration + "]", e);
        }
    }

    @Override
    public String getPopUpURL(String CorpNum, String NTSConfirmNum) throws PopbillException {
        if (NTSConfirmNum.length() != 24) {
            throw new PopbillException(-99999999L, "\uad6d\uc138\uccad\uc2b9\uc778\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/HomeTax/Taxinvoice/" + NTSConfirmNum + "/PopUp", CorpNum, null, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getPopUpURL(String CorpNum, String NTSConfirmNum, String UserID) throws PopbillException {
        if (NTSConfirmNum.length() != 24) {
            throw new PopbillException(-99999999L, "\uad6d\uc138\uccad\uc2b9\uc778\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/HomeTax/Taxinvoice/" + NTSConfirmNum + "/PopUp", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getPrintURL(String CorpNum, String NTSConfirmNum) throws PopbillException {
        if (NTSConfirmNum.length() != 24) {
            throw new PopbillException(-99999999L, "\uad6d\uc138\uccad\uc2b9\uc778\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/HomeTax/Taxinvoice/" + NTSConfirmNum + "/Print", CorpNum, null, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getPrintURL(String CorpNum, String NTSConfirmNum, String UserID) throws PopbillException {
        if (NTSConfirmNum.length() != 24) {
            throw new PopbillException(-99999999L, "\uad6d\uc138\uccad\uc2b9\uc778\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/HomeTax/Taxinvoice/" + NTSConfirmNum + "/Print", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public Response checkCertValidation(String CorpNum) throws PopbillException {
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(CorpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/HomeTax/Taxinvoice/CertCheck", CorpNum, null, Response.class);
    }

    @Override
    public Response registDeptUser(String corpNum, String deptUserID, String deptUserPWD) throws PopbillException {
        if (corpNum == null || corpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(corpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (deptUserID == null || deptUserID.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud648\ud0dd\uc2a4 \ubd80\uc11c\uc0ac\uc6a9\uc790 \uacc4\uc815 \uc544\uc774\ub514(deptUserID)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (deptUserPWD == null || deptUserPWD.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud648\ud0dd\uc2a4 \ubd80\uc11c\uc0ac\uc6a9\uc790 \uacc4\uc815 \ube44\ubc00\ubc88\ud638(deptUserPWD)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        DeptRequest request = new DeptRequest();
        request.id = deptUserID;
        request.pwd = deptUserPWD;
        String PostData = this.toJsonString(request);
        return this.httppost("/HomeTax/Taxinvoice/DeptUser", corpNum, PostData, null, Response.class);
    }

    @Override
    public Response checkDeptUser(String CorpNum) throws PopbillException {
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(CorpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/HomeTax/Taxinvoice/DeptUser", CorpNum, null, Response.class);
    }

    @Override
    public Response checkLoginDeptUser(String CorpNum) throws PopbillException {
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(CorpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/HomeTax/Taxinvoice/DeptUser/Check", CorpNum, null, Response.class);
    }

    @Override
    public Response deleteDeptUser(String corpNum) throws PopbillException {
        if (corpNum == null || corpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(corpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/HomeTax/Taxinvoice/DeptUser", corpNum, null, null, "DELETE", Response.class);
    }

    protected class DeptRequest {
        public String id;
        public String pwd;

        protected DeptRequest() {
        }
    }

    protected class CertResponse {
        public String certificateExpiration;

        protected CertResponse() {
        }
    }

    protected class JobIDResponse {
        public String jobID;

        protected JobIDResponse() {
        }
    }
}

