/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api.kakao;

import com.popbill.api.BaseServiceImp;
import com.popbill.api.ChargeInfo;
import com.popbill.api.KakaoService;
import com.popbill.api.PopbillException;
import com.popbill.api.Response;
import com.popbill.api.kakao.ATSTemplate;
import com.popbill.api.kakao.KakaoButton;
import com.popbill.api.kakao.KakaoReceiver;
import com.popbill.api.kakao.KakaoSearchResult;
import com.popbill.api.kakao.KakaoSentInfo;
import com.popbill.api.kakao.KakaoType;
import com.popbill.api.kakao.PlusFriendID;
import com.popbill.api.kakao.SenderNumber;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KakaoServiceImp
extends BaseServiceImp
implements KakaoService {
    @Override
    protected List<String> getScopes() {
        return Arrays.asList("153", "154", "155");
    }

    @Override
    public String getPlusFriendMgtURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/KakaoTalk/?TG=PLUSFRIEND", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public PlusFriendID[] listPlusFriendID(String CorpNum) throws PopbillException {
        return this.listPlusFriendID(CorpNum, null);
    }

    @Override
    public PlusFriendID[] listPlusFriendID(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/KakaoTalk/ListPlusFriendID", CorpNum, UserID, PlusFriendID[].class);
    }

    @Override
    public Response checkSenderNumber(String CorpNum, String SenderNumber2) throws PopbillException {
        return this.checkSenderNumber(CorpNum, SenderNumber2, null);
    }

    @Override
    public Response checkSenderNumber(String CorpNum, String SenderNumber2, String UserID) throws PopbillException {
        if (SenderNumber2 == null || SenderNumber2.equals("")) {
            throw new PopbillException(-99999999L, "\ubc1c\uc2e0\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/KakaoTalk/CheckSenderNumber/" + SenderNumber2, CorpNum, UserID, Response.class);
    }

    @Override
    public String getSenderNumberMgtURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/Message/?TG=SENDER", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public SenderNumber[] getSenderNumberList(String CorpNum) throws PopbillException {
        return this.getSenderNumberList(CorpNum, null);
    }

    @Override
    public SenderNumber[] getSenderNumberList(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/Message/SenderNumber", CorpNum, null, SenderNumber[].class);
    }

    @Override
    public String getATSTemplateMgtURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/KakaoTalk/?TG=TEMPLATE", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public ATSTemplate getATSTemplate(String CorpNum, String templateCode) throws PopbillException {
        return this.getATSTemplate(CorpNum, templateCode, null);
    }

    @Override
    public ATSTemplate getATSTemplate(String CorpNum, String templateCode, String UserID) throws PopbillException {
        if (templateCode == null || templateCode.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc54c\ub9bc\ud1a1 \ud15c\ud50c\ub9bf\ucf54\ub4dc(templateCode)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/KakaoTalk/GetATSTemplate/" + templateCode, CorpNum, UserID, ATSTemplate.class);
    }

    @Override
    public ATSTemplate[] listATSTemplate(String CorpNum) throws PopbillException {
        return this.listATSTemplate(CorpNum, null);
    }

    @Override
    public ATSTemplate[] listATSTemplate(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/KakaoTalk/ListATSTemplate", CorpNum, UserID, ATSTemplate[].class);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, String receiverNum, String receiverName, String sndDT) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, sndDT, null, null, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, String receiverNum, String receiverName, String sndDT, String UserID) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, sndDT, UserID, null, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, String receiverNum, String receiverName, String sndDT, String UserID, String requestNum) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, sndDT, UserID, requestNum, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altSubject, String altContent, String altSendType, String receiverNum, String receiverName, String sndDT, String UserID, String requestNum) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltSubject(altSubject);
        receiver.setAltMessage(altContent);
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, sndDT, UserID, requestNum, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, String receiverNum, String receiverName, String sndDT, KakaoButton[] Buttons) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, sndDT, null, null, Buttons);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, String receiverNum, String receiverName, String sndDT, String UserID, KakaoButton[] Buttons) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, sndDT, UserID, null, Buttons);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, String receiverNum, String receiverName, String sndDT, String UserID, String requestNum, KakaoButton[] Buttons) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, sndDT, UserID, requestNum, Buttons);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altSubject, String altContent, String altSendType, String receiverNum, String receiverName, String sndDT, String UserID, String requestNum, KakaoButton[] Buttons) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltSubject(altSubject);
        receiver.setAltMessage(altContent);
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, sndDT, UserID, requestNum, Buttons);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String altSendType, KakaoReceiver[] Receivers, String sndDT) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, Receivers, sndDT, null, null, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String altSendType, KakaoReceiver[] Receivers, String sndDT, String UserID) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, Receivers, sndDT, UserID, null, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String altSendType, KakaoReceiver[] Receivers, String sndDT, String UserID, String requestNum) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, Receivers, sndDT, UserID, requestNum, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String altSendType, KakaoReceiver[] Receivers, String sndDT, KakaoButton[] Buttons) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, Receivers, sndDT, null, null, Buttons);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String altSendType, KakaoReceiver[] Receivers, String sndDT, String UserID, KakaoButton[] Buttons) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, Receivers, sndDT, UserID, null, Buttons);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String altSendType, KakaoReceiver[] Receivers, String sndDT, String UserID, String requestNum, KakaoButton[] Buttons) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, null, null, null, altSendType, Receivers, sndDT, UserID, requestNum, Buttons);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, String sndDT) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, content, null, altContent, altSendType, Receivers, sndDT, null, null, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, String sndDT, String UserID) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, content, null, altContent, altSendType, Receivers, sndDT, UserID, null, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, String sndDT, String UserID, String requestNum) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, content, null, altContent, altSendType, Receivers, sndDT, UserID, requestNum, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altSubject, String altContent, String altSendType, KakaoReceiver[] Receivers, String sndDT, String UserID, String requestNum) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, content, altSubject, altContent, altSendType, Receivers, sndDT, UserID, requestNum, null);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, String sndDT, KakaoButton[] Buttons) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, content, null, altContent, altSendType, Receivers, sndDT, null, null, Buttons);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, String sndDT, String UserID, KakaoButton[] Buttons) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, content, null, altContent, altSendType, Receivers, sndDT, UserID, null, Buttons);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, String sndDT, String UserID, String requestNum, KakaoButton[] Buttons) throws PopbillException {
        return this.sendATS(CorpNum, templateCode, senderNum, content, null, altContent, altSendType, Receivers, sndDT, UserID, requestNum, Buttons);
    }

    @Override
    public String sendATS(String CorpNum, String templateCode, String senderNum, String content, String altSubject, String altContent, String altSendType, KakaoReceiver[] Receivers, String sndDT, String UserID, String requestNum, KakaoButton[] Buttons) throws PopbillException {
        if (templateCode == null || templateCode == "") {
            throw new PopbillException(-99999999L, "\uc54c\ub9bc\ud1a1 \ud15c\ud50c\ub9bf\ucf54\ub4dc(templateCode)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ATSSendRequest request = new ATSSendRequest();
        request.templateCode = templateCode;
        request.snd = senderNum;
        request.content = content;
        request.altSubject = altSubject;
        request.altContent = altContent;
        request.altSendType = altSendType;
        if (null != Buttons) {
            request.btns = Buttons;
        }
        request.sndDT = sndDT;
        request.requestNum = requestNum;
        request.msgs = Receivers;
        String postData = this.toJsonString(request);
        ReceiptResponse response = this.httppost("/ATS", CorpNum, postData, UserID, ReceiptResponse.class);
        return response.receiptNum;
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoButton[] Buttons, String receiverNum, String receiverName, String sndDT, Boolean adsYN) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendFTS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, Buttons, sndDT, adsYN, null, null);
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoButton[] Buttons, String receiverNum, String receiverName, String sndDT, Boolean adsYN, String UserID) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendFTS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, Buttons, sndDT, adsYN, UserID, null);
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoButton[] Buttons, String receiverNum, String receiverName, String sndDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendFTS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, Buttons, sndDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String content, String altSubject, String altContent, String altSendType, KakaoButton[] Buttons, String receiverNum, String receiverName, String sndDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltSubject(altSubject);
        receiver.setAltMessage(altContent);
        return this.sendFTS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, Buttons, sndDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN) throws PopbillException {
        return this.sendFTS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, Receivers, Buttons, sndDT, adsYN, null, null);
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, String UserID) throws PopbillException {
        return this.sendFTS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, Receivers, Buttons, sndDT, adsYN, UserID, null);
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        return this.sendFTS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, Receivers, Buttons, sndDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN) throws PopbillException {
        return this.sendFTS(CorpNum, plusFriendID, senderNum, content, null, altContent, altSendType, Receivers, Buttons, sndDT, adsYN, null, null);
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, String UserID) throws PopbillException {
        return this.sendFTS(CorpNum, plusFriendID, senderNum, content, null, altContent, altSendType, Receivers, Buttons, sndDT, adsYN, UserID, null);
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        return this.sendFTS(CorpNum, plusFriendID, senderNum, content, null, altContent, altSendType, Receivers, Buttons, sndDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendFTS(String CorpNum, String plusFriendID, String senderNum, String content, String altSubject, String altContent, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        if (plusFriendID == null || plusFriendID == "") {
            throw new PopbillException(-99999999L, "\uce74\uce74\uc624\ud1a1 \uac80\uc0c9\uc6a9 \uc544\uc774\ub514\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        FTSSendRequest request = new FTSSendRequest();
        request.plusFriendID = plusFriendID;
        request.snd = senderNum;
        request.content = content;
        request.altSubject = altSubject;
        request.altContent = altContent;
        request.altSendType = altSendType;
        request.msgs = Receivers;
        request.btns = Buttons;
        request.sndDT = sndDT;
        request.adsYN = adsYN;
        request.requestNum = requestNum;
        String postData = this.toJsonString(request);
        ReceiptResponse response = this.httppost("/FTS", CorpNum, postData, UserID, ReceiptResponse.class);
        return response.receiptNum;
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoButton[] Buttons, String receiverNum, String receiverName, String sndDT, Boolean adsYN, File file, String imageURL) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendFMS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, Buttons, sndDT, adsYN, file, imageURL, null, null);
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoButton[] Buttons, String receiverNum, String receiverName, String sndDT, Boolean adsYN, File file, String imageURL, String UserID) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendFMS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, Buttons, sndDT, adsYN, file, imageURL, UserID, null);
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoButton[] Buttons, String receiverNum, String receiverName, String sndDT, Boolean adsYN, File file, String imageURL, String UserID, String requestNum) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltMessage(altContent);
        return this.sendFMS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, Buttons, sndDT, adsYN, file, imageURL, UserID, requestNum);
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String content, String altSubject, String altContent, String altSendType, KakaoButton[] Buttons, String receiverNum, String receiverName, String sndDT, Boolean adsYN, File file, String imageURL, String UserID, String requestNum) throws PopbillException {
        KakaoReceiver receiver = new KakaoReceiver();
        receiver.setReceiverNum(receiverNum);
        receiver.setReceiverName(receiverName);
        receiver.setMessage(content);
        receiver.setAltSubject(altSubject);
        receiver.setAltMessage(altContent);
        return this.sendFMS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, new KakaoReceiver[]{receiver}, Buttons, sndDT, adsYN, file, imageURL, UserID, requestNum);
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, File file, String imageURL) throws PopbillException {
        return this.sendFMS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, Receivers, Buttons, sndDT, adsYN, file, imageURL, null, null);
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, File file, String imageURL, String UserID) throws PopbillException {
        return this.sendFMS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, Receivers, Buttons, sndDT, adsYN, file, imageURL, UserID, null);
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, File file, String imageURL, String UserID, String requestNum) throws PopbillException {
        return this.sendFMS(CorpNum, plusFriendID, senderNum, null, null, null, altSendType, Receivers, Buttons, sndDT, adsYN, file, imageURL, UserID, requestNum);
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, File file, String imageURL) throws PopbillException {
        return this.sendFMS(CorpNum, plusFriendID, senderNum, content, null, altContent, altSendType, Receivers, Buttons, sndDT, adsYN, file, imageURL, null, null);
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, File file, String imageURL, String UserID) throws PopbillException {
        return this.sendFMS(CorpNum, plusFriendID, senderNum, content, null, altContent, altSendType, Receivers, Buttons, sndDT, adsYN, file, imageURL, UserID, null);
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String content, String altContent, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, File file, String imageURL, String UserID, String requestNum) throws PopbillException {
        return this.sendFMS(CorpNum, plusFriendID, senderNum, content, null, altContent, altSendType, Receivers, Buttons, sndDT, adsYN, file, imageURL, UserID, requestNum);
    }

    @Override
    public String sendFMS(String CorpNum, String plusFriendID, String senderNum, String content, String altSubject, String altContent, String altSendType, KakaoReceiver[] Receivers, KakaoButton[] Buttons, String sndDT, Boolean adsYN, File file, String imageURL, String UserID, String requestNum) throws PopbillException {
        if (plusFriendID == null || plusFriendID == "") {
            throw new PopbillException(-99999999L, "\uce74\uce74\uc624\ud1a1 \uac80\uc0c9\uc6a9 \uc544\uc774\ub514\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        FTSSendRequest request = new FTSSendRequest();
        request.plusFriendID = plusFriendID;
        request.snd = senderNum;
        request.content = content;
        request.altSubject = altSubject;
        request.altContent = altContent;
        request.altSendType = altSendType;
        request.msgs = Receivers;
        request.btns = Buttons;
        request.sndDT = sndDT;
        request.adsYN = adsYN;
        request.imageURL = imageURL;
        request.requestNum = requestNum;
        String postData = this.toJsonString(request);
        ArrayList<BaseServiceImp.UploadFile> uploadFiles = new ArrayList<BaseServiceImp.UploadFile>();
        BaseServiceImp.UploadFile uf = new BaseServiceImp.UploadFile();
        uf.fieldName = "file";
        uf.fileName = file.getName();
        try {
            uf.fileData = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\ud560 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
        }
        uploadFiles.add(uf);
        ReceiptResponse response = this.httppostFiles("/FMS", CorpNum, postData, uploadFiles, UserID, ReceiptResponse.class);
        for (BaseServiceImp.UploadFile f : uploadFiles) {
            if (f.fileData == null) continue;
            try {
                f.fileData.close();
            }
            catch (IOException iOException) {}
        }
        return response.receiptNum;
    }

    @Override
    public Response cancelReserve(String CorpNum, String receiptNum) throws PopbillException {
        return this.cancelReserve(CorpNum, receiptNum, null);
    }

    @Override
    public Response cancelReserve(String CorpNum, String receiptNum, String UserID) throws PopbillException {
        if (receiptNum == null || receiptNum == "") {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/KakaoTalk/" + receiptNum + "/Cancel", CorpNum, UserID, Response.class);
    }

    @Override
    public Response cancelReserveRN(String CorpNum, String requestNum) throws PopbillException {
        return this.cancelReserveRN(CorpNum, requestNum, null);
    }

    @Override
    public Response cancelReserveRN(String CorpNum, String requestNum, String UserID) throws PopbillException {
        if (requestNum == null || requestNum == "") {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\uc694\uccad\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/KakaoTalk/Cancel/" + requestNum, CorpNum, UserID, Response.class);
    }

    @Override
    public Response cancelReservebyRCV(String CorpNum, String receiptNum, String receiveNum) throws PopbillException {
        return this.cancelReservebyRCV(CorpNum, receiptNum, receiveNum, null);
    }

    @Override
    public Response cancelReservebyRCV(String CorpNum, String receiptNum, String receiveNum, String UserID) throws PopbillException {
        if (receiptNum == null || receiptNum.equals("")) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receiveNum == null || receiveNum.equals("")) {
            throw new PopbillException(-99999999L, "\uc218\uc2e0\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(receiveNum);
        return this.httppost("/KakaoTalk/" + receiptNum + "/Cancel", CorpNum, PostData, UserID, Response.class);
    }

    @Override
    public Response cancelReserveRNbyRCV(String CorpNum, String requestNum, String receiveNum) throws PopbillException {
        return this.cancelReserveRNbyRCV(CorpNum, requestNum, receiveNum, null);
    }

    @Override
    public Response cancelReserveRNbyRCV(String CorpNum, String requestNum, String receiveNum, String UserID) throws PopbillException {
        if (requestNum == null || requestNum.equals("")) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\uc694\uccad\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receiveNum == null || receiveNum.equals("")) {
            throw new PopbillException(-99999999L, "\uc218\uc2e0\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(receiveNum);
        return this.httppost("/KakaoTalk/Cancel/" + requestNum, CorpNum, PostData, UserID, Response.class);
    }

    @Override
    public KakaoSentInfo getMessages(String CorpNum, String receiptNum) throws PopbillException {
        return this.getMessages(CorpNum, receiptNum, null);
    }

    @Override
    public KakaoSentInfo getMessages(String CorpNum, String receiptNum, String UserID) throws PopbillException {
        if (receiptNum == null || receiptNum == "") {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/KakaoTalk/" + receiptNum, CorpNum, UserID, KakaoSentInfo.class);
    }

    @Override
    public KakaoSentInfo getMessagesRN(String CorpNum, String requestNum) throws PopbillException {
        return this.getMessagesRN(CorpNum, requestNum, null);
    }

    @Override
    public KakaoSentInfo getMessagesRN(String CorpNum, String requestNum, String UserID) throws PopbillException {
        if (requestNum == null || requestNum == "") {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\uc694\uccad\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/KakaoTalk/Get/" + requestNum, CorpNum, UserID, KakaoSentInfo.class);
    }

    @Override
    public KakaoSearchResult search(String CorpNum, String SDate, String EDate, String[] State, String[] Item, String ReserveYN, Boolean SenderYN, int Page, int PerPage, String Order) throws PopbillException {
        return this.search(CorpNum, SDate, EDate, State, Item, ReserveYN, SenderYN, Page, PerPage, Order, null);
    }

    @Override
    public KakaoSearchResult search(String CorpNum, String SDate, String EDate, String[] State, String[] Item, String ReserveYN, Boolean SenderYN, int Page, int PerPage, String Order, String UserID) throws PopbillException {
        return this.search(CorpNum, SDate, EDate, State, Item, ReserveYN, SenderYN, Page, PerPage, Order, UserID, null);
    }

    @Override
    public KakaoSearchResult search(String CorpNum, String SDate, String EDate, String[] State, String[] Item, String ReserveYN, Boolean SenderYN, int Page, int PerPage, String Order, String UserID, String QString) throws PopbillException {
        if (SDate == null) {
            throw new PopbillException(-99999999L, "\uc2dc\uc791\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EDate == null) {
            throw new PopbillException(-99999999L, "\uc885\ub8cc\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/KakaoTalk/Search?SDate=" + SDate;
        uri = uri + "&EDate=" + EDate;
        uri = uri + "&State=" + Arrays.toString(State).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&Item=" + Arrays.toString(Item).replaceAll("\\[|\\]|\\s", "");
        if (ReserveYN != null) {
            uri = uri + "&ReserveYN=" + ReserveYN;
        }
        uri = SenderYN != false ? uri + "&SenderYN=1" : uri + "&SenderYN=0";
        uri = uri + "&Page=" + Integer.toString(Page);
        uri = uri + "&PerPage=" + Integer.toString(PerPage);
        uri = uri + "&Order=" + Order;
        if (QString != null && QString != "") {
            try {
                uri = uri + "&QString=" + URLEncoder.encode(QString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PopbillException(-99999999L, "\uac80\uc0c9\uc5b4(QString) \uc778\ucf54\ub529 \uc624\ub958");
            }
        }
        return this.httpget(uri, CorpNum, UserID, KakaoSearchResult.class);
    }

    @Override
    public String getSentListURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/KakaoTalk/?TG=BOX", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getURL(String CorpNum, String TOGO, String UserID) throws PopbillException {
        String uri = "/KakaoTalk/?TG=";
        if (TOGO == "SENDER") {
            uri = "/Message/?TG=";
        }
        BaseServiceImp.URLResponse response = this.httpget(uri + TOGO, CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public float getUnitCost(String CorpNum, KakaoType kakaoType) throws PopbillException {
        if (kakaoType == null) {
            throw new PopbillException(-99999999L, "\uce74\uce74\uc624\ud1a1 \uc804\uc1a1\uc720\ud615\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.UnitCostResponse response = this.httpget("/KakaoTalk/UnitCost?Type=" + kakaoType.name(), CorpNum, null, BaseServiceImp.UnitCostResponse.class);
        return response.unitCost;
    }

    @Override
    public ChargeInfo getChargeInfo(String CorpNum, KakaoType kakaoType) throws PopbillException {
        return this.httpget("/KakaoTalk/ChargeInfo?Type=" + kakaoType.name(), CorpNum, null, ChargeInfo.class);
    }

    protected class ReceiptResponse {
        public String receiptNum;

        protected ReceiptResponse() {
        }
    }

    protected class FTSSendRequest {
        public String plusFriendID;
        public String snd;
        public String content;
        public String altSubject;
        public String altContent;
        public String altSendType;
        public String sndDT;
        public String imageURL;
        public Boolean adsYN;
        public String requestNum;
        public KakaoReceiver[] msgs;
        public KakaoButton[] btns;

        protected FTSSendRequest() {
        }
    }

    protected class ATSSendRequest {
        public String templateCode;
        public String snd;
        public String content;
        public String altSubject;
        public String altContent;
        public String altSendType;
        public String sndDT;
        public String requestNum;
        public KakaoReceiver[] msgs;
        public KakaoButton[] btns;

        protected ATSSendRequest() {
        }
    }
}

