/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api.message;

import com.popbill.api.BaseServiceImp;
import com.popbill.api.ChargeInfo;
import com.popbill.api.MessageService;
import com.popbill.api.PopbillException;
import com.popbill.api.Response;
import com.popbill.api.message.AutoDeny;
import com.popbill.api.message.AutoDenyNumberInfo;
import com.popbill.api.message.MSGSearchResult;
import com.popbill.api.message.Message;
import com.popbill.api.message.MessageBriefInfo;
import com.popbill.api.message.MessageType;
import com.popbill.api.message.SenderNumber;
import com.popbill.api.message.SentMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class MessageServiceImp
extends BaseServiceImp
implements MessageService {
    @Override
    protected List<String> getScopes() {
        return Arrays.asList("150", "151", "152");
    }

    @Override
    public float getUnitCost(String CorpNum, MessageType MsgType) throws PopbillException {
        if (MsgType == null) {
            throw new PopbillException(-99999999L, "\uba54\uc2dc\uc9c0 \uc720\ud615\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.UnitCostResponse response = this.httpget("/Message/UnitCost?Type=" + MsgType.name(), CorpNum, null, BaseServiceImp.UnitCostResponse.class);
        return response.unitCost;
    }

    @Override
    public String getURL(String CorpNum, String TOGO) throws PopbillException {
        return this.getURL(CorpNum, null, TOGO);
    }

    @Override
    public String getURL(String CorpNum, String UserID, String TOGO) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/Message/?TG=" + TOGO, CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String sendSMS(String CorpNum, String sender, String receiver, String receiverName, String content, Date reserveDT, String UserID) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        return this.sendSMS(CorpNum, new Message[]{message}, reserveDT, UserID);
    }

    @Override
    public String sendSMS(String CorpNum, String sender, String receiver, String receiverName, String content, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        return this.sendSMS(CorpNum, null, null, new Message[]{message}, reserveDT, adsYN, UserID);
    }

    @Override
    public String sendSMS(String CorpNum, Message[] Messages, Date reserveDT, String UserID) throws PopbillException {
        return this.sendSMS(CorpNum, null, null, Messages, reserveDT, UserID);
    }

    @Override
    public String sendSMS(String CorpNum, String sender, String content, Message[] Messages, Date reserveDT, String UserID) throws PopbillException {
        return this.sendSMS(CorpNum, sender, content, Messages, reserveDT, false, UserID);
    }

    @Override
    public String sendSMS(String CorpNum, String sender, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        return this.sendMessage(MessageType.SMS, CorpNum, sender, null, null, content, Messages, reserveDT, adsYN, UserID, null);
    }

    @Override
    public String sendSMS(String CorpNum, String sender, String senderName, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        return this.sendMessage(MessageType.SMS, CorpNum, sender, senderName, null, content, Messages, reserveDT, adsYN, UserID, null);
    }

    @Override
    public String sendSMS(String CorpNum, String sender, String receiver, String receiverName, String content, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        return this.sendSMS(CorpNum, new Message[]{message}, reserveDT, UserID, requestNum);
    }

    @Override
    public String sendSMS(String CorpNum, String sender, String receiver, String receiverName, String content, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        return this.sendSMS(CorpNum, null, null, new Message[]{message}, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendSMS(String CorpNum, Message[] Messages, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        return this.sendSMS(CorpNum, null, null, Messages, reserveDT, UserID, requestNum);
    }

    @Override
    public String sendSMS(String CorpNum, String sender, String content, Message[] Messages, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        return this.sendSMS(CorpNum, sender, content, Messages, reserveDT, false, UserID, requestNum);
    }

    @Override
    public String sendSMS(String CorpNum, String sender, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        return this.sendMessage(MessageType.SMS, CorpNum, sender, null, null, content, Messages, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendSMS(String CorpNum, String sender, String senderName, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        return this.sendMessage(MessageType.SMS, CorpNum, sender, senderName, null, content, Messages, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendLMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, Date reserveDT, String UserID) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendLMS(CorpNum, new Message[]{message}, reserveDT, UserID);
    }

    @Override
    public String sendLMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendLMS(CorpNum, null, null, null, new Message[]{message}, reserveDT, adsYN, UserID);
    }

    @Override
    public String sendLMS(String CorpNum, Message[] Messages, Date reserveDT, String UserID) throws PopbillException {
        return this.sendLMS(CorpNum, null, null, null, Messages, reserveDT, UserID);
    }

    @Override
    public String sendLMS(String CorpNum, String sender, String subject, String content, Message[] Messages, Date reserveDT, String UserID) throws PopbillException {
        return this.sendLMS(CorpNum, sender, subject, content, Messages, reserveDT, false, UserID);
    }

    @Override
    public String sendLMS(String CorpNum, String sender, String subject, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        return this.sendMessage(MessageType.LMS, CorpNum, sender, null, subject, content, Messages, reserveDT, adsYN, UserID, null);
    }

    @Override
    public String sendLMS(String CorpNum, String sender, String senderName, String subject, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        return this.sendMessage(MessageType.LMS, CorpNum, sender, senderName, subject, content, Messages, reserveDT, adsYN, UserID, null);
    }

    @Override
    public String sendLMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendLMS(CorpNum, new Message[]{message}, reserveDT, UserID, requestNum);
    }

    @Override
    public String sendLMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendLMS(CorpNum, null, null, null, new Message[]{message}, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendLMS(String CorpNum, Message[] Messages, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        return this.sendLMS(CorpNum, null, null, null, Messages, reserveDT, UserID, requestNum);
    }

    @Override
    public String sendLMS(String CorpNum, String sender, String subject, String content, Message[] Messages, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        return this.sendLMS(CorpNum, sender, subject, content, Messages, reserveDT, false, UserID, requestNum);
    }

    @Override
    public String sendLMS(String CorpNum, String sender, String subject, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        return this.sendMessage(MessageType.LMS, CorpNum, sender, null, subject, content, Messages, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendLMS(String CorpNum, String sender, String senderName, String subject, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        return this.sendMessage(MessageType.LMS, CorpNum, sender, senderName, subject, content, Messages, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendXMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, Date reserveDT, String UserID) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendXMS(CorpNum, new Message[]{message}, reserveDT, UserID);
    }

    @Override
    public String sendXMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendXMS(CorpNum, null, null, null, new Message[]{message}, reserveDT, adsYN, UserID);
    }

    @Override
    public String sendXMS(String CorpNum, Message[] Messages, Date reserveDT, String UserID) throws PopbillException {
        return this.sendXMS(CorpNum, null, null, null, Messages, reserveDT, UserID);
    }

    @Override
    public String sendXMS(String CorpNum, String sender, String subject, String content, Message[] Messages, Date reserveDT, String UserID) throws PopbillException {
        return this.sendXMS(CorpNum, sender, subject, content, Messages, reserveDT, false, UserID);
    }

    @Override
    public String sendXMS(String CorpNum, String sender, String subject, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        return this.sendMessage(MessageType.XMS, CorpNum, sender, null, subject, content, Messages, reserveDT, adsYN, UserID, null);
    }

    @Override
    public String sendXMS(String CorpNum, String sender, String senderName, String subject, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        return this.sendMessage(MessageType.XMS, CorpNum, sender, senderName, subject, content, Messages, reserveDT, adsYN, UserID, null);
    }

    @Override
    public String sendXMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendXMS(CorpNum, new Message[]{message}, reserveDT, UserID, requestNum);
    }

    @Override
    public String sendXMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendXMS(CorpNum, null, null, null, new Message[]{message}, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendXMS(String CorpNum, Message[] Messages, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        return this.sendXMS(CorpNum, null, null, null, Messages, reserveDT, UserID, requestNum);
    }

    @Override
    public String sendXMS(String CorpNum, String sender, String subject, String content, Message[] Messages, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        return this.sendXMS(CorpNum, sender, subject, content, Messages, reserveDT, false, UserID, requestNum);
    }

    @Override
    public String sendXMS(String CorpNum, String sender, String subject, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        return this.sendMessage(MessageType.XMS, CorpNum, sender, null, subject, content, Messages, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendXMS(String CorpNum, String sender, String senderName, String subject, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        return this.sendMessage(MessageType.XMS, CorpNum, sender, senderName, subject, content, Messages, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public SentMessage[] getMessages(String CorpNum, String receiptNum) throws PopbillException {
        if (receiptNum == null) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Message/" + receiptNum, CorpNum, null, SentMessage[].class);
    }

    @Override
    public SentMessage[] getMessages(String CorpNum, String receiptNum, String userID) throws PopbillException {
        if (receiptNum == null) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Message/" + receiptNum, CorpNum, userID, SentMessage[].class);
    }

    @Override
    public SentMessage[] getMessagesRN(String CorpNum, String requestNum) throws PopbillException {
        if (requestNum == null) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\uc694\uccad\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Message/Get/" + requestNum, CorpNum, null, SentMessage[].class);
    }

    @Override
    public SentMessage[] getMessagesRN(String CorpNum, String requestNum, String userID) throws PopbillException {
        if (requestNum == null) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\uc694\uccad\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Message/Get/" + requestNum, CorpNum, userID, SentMessage[].class);
    }

    @Override
    public MessageBriefInfo[] getStates(String corpNum, String[] receiptNumList) throws PopbillException {
        return this.getStates(corpNum, receiptNumList, null);
    }

    @Override
    public MessageBriefInfo[] getStates(String corpNum, String[] receiptNumList, String userID) throws PopbillException {
        if (receiptNumList == null || receiptNumList.length == 0) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638 \ubaa9\ub85d\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(receiptNumList);
        return this.httppost("/Message/States", corpNum, PostData, userID, MessageBriefInfo[].class);
    }

    @Override
    public Response cancelReserve(String CorpNum, String receiptNum) throws PopbillException {
        return this.cancelReserve(CorpNum, receiptNum, null);
    }

    @Override
    public Response cancelReserve(String CorpNum, String receiptNum, String UserID) throws PopbillException {
        if (receiptNum == null) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Message/" + receiptNum + "/Cancel", CorpNum, UserID, Response.class);
    }

    @Override
    public Response cancelReserveRN(String CorpNum, String requestNum) throws PopbillException {
        return this.cancelReserveRN(CorpNum, requestNum, null);
    }

    @Override
    public Response cancelReserveRN(String CorpNum, String requestNum, String UserID) throws PopbillException {
        if (requestNum == null) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\uc694\uccad\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Message/Cancel/" + requestNum, CorpNum, UserID, Response.class);
    }

    @Override
    public String sendMMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, File file, Date reserveDT, String UserID) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendMMS(CorpNum, new Message[]{message}, file, reserveDT, UserID);
    }

    @Override
    public String sendMMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, File file, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendMMS(CorpNum, null, null, null, new Message[]{message}, file, reserveDT, adsYN, UserID);
    }

    @Override
    public String sendMMS(String CorpNum, Message[] Messages, File file, Date reserveDT, String UserID) throws PopbillException {
        return this.sendMMS(CorpNum, null, null, null, Messages, file, reserveDT, UserID);
    }

    @Override
    public String sendMMS(String CorpNum, String sender, String subject, String content, Message[] Messages, File file, Date reserveDT, String UserID) throws PopbillException {
        return this.sendMMS(CorpNum, sender, subject, content, Messages, file, reserveDT, false, UserID);
    }

    @Override
    public String sendMMS(String CorpNum, String sender, String subject, String content, Message[] Messages, File file, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        return this.sendMMS(CorpNum, sender, null, subject, content, Messages, file, reserveDT, adsYN, UserID);
    }

    @Override
    public String sendMMS(String CorpNum, String sender, String senderName, String subject, String content, Message[] Messages, File file, Date reserveDT, Boolean adsYN, String UserID) throws PopbillException {
        if (Messages == null || Messages.length == 0) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\ud560 \uba54\uc2dc\uc9c0\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        SendRequest request = new SendRequest();
        request.snd = sender;
        request.content = content;
        request.subject = subject;
        if (senderName != null) {
            request.sndnm = senderName;
        }
        request.adsYN = adsYN != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        if (reserveDT != null) {
            request.sndDT = new SimpleDateFormat("yyyyMMddHHmmss", Locale.KOREA).format(reserveDT);
        }
        request.msgs = Messages;
        String PostData = this.toJsonString(request);
        ArrayList<BaseServiceImp.UploadFile> uploadFiles = new ArrayList<BaseServiceImp.UploadFile>();
        BaseServiceImp.UploadFile uf = new BaseServiceImp.UploadFile(this);
        uf.fieldName = "file";
        uf.fileName = file.getName();
        try {
            uf.fileData = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\ud560 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
        }
        uploadFiles.add(uf);
        ReceiptResponse response = this.httppostFiles("/MMS", CorpNum, PostData, uploadFiles, UserID, ReceiptResponse.class);
        for (BaseServiceImp.UploadFile f : uploadFiles) {
            if (f.fileData == null) continue;
            try {
                f.fileData.close();
            }
            catch (IOException iOException) {}
        }
        return response.receiptNum;
    }

    @Override
    public String sendMMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, File file, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendMMS(CorpNum, new Message[]{message}, file, reserveDT, UserID, requestNum);
    }

    @Override
    public String sendMMS(String CorpNum, String sender, String receiver, String receiverName, String subject, String content, File file, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        Message message = new Message();
        message.setSender(sender);
        message.setReceiver(receiver);
        message.setReceiverName(receiverName);
        message.setContent(content);
        message.setSubject(subject);
        return this.sendMMS(CorpNum, null, null, null, new Message[]{message}, file, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendMMS(String CorpNum, Message[] Messages, File file, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        return this.sendMMS(CorpNum, null, null, null, Messages, file, reserveDT, UserID, requestNum);
    }

    @Override
    public String sendMMS(String CorpNum, String sender, String subject, String content, Message[] Messages, File file, Date reserveDT, String UserID, String requestNum) throws PopbillException {
        return this.sendMMS(CorpNum, sender, subject, content, Messages, file, reserveDT, false, UserID, requestNum);
    }

    @Override
    public String sendMMS(String CorpNum, String sender, String subject, String content, Message[] Messages, File file, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        return this.sendMMS(CorpNum, sender, null, subject, content, Messages, file, reserveDT, adsYN, UserID, requestNum);
    }

    @Override
    public String sendMMS(String CorpNum, String sender, String senderName, String subject, String content, Message[] Messages, File file, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        if (Messages == null || Messages.length == 0) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\ud560 \uba54\uc2dc\uc9c0\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        SendRequest request = new SendRequest();
        request.snd = sender;
        request.content = content;
        request.subject = subject;
        if (senderName != null) {
            request.sndnm = senderName;
        }
        request.adsYN = adsYN != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        if (reserveDT != null) {
            request.sndDT = new SimpleDateFormat("yyyyMMddHHmmss", Locale.KOREA).format(reserveDT);
        }
        request.msgs = Messages;
        if (requestNum != null) {
            request.requestNum = requestNum;
        }
        String PostData = this.toJsonString(request);
        ArrayList<BaseServiceImp.UploadFile> uploadFiles = new ArrayList<BaseServiceImp.UploadFile>();
        BaseServiceImp.UploadFile uf = new BaseServiceImp.UploadFile(this);
        uf.fieldName = "file";
        uf.fileName = file.getName();
        try {
            uf.fileData = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\ud560 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
        }
        uploadFiles.add(uf);
        ReceiptResponse response = this.httppostFiles("/MMS", CorpNum, PostData, uploadFiles, UserID, ReceiptResponse.class);
        for (BaseServiceImp.UploadFile f : uploadFiles) {
            if (f.fileData == null) continue;
            try {
                f.fileData.close();
            }
            catch (IOException iOException) {}
        }
        return response.receiptNum;
    }

    private String sendMessage(MessageType MsgType, String CorpNum, String sender, String senderName, String subject, String content, Message[] Messages, Date reserveDT, Boolean adsYN, String UserID, String requestNum) throws PopbillException {
        if (MsgType == null) {
            throw new PopbillException(-99999999L, "\uba54\uc2dc\uc9c0 \uc720\ud615\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (Messages == null || Messages.length == 0) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\ud560 \uba54\uc2dc\uc9c0\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        SendRequest request = new SendRequest();
        request.snd = sender;
        request.content = content;
        request.subject = subject;
        if (senderName != null) {
            request.sndnm = senderName;
        }
        request.adsYN = adsYN != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        if (reserveDT != null) {
            request.sndDT = new SimpleDateFormat("yyyyMMddHHmmss", Locale.KOREA).format(reserveDT);
        }
        request.msgs = Messages;
        if (requestNum != null) {
            request.requestNum = requestNum;
        }
        String PostData = this.toJsonString(request);
        ReceiptResponse response = this.httppost("/" + MsgType.name(), CorpNum, PostData, UserID, ReceiptResponse.class);
        return response.receiptNum;
    }

    @Override
    public MSGSearchResult search(String CorpNum, String SDate, String EDate, String[] State, String[] Item, Boolean ReserveYN, Boolean SenderYN, int Page, int PerPage, String Order) throws PopbillException {
        return this.search(CorpNum, SDate, EDate, State, Item, ReserveYN, SenderYN, Page, PerPage, Order, null);
    }

    @Override
    public MSGSearchResult search(String CorpNum, String SDate, String EDate, String[] State, String[] Item, Boolean ReserveYN, Boolean SenderYN, int Page, int PerPage, String Order, String QString) throws PopbillException {
        if (SDate == null) {
            throw new PopbillException(-99999999L, "\uc2dc\uc791\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EDate == null) {
            throw new PopbillException(-99999999L, "\uc885\ub8cc\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/Message/Search?SDate=" + SDate;
        uri = uri + "&EDate=" + EDate;
        uri = uri + "&State=" + Arrays.toString(State).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&Item=" + Arrays.toString(Item).replaceAll("\\[|\\]|\\s", "");
        uri = ReserveYN != false ? uri + "&ReserveYN=1" : uri + "&ReserveYN=0";
        uri = SenderYN != false ? uri + "&SenderYN=1" : uri + "&SenderYN=0";
        uri = uri + "&Page=" + Integer.toString(Page);
        uri = uri + "&PerPage=" + Integer.toString(PerPage);
        uri = uri + "&Order=" + Order;
        if (QString != null && QString != "") {
            try {
                uri = uri + "&QString=" + URLEncoder.encode(QString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PopbillException(-99999999L, "\uac80\uc0c9\uc5b4(QString) \uc778\ucf54\ub529 \uc624\ub958");
            }
        }
        return this.httpget(uri, CorpNum, null, MSGSearchResult.class);
    }

    @Override
    public AutoDeny[] getAutoDenyList(String CorpNum) throws PopbillException {
        return this.httpget("/Message/Denied", CorpNum, null, AutoDeny[].class);
    }

    @Override
    public AutoDenyNumberInfo checkAutoDenyNumber(String CorpNum) throws PopbillException {
        return this.checkAutoDenyNumber(CorpNum, null);
    }

    @Override
    public AutoDenyNumberInfo checkAutoDenyNumber(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/Message/AutoDenyNumberInfo", CorpNum, UserID, AutoDenyNumberInfo.class);
    }

    @Override
    public ChargeInfo getChargeInfo(String CorpNum, MessageType MsgType) throws PopbillException {
        return this.httpget("/Message/ChargeInfo?Type=" + MsgType.name(), CorpNum, null, ChargeInfo.class);
    }

    @Override
    public SenderNumber[] getSenderNumberList(String CorpNum) throws PopbillException {
        return this.getSenderNumberList(CorpNum, null);
    }

    @Override
    public SenderNumber[] getSenderNumberList(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/Message/SenderNumber", CorpNum, null, SenderNumber[].class);
    }

    @Override
    public String getSenderNumberMgtURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/Message/?TG=SENDER", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getSentListURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/Message/?TG=BOX", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public Response checkSenderNumber(String CorpNum, String SenderNumber2) throws PopbillException {
        return this.checkSenderNumber(CorpNum, SenderNumber2, null);
    }

    @Override
    public Response checkSenderNumber(String CorpNum, String SenderNumber2, String UserID) throws PopbillException {
        if (SenderNumber2 == null || SenderNumber2.equals("")) {
            throw new PopbillException(-99999999L, "\ubc1c\uc2e0\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Message/CheckSenderNumber/" + SenderNumber2, CorpNum, UserID, Response.class);
    }

    @Override
    public Response cancelReservebyRCV(String CorpNum, String receiptNum, String receiveNum) throws PopbillException {
        return this.cancelReservebyRCV(CorpNum, receiptNum, receiveNum, null);
    }

    @Override
    public Response cancelReservebyRCV(String CorpNum, String receiptNum, String receiveNum, String UserID) throws PopbillException {
        if (receiptNum == null || receiptNum.equals("")) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receiveNum == null || receiveNum.equals("")) {
            throw new PopbillException(-99999999L, "\uc218\uc2e0\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(receiveNum);
        return this.httppost("/Message/" + receiptNum + "/Cancel", CorpNum, PostData, UserID, Response.class);
    }

    @Override
    public Response cancelReserveRNbyRCV(String CorpNum, String requestNum, String receiveNum) throws PopbillException {
        return this.cancelReserveRNbyRCV(CorpNum, requestNum, receiveNum, null);
    }

    @Override
    public Response cancelReserveRNbyRCV(String CorpNum, String requestNum, String receiveNum, String UserID) throws PopbillException {
        if (requestNum == null || requestNum.equals("")) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\uc694\uccad\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receiveNum == null || receiveNum.equals("")) {
            throw new PopbillException(-99999999L, "\uc218\uc2e0\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(receiveNum);
        return this.httppost("/Message/Cancel/" + requestNum, CorpNum, PostData, UserID, Response.class);
    }

    protected class ReceiptResponse {
        public String receiptNum;

        protected ReceiptResponse() {
        }
    }

    protected class SendRequest {
        public String snd;
        public String sndnm;
        public String content;
        public String subject;
        public String sndDT;
        public Boolean adsYN;
        public String requestNum;
        public Message[] msgs;

        protected SendRequest() {
        }
    }
}

