/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api.statement;

import com.popbill.api.AttachedFile;
import com.popbill.api.BaseServiceImp;
import com.popbill.api.ChargeInfo;
import com.popbill.api.EmailSendConfig;
import com.popbill.api.PopbillException;
import com.popbill.api.Response;
import com.popbill.api.SMTIssueResponse;
import com.popbill.api.StatementService;
import com.popbill.api.statement.Statement;
import com.popbill.api.statement.StatementInfo;
import com.popbill.api.statement.StatementLog;
import com.popbill.api.statement.StmtSearchResult;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StatementServiceImp
extends BaseServiceImp
implements StatementService {
    @Override
    protected List<String> getScopes() {
        return Arrays.asList("121", "122", "123", "124", "125", "126");
    }

    @Override
    public String getURL(String CorpNum, String TOGO) throws PopbillException {
        return this.getURL(CorpNum, null, TOGO);
    }

    @Override
    public String getURL(String CorpNum, String UserID, String TOGO) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/Statement?TG=" + TOGO, CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public float getUnitCost(String CorpNum, int ItemCode) throws PopbillException {
        BaseServiceImp.UnitCostResponse response = this.httpget("/Statement/" + ItemCode + "?cfg=UNITCOST", CorpNum, null, BaseServiceImp.UnitCostResponse.class);
        return response.unitCost;
    }

    @Override
    public boolean checkMgtKeyInUse(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        try {
            StatementInfo info = this.httpget("/Statement/" + ItemCode + "/" + MgtKey, CorpNum, null, StatementInfo.class);
            return !(info.getItemKey() == null || info.getItemKey().isEmpty());
        }
        catch (PopbillException PE) {
            if (PE.getCode() == -12000004L) {
                return false;
            }
            throw PE;
        }
    }

    @Override
    public Response register(String CorpNum, Statement statement) throws PopbillException {
        return this.register(CorpNum, statement, null);
    }

    @Override
    public Response register(String CorpNum, Statement statement, String UserID) throws PopbillException {
        String PostData = this.toJsonString(statement);
        return this.httppost("/Statement", CorpNum, PostData, UserID, Response.class);
    }

    @Override
    public Response update(String CorpNum, int ItemCode, String MgtKey, Statement statement) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.update(CorpNum, ItemCode, MgtKey, statement, null);
    }

    @Override
    public Response update(String CorpNum, int ItemCode, String MgtKey, Statement statement, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(statement);
        return this.httppost("/Statement/" + ItemCode + "/" + MgtKey, CorpNum, PostData, UserID, "PATCH", Response.class);
    }

    @Override
    public Response delete(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.delete(CorpNum, ItemCode, MgtKey, null);
    }

    @Override
    public Response delete(String CorpNum, int ItemCode, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/Statement/" + ItemCode + "/" + MgtKey, CorpNum, null, UserID, "DELETE", Response.class);
    }

    @Override
    public Response issue(String CorpNum, int ItemCode, String MgtKey, String Memo) throws PopbillException {
        return this.issue(CorpNum, ItemCode, MgtKey, Memo, null, null);
    }

    @Override
    public Response issue(String CorpNum, int ItemCode, String MgtKey, String Memo, String UserID) throws PopbillException {
        return this.issue(CorpNum, ItemCode, MgtKey, Memo, null, UserID);
    }

    @Override
    public Response issue(String CorpNum, int ItemCode, String MgtKey, String Memo, String EmailSubject, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        MemoRequest request = new MemoRequest();
        request.memo = Memo;
        request.emailSubject = EmailSubject;
        String PostData = this.toJsonString(request);
        return this.httppost("/Statement/" + ItemCode + "/" + MgtKey, CorpNum, PostData, UserID, "ISSUE", Response.class);
    }

    @Override
    public Response cancel(String CorpNum, int ItemCode, String MgtKey, String Memo) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.cancel(CorpNum, ItemCode, MgtKey, Memo, null);
    }

    @Override
    public Response cancel(String CorpNum, int ItemCode, String MgtKey, String Memo, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        MemoRequest request = new MemoRequest();
        request.memo = Memo;
        String PostData = this.toJsonString(request);
        return this.httppost("/Statement/" + ItemCode + "/" + MgtKey, CorpNum, PostData, UserID, "CANCEL", Response.class);
    }

    @Override
    public Response sendEmail(String CorpNum, int ItemCode, String MgtKey, String Receiver2) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.sendEmail(CorpNum, ItemCode, MgtKey, Receiver2, null);
    }

    @Override
    public Response sendEmail(String CorpNum, int ItemCode, String MgtKey, String Receiver2, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ResendRequest request = new ResendRequest();
        request.receiver = Receiver2;
        String PostData = this.toJsonString(request);
        return this.httppost("/Statement/" + ItemCode + "/" + MgtKey, CorpNum, PostData, UserID, "EMAIL", Response.class);
    }

    @Override
    public Response sendSMS(String CorpNum, int ItemCode, String MgtKey, String Sender, String Receiver2, String Contents) throws PopbillException {
        return this.sendSMS(CorpNum, ItemCode, MgtKey, Sender, Receiver2, Contents, null);
    }

    @Override
    public Response sendSMS(String CorpNum, int ItemCode, String MgtKey, String Sender, String Receiver2, String Contents, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ResendRequest request = new ResendRequest();
        request.sender = Sender;
        request.receiver = Receiver2;
        request.contents = Contents;
        String PostData = this.toJsonString(request);
        return this.httppost("/Statement/" + ItemCode + "/" + MgtKey, CorpNum, PostData, UserID, "SMS", Response.class);
    }

    @Override
    public Response sendFAX(String CorpNum, int ItemCode, String MgtKey, String Sender, String Receiver2) throws PopbillException {
        return this.sendFAX(CorpNum, ItemCode, MgtKey, Sender, Receiver2, null);
    }

    @Override
    public Response sendFAX(String CorpNum, int ItemCode, String MgtKey, String Sender, String Receiver2, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ResendRequest request = new ResendRequest();
        request.sender = Sender;
        request.receiver = Receiver2;
        String PostData = this.toJsonString(request);
        return this.httppost("/Statement/" + ItemCode + "/" + MgtKey, CorpNum, PostData, UserID, "FAX", Response.class);
    }

    @Override
    public Statement getDetailInfo(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        return this.getDetailInfo(CorpNum, ItemCode, MgtKey, null);
    }

    @Override
    public Statement getDetailInfo(String CorpNum, int ItemCode, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Statement/" + ItemCode + "/" + MgtKey + "?Detail", CorpNum, null, Statement.class);
    }

    @Override
    public StatementInfo getInfo(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Statement/" + ItemCode + "/" + MgtKey, CorpNum, null, StatementInfo.class);
    }

    @Override
    public StatementInfo[] getInfos(String CorpNum, int ItemCode, String[] MgtKeyList) throws PopbillException {
        if (MgtKeyList == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ubc30\uc5f4\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(MgtKeyList);
        return this.httppost("/Statement/" + ItemCode, CorpNum, PostData, null, StatementInfo[].class);
    }

    @Override
    public StatementLog[] getLogs(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Statement/" + ItemCode + "/" + MgtKey + "/Logs", CorpNum, null, StatementLog[].class);
    }

    @Override
    public String getPopUpURL(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.getPopUpURL(CorpNum, ItemCode, MgtKey, null);
    }

    @Override
    public String getPopUpURL(String CorpNum, int ItemCode, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Statement/" + ItemCode + "/" + MgtKey + "?TG=POPUP", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getViewURL(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.getViewURL(CorpNum, ItemCode, MgtKey, null);
    }

    @Override
    public String getViewURL(String CorpNum, int ItemCode, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Statement/" + ItemCode + "/" + MgtKey + "?TG=VIEW", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getPrintURL(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.getPrintURL(CorpNum, ItemCode, MgtKey, null);
    }

    @Override
    public String getPrintURL(String CorpNum, int ItemCode, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Statement/" + ItemCode + "/" + MgtKey + "?TG=PRINT", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getEPrintURL(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        return this.getEPrintURL(CorpNum, ItemCode, MgtKey, null);
    }

    @Override
    public String getEPrintURL(String CorpNum, int ItemCode, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Statement/" + ItemCode + "/" + MgtKey + "?TG=EPRINT", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getMailURL(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        return this.getMailURL(CorpNum, ItemCode, MgtKey, null);
    }

    @Override
    public String getMailURL(String CorpNum, int ItemCode, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Statement/" + ItemCode + "/" + MgtKey + "?TG=MAIL", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getMassPrintURL(String CorpNum, int ItemCode, String[] MgtKeyList) throws PopbillException {
        return this.getMassPrintURL(CorpNum, ItemCode, MgtKeyList, null);
    }

    @Override
    public String getMassPrintURL(String CorpNum, int ItemCode, String[] MgtKeyList, String UserID) throws PopbillException {
        if (MgtKeyList == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\ubc30\uc5f4\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(MgtKeyList);
        BaseServiceImp.URLResponse response = this.httppost("/Statement/" + ItemCode + "?Print", CorpNum, PostData, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getSealURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/?TG=SEAL", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public Response attachFile(String CorpNum, int ItemCode, String MgtKey, String DisplayName, InputStream FileData) throws PopbillException {
        return this.attachFile(CorpNum, ItemCode, MgtKey, DisplayName, FileData, null);
    }

    @Override
    public Response attachFile(String CorpNum, int ItemCode, String MgtKey, String DisplayName, InputStream FileData, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (DisplayName == null || DisplayName.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud30c\uc77c \ud45c\uc2dc\uba85\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (FileData == null) {
            throw new PopbillException(-99999999L, "\ud30c\uc77c \uc2a4\ud2b8\ub9bc\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ArrayList<BaseServiceImp.UploadFile> files = new ArrayList<BaseServiceImp.UploadFile>();
        BaseServiceImp.UploadFile file = new BaseServiceImp.UploadFile(this);
        file.fileName = DisplayName;
        file.fieldName = "Filedata";
        file.fileData = FileData;
        files.add(file);
        return this.httppostFiles("/Statement/" + ItemCode + "/" + MgtKey + "/Files", CorpNum, null, files, UserID, Response.class);
    }

    @Override
    public AttachedFile[] getFiles(String CorpNum, int ItemCode, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Statement/" + ItemCode + "/" + MgtKey + "/Files", CorpNum, null, AttachedFile[].class);
    }

    @Override
    public Response deleteFile(String CorpNum, int ItemCode, String MgtKey, String FileID) throws PopbillException {
        return this.deleteFile(CorpNum, ItemCode, MgtKey, FileID, null);
    }

    @Override
    public Response deleteFile(String CorpNum, int ItemCode, String MgtKey, String FileID, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (FileID == null || FileID.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud30c\uc77c\uc544\uc774\ub514\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/Statement/" + ItemCode + "/" + MgtKey + "/Files/" + FileID, CorpNum, null, UserID, "DELETE", Response.class);
    }

    @Override
    public String FAXSend(String CorpNum, Statement statement, String sendNum, String receiveNum) throws PopbillException {
        return this.FAXSend(CorpNum, statement, sendNum, receiveNum, null);
    }

    @Override
    public String FAXSend(String CorpNum, Statement statement, String sendNum, String receiveNum, String UserID) throws PopbillException {
        if (sendNum == null || sendNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubc1c\uc2e0\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receiveNum == null || receiveNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc218\uc2e0\ud329\uc2a4\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        statement.setSendNum(sendNum);
        statement.setReceiveNum(receiveNum);
        String PostData = this.toJsonString(statement);
        ReceiptResponse response = this.httppost("/Statement", CorpNum, PostData, UserID, "FAX", ReceiptResponse.class);
        return response.receiptNum;
    }

    @Override
    public SMTIssueResponse registIssue(String CorpNum, Statement statement) throws PopbillException {
        return this.registIssue(CorpNum, statement, null, null, null);
    }

    @Override
    public SMTIssueResponse registIssue(String CorpNum, Statement statement, String memo) throws PopbillException {
        return this.registIssue(CorpNum, statement, memo, null, null);
    }

    @Override
    public SMTIssueResponse registIssue(String CorpNum, Statement statement, String memo, String UserID) throws PopbillException {
        return this.registIssue(CorpNum, statement, memo, UserID, null);
    }

    @Override
    public SMTIssueResponse registIssue(String CorpNum, Statement statement, String memo, String UserID, String emailSubject) throws PopbillException {
        if (memo != null) {
            statement.setMemo(memo);
        }
        if (emailSubject != null) {
            statement.setEmailSubject(emailSubject);
        }
        String PostData = this.toJsonString(statement);
        return this.httppost("/Statement", CorpNum, PostData, UserID, "ISSUE", SMTIssueResponse.class);
    }

    @Override
    public Response attachStatement(String CorpNum, int ItemCode, String MgtKey, int SubItemCode, String SubMgtKey) throws PopbillException {
        DocRequest request = new DocRequest();
        request.ItemCode = SubItemCode;
        request.MgtKey = SubMgtKey;
        String PostData = this.toJsonString(request);
        return this.httppost("/Statement/" + ItemCode + "/" + MgtKey + "/AttachStmt/", CorpNum, PostData, null, Response.class);
    }

    @Override
    public Response detachStatement(String CorpNum, int ItemCode, String MgtKey, int SubItemCode, String SubMgtKey) throws PopbillException {
        DocRequest request = new DocRequest();
        request.ItemCode = SubItemCode;
        request.MgtKey = SubMgtKey;
        String PostData = this.toJsonString(request);
        return this.httppost("/Statement/" + ItemCode + "/" + MgtKey + "/DetachStmt/", CorpNum, PostData, null, Response.class);
    }

    @Override
    public StmtSearchResult search(String CorpNum, String DType, String SDate, String EDate, String[] State, int[] ItemCode, int Page, int PerPage, String Order) throws PopbillException {
        return this.search(CorpNum, DType, SDate, EDate, State, ItemCode, "", Page, PerPage, Order);
    }

    @Override
    public StmtSearchResult search(String CorpNum, String DType, String SDate, String EDate, String[] State, int[] ItemCode, String QString, int Page, int PerPage, String Order) throws PopbillException {
        if (DType == null || DType.isEmpty()) {
            throw new PopbillException(-99999999L, "\uac80\uc0c9\uc77c\uc790\uc720\ud615\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (SDate == null || SDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc2dc\uc791\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EDate == null || EDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc885\ub8cc\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/Statement/Search?DType=" + DType;
        uri = uri + "&SDate=" + SDate;
        uri = uri + "&EDate=" + EDate;
        uri = uri + "&State=" + Arrays.toString(State).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&ItemCode=" + Arrays.toString(ItemCode).replaceAll("\\[|\\]|\\s", "");
        if (QString != null && QString != "") {
            try {
                uri = uri + "&QString=" + URLEncoder.encode(QString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PopbillException(-99999999L, "\uac80\uc0c9\uc5b4(QString) \uc778\ucf54\ub529 \uc624\ub958");
            }
        }
        uri = uri + "&Page=" + Integer.toString(Page);
        uri = uri + "&PerPage=" + Integer.toString(PerPage);
        uri = uri + "&Order=" + Order;
        return this.httpget(uri, CorpNum, null, StmtSearchResult.class);
    }

    @Override
    public ChargeInfo getChargeInfo(String CorpNum, int ItemCode) throws PopbillException {
        return this.httpget("/Statement/ChargeInfo/" + Integer.toString(ItemCode), CorpNum, null, ChargeInfo.class);
    }

    @Override
    public Response updateEmailConfig(String CorpNum, String EmailType, Boolean SendYN) throws PopbillException {
        return this.updateEmailConfig(CorpNum, EmailType, SendYN, null);
    }

    @Override
    public Response updateEmailConfig(String CorpNum, String EmailType, Boolean SendYN, String UserID) throws PopbillException {
        if (SendYN == null) {
            throw new PopbillException(-99999999L, "\uba54\uc77c\uc804\uc1a1\uc5ec\ubd80(SendYN)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EmailType == null || EmailType.isEmpty()) {
            throw new PopbillException(-99999999L, "\uba54\uc77c\uc804\uc1a1\uc720\ud615(EmailType)\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/Statement/EmailSendConfig?EmailType=" + EmailType + "&SendYN=" + String.valueOf(SendYN), CorpNum, null, UserID, "", Response.class);
    }

    @Override
    public EmailSendConfig[] listEmailConfig(String CorpNum) throws PopbillException {
        return this.httpget("/Statement/EmailSendConfig", CorpNum, null, EmailSendConfig[].class);
    }

    @Override
    public EmailSendConfig[] listEmailConfig(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/Statement/EmailSendConfig", CorpNum, UserID, EmailSendConfig[].class);
    }

    protected class DocRequest {
        public int ItemCode;
        public String MgtKey;

        protected DocRequest() {
        }
    }

    protected class ReceiptResponse {
        public String receiptNum;

        protected ReceiptResponse() {
        }
    }

    protected class ResendRequest {
        public String receiver;
        public String sender = null;
        public String contents = null;

        protected ResendRequest() {
        }
    }

    protected class MemoRequest {
        public String memo;
        public String emailSubject;

        protected MemoRequest() {
        }
    }
}

