/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api.taxinvoice;

import com.popbill.api.AttachedFile;
import com.popbill.api.BaseServiceImp;
import com.popbill.api.BulkResponse;
import com.popbill.api.ChargeInfo;
import com.popbill.api.EmailSendConfig;
import com.popbill.api.IssueResponse;
import com.popbill.api.PopbillException;
import com.popbill.api.Response;
import com.popbill.api.TaxinvoiceCertificate;
import com.popbill.api.TaxinvoiceService;
import com.popbill.api.taxinvoice.BulkTaxinvoiceResult;
import com.popbill.api.taxinvoice.BulkTaxinvoiceSubmit;
import com.popbill.api.taxinvoice.EmailPublicKey;
import com.popbill.api.taxinvoice.MgtKeyType;
import com.popbill.api.taxinvoice.SendToNTSConfig;
import com.popbill.api.taxinvoice.TISearchResult;
import com.popbill.api.taxinvoice.Taxinvoice;
import com.popbill.api.taxinvoice.TaxinvoiceInfo;
import com.popbill.api.taxinvoice.TaxinvoiceLog;
import com.popbill.api.taxinvoice.TaxinvoiceXML;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class TaxinvoiceServiceImp
extends BaseServiceImp
implements TaxinvoiceService {
    @Override
    protected List<String> getScopes() {
        return Arrays.asList("110");
    }

    @Override
    public boolean checkMgtKeyInUse(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        try {
            TaxinvoiceInfo info = this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, null, TaxinvoiceInfo.class);
            return !(info.getItemKey() == null || info.getItemKey().isEmpty());
        }
        catch (PopbillException PE) {
            if (PE.getCode() == -11000005L) {
                return false;
            }
            throw PE;
        }
    }

    @Override
    public IssueResponse registIssue(String CorpNum, Taxinvoice taxinvoice, Boolean WriteSpecification) throws PopbillException {
        return this.registIssue(CorpNum, taxinvoice, WriteSpecification, null, false, null, null, null);
    }

    @Override
    public IssueResponse registIssue(String CorpNum, Taxinvoice taxinvoice, String Memo, Boolean ForceIssue) throws PopbillException {
        return this.registIssue(CorpNum, taxinvoice, false, Memo, ForceIssue, null, null, null);
    }

    @Override
    public IssueResponse registIssue(String CorpNum, Taxinvoice taxinvoice, Boolean WriteSpecification, String Memo, Boolean ForceIssue, String DealInvoiceKey) throws PopbillException {
        return this.registIssue(CorpNum, taxinvoice, WriteSpecification, Memo, ForceIssue, DealInvoiceKey, null, null);
    }

    @Override
    public IssueResponse registIssue(String CorpNum, Taxinvoice taxinvoice, Boolean WriteSpecification, String Memo, Boolean ForceIssue, String DealInvoiceKey, String EmailSubject, String UserID) throws PopbillException {
        if (taxinvoice == null) {
            throw new PopbillException(-99999999L, "\uc138\uae08\uacc4\uc0b0\uc11c \uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (WriteSpecification.booleanValue()) {
            taxinvoice.setWriteSpecification(true);
        }
        if (Memo != null) {
            taxinvoice.setMemo(Memo);
        }
        if (ForceIssue.booleanValue()) {
            taxinvoice.setForceIssue(true);
        }
        if (DealInvoiceKey != null) {
            taxinvoice.setDealInvoiceMgtKey(DealInvoiceKey);
        }
        if (EmailSubject != null) {
            taxinvoice.setEmailSubject(EmailSubject);
        }
        String PostData = this.toJsonString(taxinvoice);
        return this.httppost("/Taxinvoice", CorpNum, PostData, UserID, "ISSUE", IssueResponse.class);
    }

    @Override
    public BulkResponse bulkSubmit(String CorpNum, String SubmitID, List<Taxinvoice> taxinvoiceList, boolean ForceIssue) throws PopbillException {
        return this.bulkSubmit(CorpNum, SubmitID, taxinvoiceList, ForceIssue, null);
    }

    @Override
    public BulkResponse bulkSubmit(String CorpNum, String SubmitID, List<Taxinvoice> taxinvoiceList, boolean ForceIssue, String UserID) throws PopbillException {
        if (SubmitID == null || SubmitID.equals("")) {
            throw new PopbillException(-99999999L, "\uc81c\ucd9c\uc544\uc774\ub514(SubmitID)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (taxinvoiceList == null) {
            throw new PopbillException(-99999999L, "\uc138\uae08\uacc4\uc0b0\uc11c \uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BulkTaxinvoiceSubmit tx = new BulkTaxinvoiceSubmit();
        tx.setForceIssue(ForceIssue);
        tx.setInvoices(taxinvoiceList);
        String PostData = this.toJsonString(tx);
        return this.httpBulkPost("/Taxinvoice", CorpNum, SubmitID, PostData, UserID, "BULKISSUE", BulkResponse.class);
    }

    @Override
    public BulkTaxinvoiceResult getBulkResult(String CorpNum, String SubmitID) throws PopbillException {
        return this.getBulkResult(CorpNum, SubmitID, null);
    }

    @Override
    public BulkTaxinvoiceResult getBulkResult(String CorpNum, String SubmitID, String UserID) throws PopbillException {
        if (SubmitID == null) {
            throw new PopbillException(-99999999L, "\uc81c\ucd9c\uc544\uc774\ub514(SubmitID)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Taxinvoice/BULK/" + SubmitID + "/State", CorpNum, UserID, BulkTaxinvoiceResult.class);
    }

    @Override
    public Response register(String CorpNum, Taxinvoice taxinvoice) throws PopbillException {
        return this.register(CorpNum, taxinvoice, null);
    }

    @Override
    public Response register(String CorpNum, Taxinvoice taxinvoice, String UserID) throws PopbillException {
        return this.register(CorpNum, taxinvoice, UserID, false);
    }

    @Override
    public Response register(String CorpNum, Taxinvoice taxinvoice, String UserID, boolean writeSpecification) throws PopbillException {
        if (taxinvoice == null) {
            throw new PopbillException(-99999999L, "\uc138\uae08\uacc4\uc0b0\uc11c \uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(taxinvoice);
        if (writeSpecification) {
            PostData = "{\"writeSpecification\":true," + PostData.substring(1);
        }
        return this.httppost("/Taxinvoice", CorpNum, PostData, UserID, Response.class);
    }

    @Override
    public Response update(String CorpNum, MgtKeyType KeyType, String MgtKey, Taxinvoice taxinvoice) throws PopbillException {
        return this.update(CorpNum, KeyType, MgtKey, taxinvoice, null);
    }

    @Override
    public Response update(String CorpNum, MgtKeyType KeyType, String MgtKey, Taxinvoice taxinvoice, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (taxinvoice == null) {
            throw new PopbillException(-99999999L, "\uc138\uae08\uacc4\uc0b0\uc11c \uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(taxinvoice);
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "PATCH", Response.class);
    }

    @Override
    public IssueResponse issue(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo) throws PopbillException {
        return this.issue(CorpNum, KeyType, MgtKey, Memo, null);
    }

    @Override
    public IssueResponse issue(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String UserID) throws PopbillException {
        return this.issue(CorpNum, KeyType, MgtKey, Memo, null, false, UserID);
    }

    @Override
    public IssueResponse issue(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, boolean ForceIssue, String UserID) throws PopbillException {
        return this.issue(CorpNum, KeyType, MgtKey, Memo, null, ForceIssue, UserID);
    }

    @Override
    public IssueResponse issue(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String EmailSubject, boolean ForceIssue, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        IssueRequest request = new IssueRequest();
        request.memo = Memo;
        request.emailSubject = EmailSubject;
        request.forceIssue = ForceIssue;
        String PostData = this.toJsonString(request);
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "ISSUE", IssueResponse.class);
    }

    @Override
    public Response cancelIssue(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo) throws PopbillException {
        return this.cancelIssue(CorpNum, KeyType, MgtKey, Memo, null);
    }

    @Override
    public Response cancelIssue(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(new MemoRequest(Memo));
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "CANCELISSUE", Response.class);
    }

    @Override
    public Response registRequest(String CorpNum, Taxinvoice taxinvoice, String Memo) throws PopbillException {
        return this.registRequest(CorpNum, taxinvoice, Memo, "");
    }

    @Override
    public Response registRequest(String CorpNum, Taxinvoice taxinvoice, String Memo, String UserID) throws PopbillException {
        if (taxinvoice == null) {
            throw new PopbillException(-99999999L, "\uc138\uae08\uacc4\uc0b0\uc11c \uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (Memo != null) {
            taxinvoice.setMemo(Memo);
        }
        String PostData = this.toJsonString(taxinvoice);
        return this.httppost("/Taxinvoice", CorpNum, PostData, UserID, "REQUEST", Response.class);
    }

    @Override
    public Response request(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo) throws PopbillException {
        return this.request(CorpNum, KeyType, MgtKey, Memo, null);
    }

    @Override
    public Response request(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(new MemoRequest(Memo));
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "REQUEST", Response.class);
    }

    @Override
    public Response cancelRequest(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo) throws PopbillException {
        return this.cancelRequest(CorpNum, KeyType, MgtKey, Memo, null);
    }

    @Override
    public Response cancelRequest(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(new MemoRequest(Memo));
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "CANCELREQUEST", Response.class);
    }

    @Override
    public Response refuse(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo) throws PopbillException {
        return this.refuse(CorpNum, KeyType, MgtKey, Memo, null);
    }

    @Override
    public Response refuse(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(new MemoRequest(Memo));
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "REFUSE", Response.class);
    }

    @Override
    public Response delete(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        return this.delete(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public Response delete(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, null, UserID, "DELETE", Response.class);
    }

    @Override
    public Response sendToNTS(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        return this.sendToNTS(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public Response sendToNTS(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, null, UserID, "NTS", Response.class);
    }

    @Override
    public TaxinvoiceInfo getInfo(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, null, TaxinvoiceInfo.class);
    }

    @Override
    public TaxinvoiceInfo[] getInfos(String CorpNum, MgtKeyType KeyType, String[] MgtKeyList) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKeyList == null || MgtKeyList.length == 0) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ubaa9\ub85d\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(MgtKeyList);
        return this.httppost("/Taxinvoice/" + KeyType.name(), CorpNum, PostData, null, TaxinvoiceInfo[].class);
    }

    @Override
    public Taxinvoice getDetailInfo(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "?Detail", CorpNum, null, Taxinvoice.class);
    }

    @Override
    public TaxinvoiceXML getXML(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        return this.getXML(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public TaxinvoiceXML getXML(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "?XML", CorpNum, UserID, TaxinvoiceXML.class);
    }

    @Override
    public TISearchResult Search(String CorpNum, MgtKeyType KeyType, String DType, String SDate, String EDate, String[] State, String[] Type2, String[] TaxType, Boolean LateOnly, Integer Page, Integer PerPage, String Order) throws PopbillException {
        return this.Search(CorpNum, KeyType, DType, SDate, EDate, State, Type2, TaxType, null, LateOnly, null, null, null, null, Page, PerPage, Order, null, null, null, null, null);
    }

    @Override
    public TISearchResult Search(String CorpNum, MgtKeyType KeyType, String DType, String SDate, String EDate, String[] State, String[] Type2, String[] TaxType, Boolean LateOnly, String TaxRegIDType, String TaxRegID, String TaxRegIDYN, Integer Page, Integer PerPage, String Order) throws PopbillException {
        return this.Search(CorpNum, KeyType, DType, SDate, EDate, State, Type2, TaxType, null, LateOnly, TaxRegIDType, TaxRegID, TaxRegIDYN, null, Page, PerPage, Order, null, null, null, null, null);
    }

    @Override
    public TISearchResult Search(String CorpNum, MgtKeyType KeyType, String DType, String SDate, String EDate, String[] State, String[] Type2, String[] TaxType, Boolean LateOnly, String TaxRegIDType, String TaxRegID, String TaxRegIDYN, String QString, Integer Page, Integer PerPage, String Order) throws PopbillException {
        return this.Search(CorpNum, KeyType, DType, SDate, EDate, State, Type2, TaxType, null, LateOnly, TaxRegIDType, TaxRegID, TaxRegIDYN, QString, Page, PerPage, Order, null);
    }

    @Override
    public TISearchResult Search(String CorpNum, MgtKeyType KeyType, String DType, String SDate, String EDate, String[] State, String[] Type2, String[] TaxType, Boolean LateOnly, String TaxRegIDType, String TaxRegID, String TaxRegIDYN, String QString, Integer Page, Integer PerPage, String Order, String InterOPYN) throws PopbillException {
        return this.Search(CorpNum, KeyType, DType, SDate, EDate, State, Type2, TaxType, null, LateOnly, TaxRegIDType, TaxRegID, TaxRegIDYN, QString, Page, PerPage, Order, InterOPYN, null, null, null, null);
    }

    @Override
    public TISearchResult Search(String CorpNum, MgtKeyType KeyType, String DType, String SDate, String EDate, String[] State, String[] Type2, String[] TaxType, String[] IssueType, Boolean LateOnly, String TaxRegIDType, String TaxRegID, String TaxRegIDYN, String QString, Integer Page, Integer PerPage, String Order, String InterOPYN) throws PopbillException {
        return this.Search(CorpNum, KeyType, DType, SDate, EDate, State, Type2, TaxType, null, LateOnly, TaxRegIDType, TaxRegID, TaxRegIDYN, QString, Page, PerPage, Order, InterOPYN, null, null, null, null);
    }

    @Override
    public TISearchResult Search(String CorpNum, MgtKeyType KeyType, String DType, String SDate, String EDate, String[] State, String[] Type2, String[] TaxType, String[] IssueType, Boolean LateOnly, String TaxRegIDType, String TaxRegID, String TaxRegIDYN, String QString, Integer Page, Integer PerPage, String Order, String InterOPYN, String[] RegType) throws PopbillException {
        return this.Search(CorpNum, KeyType, DType, SDate, EDate, State, Type2, TaxType, null, LateOnly, TaxRegIDType, TaxRegID, TaxRegIDYN, QString, Page, PerPage, Order, InterOPYN, null, null, null, null);
    }

    @Override
    public TISearchResult Search(String CorpNum, MgtKeyType KeyType, String DType, String SDate, String EDate, String[] State, String[] Type2, String[] TaxType, String[] IssueType, Boolean LateOnly, String TaxRegIDType, String TaxRegID, String TaxRegIDYN, String QString, Integer Page, Integer PerPage, String Order, String InterOPYN, String[] RegType, String[] CloseDownState, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (DType == null || DType.isEmpty()) {
            throw new PopbillException(-99999999L, "\uac80\uc0c9\uc77c\uc790 \uc720\ud615\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (SDate == null || SDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc2dc\uc791\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EDate == null || EDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc885\ub8cc\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/Taxinvoice/" + (Object)((Object)KeyType);
        uri = uri + "?DType=" + DType;
        uri = uri + "&SDate=" + SDate;
        uri = uri + "&EDate=" + EDate;
        uri = uri + "&State=" + Arrays.toString(State).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&Type=" + Arrays.toString(Type2).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&TaxType=" + Arrays.toString(TaxType).replaceAll("\\[|\\]|\\s", "");
        if (IssueType != null) {
            uri = uri + "&IssueType=" + Arrays.toString(IssueType).replaceAll("\\[|\\]|\\s", "");
        }
        if (RegType != null) {
            uri = uri + "&RegType=" + Arrays.toString(RegType).replaceAll("\\[|\\]|\\s", "");
        }
        if (CloseDownState != null) {
            uri = uri + "&CloseDownState=" + Arrays.toString(CloseDownState).replaceAll("\\[|\\]|\\s", "");
        }
        if (LateOnly != null) {
            uri = LateOnly != false ? uri + "&LateOnly=1" : uri + "&LateOnly=0";
        }
        if (TaxRegIDType != null && TaxRegIDType != "") {
            uri = uri + "&TaxRegIDType=" + TaxRegIDType;
        }
        if (TaxRegID != null && TaxRegID != "") {
            uri = uri + "&TaxRegID=" + TaxRegID;
        }
        if (TaxRegIDYN != null && TaxRegIDYN != "") {
            uri = uri + "&TaxRegIDYN=" + TaxRegIDYN;
        }
        if (InterOPYN != null && InterOPYN != "") {
            uri = uri + "&InterOPYN=" + InterOPYN;
        }
        if (QString != null && QString != "") {
            try {
                uri = uri + "&QString=" + URLEncoder.encode(QString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PopbillException(-99999999L, "\uac80\uc0c9\uc5b4(QString) \uc778\ucf54\ub529 \uc624\ub958");
            }
        }
        if (MgtKey != null && MgtKey != "") {
            uri = uri + "&MgtKey=" + MgtKey;
        }
        uri = uri + "&Page=" + Integer.toString(Page);
        uri = uri + "&PerPage=" + Integer.toString(PerPage);
        uri = uri + "&Order=" + Order;
        return this.httpget(uri, CorpNum, UserID, TISearchResult.class);
    }

    @Override
    public TaxinvoiceLog[] getLogs(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "/Logs", CorpNum, null, TaxinvoiceLog[].class);
    }

    @Override
    public String getURL(String CorpNum, String TOGO) throws PopbillException {
        return this.getURL(CorpNum, null, TOGO);
    }

    @Override
    public String getURL(String CorpNum, String UserID, String TOGO) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/Taxinvoice?TG=" + TOGO, CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getPopUpURL(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        return this.getPopUpURL(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public String getPopUpURL(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "?TG=POPUP", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getViewURL(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        return this.getViewURL(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public String getViewURL(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "?TG=VIEW", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getPrintURL(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        return this.getPrintURL(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public String getPrintURL(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "?TG=PRINT", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getOldPrintURL(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        return this.getOldPrintURL(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public String getOldPrintURL(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "?TG=PRINTOLD", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getEPrintURL(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        return this.getEPrintURL(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public String getEPrintURL(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "?TG=EPRINT", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getMassPrintURL(String CorpNum, MgtKeyType KeyType, String[] MgtKeyList) throws PopbillException {
        return this.getMassPrintURL(CorpNum, KeyType, MgtKeyList, null);
    }

    @Override
    public String getMassPrintURL(String CorpNum, MgtKeyType KeyType, String[] MgtKeyList, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKeyList == null || MgtKeyList.length == 0) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ubaa9\ub85d\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(MgtKeyList);
        BaseServiceImp.URLResponse response = this.httppost("/Taxinvoice/" + KeyType.name() + "?Print", CorpNum, PostData, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getMailURL(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.getMailURL(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public String getMailURL(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "?TG=MAIL", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getPDFURL(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        return this.getPDFURL(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public String getPDFURL(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "?TG=PDF", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getSealURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/?TG=SEAL", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public Response attachFile(String CorpNum, MgtKeyType KeyType, String MgtKey, String DisplayName, InputStream FileData) throws PopbillException {
        return this.attachFile(CorpNum, KeyType, MgtKey, DisplayName, FileData, null);
    }

    @Override
    public Response attachFile(String CorpNum, MgtKeyType KeyType, String MgtKey, String DisplayName, InputStream FileData, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (DisplayName == null || DisplayName.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud30c\uc77c \ud45c\uc2dc\uba85\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (FileData == null) {
            throw new PopbillException(-99999999L, "\ud30c\uc77c \uc2a4\ud2b8\ub9bc\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ArrayList<BaseServiceImp.UploadFile> files = new ArrayList<BaseServiceImp.UploadFile>();
        BaseServiceImp.UploadFile file = new BaseServiceImp.UploadFile();
        file.fileName = DisplayName;
        file.fieldName = "Filedata";
        file.fileData = FileData;
        files.add(file);
        return this.httppostFiles("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "/Files", CorpNum, null, files, UserID, Response.class);
    }

    @Override
    public Response deleteFile(String CorpNum, MgtKeyType KeyType, String MgtKey, String FileID) throws PopbillException {
        return this.deleteFile(CorpNum, KeyType, MgtKey, FileID, null);
    }

    @Override
    public Response deleteFile(String CorpNum, MgtKeyType KeyType, String MgtKey, String FileID, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (FileID == null || FileID.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud30c\uc77c\uc544\uc774\ub514\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "/Files/" + FileID, CorpNum, null, UserID, "DELETE", Response.class);
    }

    @Override
    public AttachedFile[] getFiles(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "/Files", CorpNum, null, AttachedFile[].class);
    }

    @Override
    public Response sendEmail(String CorpNum, MgtKeyType KeyType, String MgtKey, String Receiver2) throws PopbillException {
        return this.sendEmail(CorpNum, KeyType, MgtKey, Receiver2, null);
    }

    @Override
    public Response sendEmail(String CorpNum, MgtKeyType KeyType, String MgtKey, String Receiver2, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ResendRequest request = new ResendRequest();
        request.receiver = Receiver2;
        String PostData = this.toJsonString(request);
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "EMAIL", Response.class);
    }

    @Override
    public Response sendSMS(String CorpNum, MgtKeyType KeyType, String MgtKey, String Sender, String Receiver2, String Contents) throws PopbillException {
        return this.sendSMS(CorpNum, KeyType, MgtKey, Sender, Receiver2, Contents, null);
    }

    @Override
    public Response sendSMS(String CorpNum, MgtKeyType KeyType, String MgtKey, String Sender, String Receiver2, String Contents, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ResendRequest request = new ResendRequest();
        request.sender = Sender;
        request.receiver = Receiver2;
        request.contents = Contents;
        String PostData = this.toJsonString(request);
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "SMS", Response.class);
    }

    @Override
    public Response sendFAX(String CorpNum, MgtKeyType KeyType, String MgtKey, String Sender, String Receiver2) throws PopbillException {
        return this.sendFAX(CorpNum, KeyType, MgtKey, Sender, Receiver2, null);
    }

    @Override
    public Response sendFAX(String CorpNum, MgtKeyType KeyType, String MgtKey, String Sender, String Receiver2, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ResendRequest request = new ResendRequest();
        request.sender = Sender;
        request.receiver = Receiver2;
        String PostData = this.toJsonString(request);
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "FAX", Response.class);
    }

    @Override
    public Response attachStatement(String CorpNum, MgtKeyType KeyType, String MgtKey, int SubItemCode, String SubMgtKey) throws PopbillException {
        DocRequest request = new DocRequest();
        request.ItemCode = Integer.toString(SubItemCode);
        request.MgtKey = SubMgtKey;
        String PostData = this.toJsonString(request);
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "/AttachStmt", CorpNum, PostData, null, "", Response.class);
    }

    @Override
    public Response detachStatement(String CorpNum, MgtKeyType KeyType, String MgtKey, int SubItemCode, String SubMgtKey) throws PopbillException {
        DocRequest request = new DocRequest();
        request.ItemCode = Integer.toString(SubItemCode);
        request.MgtKey = SubMgtKey;
        String PostData = this.toJsonString(request);
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "/DetachStmt", CorpNum, PostData, null, "", Response.class);
    }

    @Override
    public EmailPublicKey[] getEmailPublicKeys(String CorpNum) throws PopbillException {
        return this.httpget("/Taxinvoice/EmailPublicKeys", CorpNum, null, EmailPublicKey[].class);
    }

    @Override
    public Response assignMgtKey(String corpNum, MgtKeyType keyType, String itemKey, String mgtKey) throws PopbillException {
        return this.assignMgtKey(corpNum, keyType, itemKey, mgtKey, null);
    }

    @Override
    public Response assignMgtKey(String corpNum, MgtKeyType keyType, String itemKey, String mgtKey, String userID) throws PopbillException {
        if (itemKey == null || itemKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc544\uc774\ud15c\ud0a4(ItemKey)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (mgtKey == null || mgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638(MgtKey)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = "MgtKey=" + mgtKey;
        return this.httppost("/Taxinvoice/" + itemKey + "/" + keyType.name(), corpNum, PostData, userID, "", Response.class, "application/x-www-form-urlencoded; charset=utf-8");
    }

    @Override
    public EmailSendConfig[] listEmailConfig(String CorpNum) throws PopbillException {
        return this.httpget("/Taxinvoice/EmailSendConfig", CorpNum, null, EmailSendConfig[].class);
    }

    @Override
    public EmailSendConfig[] listEmailConfig(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/Taxinvoice/EmailSendConfig", CorpNum, UserID, EmailSendConfig[].class);
    }

    @Override
    public Response updateEmailConfig(String CorpNum, String EmailType, Boolean SendYN) throws PopbillException {
        return this.updateEmailConfig(CorpNum, EmailType, SendYN, null);
    }

    @Override
    public Response updateEmailConfig(String CorpNum, String EmailType, Boolean SendYN, String UserID) throws PopbillException {
        if (SendYN == null) {
            throw new PopbillException(-99999999L, "\uba54\uc77c\uc804\uc1a1\uc5ec\ubd80(SendYN)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EmailType == null || EmailType.isEmpty()) {
            throw new PopbillException(-99999999L, "\uba54\uc77c\uc804\uc1a1\uc720\ud615(EmailType)\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/Taxinvoice/EmailSendConfig?EmailType=" + EmailType + "&SendYN=" + String.valueOf(SendYN), CorpNum, null, UserID, "", Response.class);
    }

    @Override
    public boolean getSendToNTSConfig(String CorpNum) throws PopbillException {
        return this.getSendToNTSConfig(CorpNum, null);
    }

    @Override
    public boolean getSendToNTSConfig(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/Taxinvoice/SendToNTSConfig", CorpNum, UserID, SendToNTSConfig.class).getSendToNTS();
    }

    @Override
    public String getTaxCertURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/?TG=CERT", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public Date getCertificateExpireDate(String CorpNum) throws PopbillException {
        CertResponse response = this.httpget("/Taxinvoice?cfg=CERT", CorpNum, null, CertResponse.class);
        try {
            return new SimpleDateFormat("yyyyMMddHHmmss").parse(response.certificateExpiration);
        }
        catch (ParseException e) {
            throw new PopbillException(-99999999L, "\ub0a0\uc790\ud615\uc2dd \ud3ec\ub9f7\ubcc0\ud658 \uc2e4\ud328[" + response.certificateExpiration + "]", e);
        }
    }

    @Override
    public Response checkCertValidation(String CorpNum) throws PopbillException {
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc5f0\ub3d9\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638(CorpNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Taxinvoice/CertCheck", CorpNum, null, Response.class);
    }

    @Override
    public TaxinvoiceCertificate getTaxCertInfo(String CorpNum) throws PopbillException {
        return this.getTaxCertInfo(CorpNum, null);
    }

    @Override
    public TaxinvoiceCertificate getTaxCertInfo(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/Taxinvoice/Certificate", CorpNum, UserID, TaxinvoiceCertificate.class);
    }

    @Override
    public float getUnitCost(String CorpNum) throws PopbillException {
        BaseServiceImp.UnitCostResponse response = this.httpget("/Taxinvoice?cfg=UNITCOST", CorpNum, null, BaseServiceImp.UnitCostResponse.class);
        return response.unitCost;
    }

    @Override
    public ChargeInfo getChargeInfo(String CorpNum) throws PopbillException {
        return this.httpget("/Taxinvoice/ChargeInfo", CorpNum, null, ChargeInfo.class);
    }

    @Override
    public Response send(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo) throws PopbillException {
        return this.send(CorpNum, KeyType, MgtKey, Memo, null);
    }

    @Override
    public Response send(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String UserID) throws PopbillException {
        return this.send(CorpNum, KeyType, MgtKey, Memo, null, UserID);
    }

    @Override
    public Response send(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String EmailSubject, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        SendRequest request = new SendRequest();
        request.memo = Memo;
        request.emailSubject = EmailSubject;
        String PostData = this.toJsonString(request);
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "SEND", Response.class);
    }

    @Override
    public Response cancelSend(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo) throws PopbillException {
        return this.cancelSend(CorpNum, KeyType, MgtKey, Memo, null);
    }

    @Override
    public Response cancelSend(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(new MemoRequest(Memo));
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "CANCELSEND", Response.class);
    }

    @Override
    public Response accept(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo) throws PopbillException {
        return this.accept(CorpNum, KeyType, MgtKey, Memo, null);
    }

    @Override
    public Response accept(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(new MemoRequest(Memo));
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "ACCEPT", Response.class);
    }

    @Override
    public Response deny(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo) throws PopbillException {
        return this.deny(CorpNum, KeyType, MgtKey, Memo, null);
    }

    @Override
    public Response deny(String CorpNum, MgtKeyType KeyType, String MgtKey, String Memo, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(new MemoRequest(Memo));
        return this.httppost("/Taxinvoice/" + KeyType.name() + "/" + MgtKey, CorpNum, PostData, UserID, "DENY", Response.class);
    }

    @Override
    public byte[] getPDF(String CorpNum, MgtKeyType KeyType, String MgtKey) throws PopbillException {
        return this.getPDF(CorpNum, KeyType, MgtKey, null);
    }

    @Override
    public byte[] getPDF(String CorpNum, MgtKeyType KeyType, String MgtKey, String UserID) throws PopbillException {
        if (KeyType == null) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638 \ud615\ud0dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        byte[] result = this.httpget("/Taxinvoice/" + KeyType.name() + "/" + MgtKey + "?PDF", CorpNum, UserID, byte[].class);
        return result;
    }

    protected class DocRequest {
        public String ItemCode;
        public String MgtKey;

        protected DocRequest() {
        }
    }

    protected class ResendRequest {
        public String receiver;
        public String sender = null;
        public String contents = null;

        protected ResendRequest() {
        }
    }

    protected class IssueRequest {
        public String memo;
        public String emailSubject;
        public boolean forceIssue = false;

        protected IssueRequest() {
        }
    }

    protected class SendRequest {
        public String memo;
        public String emailSubject;

        protected SendRequest() {
        }
    }

    protected class MemoRequest {
        public String memo;

        public MemoRequest(String memo) {
            this.memo = memo;
        }
    }

    protected class CertResponse {
        public String certificateExpiration;

        protected CertResponse() {
        }
    }
}

