/*
 * Decompiled with CFR 0.152.
 */
package com.smunity.util;

import com.smunity.dto.AuthRequestDto;
import com.smunity.exception.AuthException;
import com.smunity.exception.code.AuthErrorCode;
import com.smunity.util.LoginUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class FetchUtil {
    private static final String BASE_URL = "https://smul.smu.ac.kr/";

    public static JSONObject fetchInfo(String username, String password) {
        JSONArray response = FetchUtil.fetchData(AuthRequestDto.of(username, password), "UsrSchMng/selectStdInfo.do", "dsStdInfoList");
        return response.getJSONObject(0);
    }

    public static JSONArray fetchCourses(String username, String password) {
        return FetchUtil.fetchData(AuthRequestDto.of(username, password), "UsrRecMatt/list.do", "dsRecMattList");
    }

    private static JSONArray fetchData(AuthRequestDto requestDto, String url, String key) {
        Map<String, String> session = LoginUtil.login(requestDto);
        try {
            HttpURLConnection connection = FetchUtil.createConnection(BASE_URL + url, session);
            connection.getOutputStream().write(FetchUtil.createRequestData(requestDto));
            JSONObject response = FetchUtil.readResponse(connection);
            return response.getJSONArray(key);
        }
        catch (IOException e) {
            throw new AuthException("Failed to fetch data from URL: '%s'.".formatted(url), AuthErrorCode.AUTH_FETCH_FAILURE);
        }
    }

    private static HttpURLConnection createConnection(String url, Map<String, String> session) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        session.forEach((key, value) -> connection.addRequestProperty("Cookie", key + "=" + value));
        connection.setDoOutput(true);
        return connection;
    }

    private static byte[] createRequestData(AuthRequestDto requestDto) {
        return "@d#=@d1#&@d1#tp=dm&_AUTH_MENU_KEY=usrCPsnlInfoUpd-STD&@d1#strStdNo=".concat(requestDto.username()).getBytes();
    }

    private static JSONObject readResponse(HttpURLConnection connection) throws IOException {
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        return new JSONObject(response.toString());
    }
}

