/*
 * Decompiled with CFR 0.152.
 */
package com.smunity.dto;

import lombok.Generated;
import org.json.JSONObject;

public record AuthResponseDto(String username, String name, String email, String department, String secondDepartment) {
    public static AuthResponseDto from(JSONObject obj) {
        return AuthResponseDto.of(obj.getJSONArray("dsStdInfoList").getJSONObject(0));
    }

    private static AuthResponseDto of(JSONObject obj) {
        return AuthResponseDto.builder().username(obj.getString("STDNO")).name(obj.getString("NM_KOR")).email(obj.getString("EMAIL")).department(AuthResponseDto.getDepartment(obj.getString("TMP_DEPT_MJR_NM"))).secondDepartment(AuthResponseDto.getSecondDepartment(obj.optString("MJR_CD2"))).build();
    }

    private static String getDepartment(String dept) {
        String[] depts = dept.split(" ");
        return depts[depts.length - 1];
    }

    private static String getSecondDepartment(String dept) {
        return dept.isBlank() ? null : AuthResponseDto.getDepartment(dept);
    }

    @Generated
    public static AuthResponseDtoBuilder builder() {
        return new AuthResponseDtoBuilder();
    }

    @Generated
    public static class AuthResponseDtoBuilder {
        @Generated
        private String username;
        @Generated
        private String name;
        @Generated
        private String email;
        @Generated
        private String department;
        @Generated
        private String secondDepartment;

        @Generated
        AuthResponseDtoBuilder() {
        }

        @Generated
        public AuthResponseDtoBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public AuthResponseDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public AuthResponseDtoBuilder email(String email) {
            this.email = email;
            return this;
        }

        @Generated
        public AuthResponseDtoBuilder department(String department) {
            this.department = department;
            return this;
        }

        @Generated
        public AuthResponseDtoBuilder secondDepartment(String secondDepartment) {
            this.secondDepartment = secondDepartment;
            return this;
        }

        @Generated
        public AuthResponseDto build() {
            return new AuthResponseDto(this.username, this.name, this.email, this.department, this.secondDepartment);
        }

        @Generated
        public String toString() {
            return "AuthResponseDto.AuthResponseDtoBuilder(username=" + this.username + ", name=" + this.name + ", email=" + this.email + ", department=" + this.department + ", secondDepartment=" + this.secondDepartment + ")";
        }
    }
}

