/*
 * Decompiled with CFR 0.152.
 */
package com.smunity.dto;

import lombok.Generated;
import org.json.JSONObject;

public record StatusResponseDto(int total, int completed, int required, int completion) {
    public static StatusResponseDto from(JSONObject obj) {
        return StatusResponseDto.of(obj.getJSONArray("dsCmpDivScrList").getJSONObject(0));
    }

    private static StatusResponseDto of(JSONObject obj) {
        return StatusResponseDto.of(obj.getInt("GRDT_CRIT_CDT"), obj.getInt("TOTAL_GET_CDT"));
    }

    private static StatusResponseDto of(int total, int completed) {
        return StatusResponseDto.builder().total(total).completed(completed).required(StatusResponseDto.calculateRequired(total, completed)).completion(StatusResponseDto.calculateCompletion(total, completed)).build();
    }

    private static int calculateRequired(int total, int completed) {
        return Math.max(0, total - completed);
    }

    private static int calculateCompletion(int total, int completed) {
        return total != 0 ? Math.min(100, completed * 100 / total) : 100;
    }

    @Generated
    public static StatusResponseDtoBuilder builder() {
        return new StatusResponseDtoBuilder();
    }

    @Generated
    public static class StatusResponseDtoBuilder {
        @Generated
        private int total;
        @Generated
        private int completed;
        @Generated
        private int required;
        @Generated
        private int completion;

        @Generated
        StatusResponseDtoBuilder() {
        }

        @Generated
        public StatusResponseDtoBuilder total(int total) {
            this.total = total;
            return this;
        }

        @Generated
        public StatusResponseDtoBuilder completed(int completed) {
            this.completed = completed;
            return this;
        }

        @Generated
        public StatusResponseDtoBuilder required(int required) {
            this.required = required;
            return this;
        }

        @Generated
        public StatusResponseDtoBuilder completion(int completion) {
            this.completion = completion;
            return this;
        }

        @Generated
        public StatusResponseDto build() {
            return new StatusResponseDto(this.total, this.completed, this.required, this.completion);
        }

        @Generated
        public String toString() {
            return "StatusResponseDto.StatusResponseDtoBuilder(total=" + this.total + ", completed=" + this.completed + ", required=" + this.required + ", completion=" + this.completion + ")";
        }
    }
}

