/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kr.dogfoot.hwplib.org.apache.poi.poifs.common.POIFSBigBlockSize;
import kr.dogfoot.hwplib.org.apache.poi.poifs.common.POIFSConstants;
import kr.dogfoot.hwplib.org.apache.poi.poifs.dev.POIFSViewable;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.BATManaged;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DirectoryEntry;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DirectoryNode;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentEntry;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentInputStream;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentNode;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.EntryNode;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.POIFSDocument;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import kr.dogfoot.hwplib.org.apache.poi.poifs.property.DirectoryProperty;
import kr.dogfoot.hwplib.org.apache.poi.poifs.property.Property;
import kr.dogfoot.hwplib.org.apache.poi.poifs.property.PropertyTable;
import kr.dogfoot.hwplib.org.apache.poi.poifs.storage.BATBlock;
import kr.dogfoot.hwplib.org.apache.poi.poifs.storage.BlockAllocationTableReader;
import kr.dogfoot.hwplib.org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import kr.dogfoot.hwplib.org.apache.poi.poifs.storage.BlockList;
import kr.dogfoot.hwplib.org.apache.poi.poifs.storage.BlockWritable;
import kr.dogfoot.hwplib.org.apache.poi.poifs.storage.HeaderBlock;
import kr.dogfoot.hwplib.org.apache.poi.poifs.storage.HeaderBlockWriter;
import kr.dogfoot.hwplib.org.apache.poi.poifs.storage.RawDataBlockList;
import kr.dogfoot.hwplib.org.apache.poi.poifs.storage.SmallBlockTableReader;
import kr.dogfoot.hwplib.org.apache.poi.poifs.storage.SmallBlockTableWriter;
import kr.dogfoot.hwplib.org.apache.poi.util.CloseIgnoringInputStream;
import kr.dogfoot.hwplib.org.apache.poi.util.IOUtils;
import kr.dogfoot.hwplib.org.apache.poi.util.LongField;
import kr.dogfoot.hwplib.org.apache.poi.util.POILogFactory;
import kr.dogfoot.hwplib.org.apache.poi.util.POILogger;

public class POIFSFileSystem
implements POIFSViewable {
    private static final POILogger _logger = POILogFactory.getLogger(POIFSFileSystem.class);
    private PropertyTable _property_table;
    private List _documents;
    private DirectoryNode _root;
    private POIFSBigBlockSize bigBlockSize = POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS;

    public static InputStream createNonClosingInputStream(InputStream is) {
        return new CloseIgnoringInputStream(is);
    }

    public POIFSFileSystem() {
        HeaderBlock header_block = new HeaderBlock(this.bigBlockSize);
        this._property_table = new PropertyTable(header_block);
        this._documents = new ArrayList();
        this._root = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POIFSFileSystem(InputStream stream) throws IOException {
        this();
        RawDataBlockList data_blocks;
        HeaderBlock header_block;
        boolean success = false;
        try {
            header_block = new HeaderBlock(stream);
            this.bigBlockSize = header_block.getBigBlockSize();
            data_blocks = new RawDataBlockList(stream, this.bigBlockSize);
            success = true;
        }
        finally {
            this.closeInputStream(stream, success);
        }
        new BlockAllocationTableReader(header_block.getBigBlockSize(), header_block.getBATCount(), header_block.getBATArray(), header_block.getXBATCount(), header_block.getXBATIndex(), data_blocks);
        PropertyTable properties = new PropertyTable(header_block, data_blocks);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(this.bigBlockSize, data_blocks, properties.getRoot(), header_block.getSBATStart()), data_blocks, properties.getRoot().getChildren(), null, header_block.getPropertyStart());
        this.getRoot().setStorageClsid(properties.getRoot().getStorageClsid());
    }

    private void closeInputStream(InputStream stream, boolean success) {
        if (stream.markSupported() && !(stream instanceof ByteArrayInputStream)) {
            String msg = "POIFS is closing the supplied input stream of type (" + stream.getClass().getName() + ") which supports mark/reset.  This will be a problem for the caller if the stream will still be used.  If that is the case the caller should wrap the input stream to avoid this close logic.  This warning is only temporary and will not be present in future versions of POI.";
            _logger.log(5, msg);
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            if (success) {
                throw new RuntimeException(e);
            }
            e.printStackTrace();
        }
    }

    public static boolean hasPOIFSHeader(InputStream inp) throws IOException {
        inp.mark(8);
        byte[] header = new byte[8];
        IOUtils.readFully(inp, header);
        LongField signature = new LongField(0, header);
        if (inp instanceof PushbackInputStream) {
            PushbackInputStream pin = (PushbackInputStream)inp;
            pin.unread(header);
        } else {
            inp.reset();
        }
        return signature.get() == -2226271756974174256L;
    }

    public DocumentEntry createDocument(InputStream stream, String name) throws IOException {
        return this.getRoot().createDocument(name, stream);
    }

    public DocumentEntry createDocument(String name, int size, POIFSWriterListener writer) throws IOException {
        return this.getRoot().createDocument(name, size, writer);
    }

    public DirectoryEntry createDirectory(String name) throws IOException {
        return this.getRoot().createDirectory(name);
    }

    public void writeFilesystem(OutputStream stream) throws IOException {
        this._property_table.preWrite();
        SmallBlockTableWriter sbtw = new SmallBlockTableWriter(this.bigBlockSize, this._documents, this._property_table.getRoot());
        BlockAllocationTableWriter bat = new BlockAllocationTableWriter(this.bigBlockSize);
        ArrayList<BATManaged> bm_objects = new ArrayList<BATManaged>();
        bm_objects.addAll(this._documents);
        bm_objects.add(this._property_table);
        bm_objects.add(sbtw);
        bm_objects.add(sbtw.getSBAT());
        for (BATManaged bmo : bm_objects) {
            int block_count = bmo.countBlocks();
            if (block_count == 0) continue;
            bmo.setStartBlock(bat.allocateSpace(block_count));
        }
        int batStartBlock = bat.createBlocks();
        HeaderBlockWriter header_block_writer = new HeaderBlockWriter(this.bigBlockSize);
        BATBlock[] xbat_blocks = header_block_writer.setBATBlocks(bat.countBlocks(), batStartBlock);
        header_block_writer.setPropertyStart(this._property_table.getStartBlock());
        header_block_writer.setSBATStart(sbtw.getSBAT().getStartBlock());
        header_block_writer.setSBATBlockCount(sbtw.getSBATBlockCount());
        ArrayList<BlockWritable> writers = new ArrayList<BlockWritable>();
        writers.add(header_block_writer);
        writers.addAll(this._documents);
        writers.add(this._property_table);
        writers.add(sbtw);
        writers.add(sbtw.getSBAT());
        writers.add(bat);
        for (int j = 0; j < xbat_blocks.length; ++j) {
            writers.add(xbat_blocks[j]);
        }
        for (BlockWritable writer : writers) {
            writer.writeBlocks(stream);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("two arguments required: input filename and output filename");
            System.exit(1);
        }
        FileInputStream istream = new FileInputStream(args[0]);
        FileOutputStream ostream = new FileOutputStream(args[1]);
        new POIFSFileSystem(istream).writeFilesystem(ostream);
        istream.close();
        ostream.close();
    }

    public DirectoryNode getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode((DirectoryProperty)this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    public DocumentInputStream createDocumentInputStream(String documentName) throws IOException {
        return this.getRoot().createDocumentInputStream(documentName);
    }

    void addDocument(POIFSDocument document) {
        this._documents.add(document);
        this._property_table.addProperty(document.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directory) {
        this._property_table.addProperty(directory);
    }

    void remove(EntryNode entry) {
        this._property_table.removeProperty(entry.getProperty());
        if (entry.isDocumentEntry()) {
            this._documents.remove(((DocumentNode)entry).getDocument());
        }
    }

    private void processProperties(BlockList small_blocks, BlockList big_blocks, Iterator properties, DirectoryNode dir, int headerPropertiesStartAt) throws IOException {
        while (properties.hasNext()) {
            DirectoryNode parent;
            Property property = (Property)properties.next();
            String name = property.getName();
            DirectoryNode directoryNode = parent = dir == null ? this.getRoot() : dir;
            if (property.isDirectory()) {
                DirectoryNode new_dir = (DirectoryNode)parent.createDirectory(name);
                new_dir.setStorageClsid(property.getStorageClsid());
                this.processProperties(small_blocks, big_blocks, ((DirectoryProperty)property).getChildren(), new_dir, headerPropertiesStartAt);
                continue;
            }
            int startBlock = property.getStartBlock();
            int size = property.getSize();
            POIFSDocument document = null;
            document = property.shouldUseSmallBlocks() ? new POIFSDocument(name, small_blocks.fetchBlocks(startBlock, headerPropertiesStartAt), size) : new POIFSDocument(name, big_blocks.fetchBlocks(startBlock, headerPropertiesStartAt), size);
            parent.createDocument(document);
        }
    }

    @Override
    public Object[] getViewableArray() {
        if (this.preferArray()) {
            return this.getRoot().getViewableArray();
        }
        return new Object[0];
    }

    @Override
    public Iterator getViewableIterator() {
        if (!this.preferArray()) {
            return this.getRoot().getViewableIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public boolean preferArray() {
        return this.getRoot().preferArray();
    }

    @Override
    public String getShortDescription() {
        return "POIFS FileSystem";
    }

    public int getBigBlockSize() {
        return this.bigBlockSize.getBigBlockSize();
    }

    public POIFSBigBlockSize getBigBlockSizeDetails() {
        return this.bigBlockSize;
    }
}

