/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.org.apache.poi.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = "0123456789ABCDEF".toCharArray();
    private static final int[] _shifts = new int[]{60, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0};

    private HexDump() {
    }

    public static void dump(byte[] data, long offset, OutputStream stream, int index, int length) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (data.length == 0) {
            stream.write(("No Data" + System.getProperty("line.separator")).getBytes());
            stream.flush();
            return;
        }
        if (index < 0 || index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index + " into array of length " + data.length);
        }
        if (stream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long display_offset = offset + (long)index;
        StringBuffer buffer = new StringBuffer(74);
        int data_length = Math.min(data.length, index + length);
        for (int j = index; j < data_length; j += 16) {
            int k;
            int chars_read = data_length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append(HexDump.dump(display_offset)).append(' ');
            for (k = 0; k < 16; ++k) {
                if (k < chars_read) {
                    buffer.append(HexDump.dump(data[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
            }
            for (k = 0; k < chars_read; ++k) {
                if (data[k + j] >= 32 && data[k + j] < 127) {
                    buffer.append((char)data[k + j]);
                    continue;
                }
                buffer.append('.');
            }
            buffer.append(EOL);
            stream.write(buffer.toString().getBytes());
            stream.flush();
            buffer.setLength(0);
            display_offset += (long)chars_read;
        }
    }

    public static synchronized void dump(byte[] data, long offset, OutputStream stream, int index) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        HexDump.dump(data, offset, stream, index, data.length - index);
    }

    public static String dump(byte[] data, long offset, int index) {
        if (index < 0 || index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index + " into array of length " + data.length);
        }
        long display_offset = offset + (long)index;
        StringBuffer buffer = new StringBuffer(74);
        for (int j = index; j < data.length; j += 16) {
            int k;
            int chars_read = data.length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append(HexDump.dump(display_offset)).append(' ');
            for (k = 0; k < 16; ++k) {
                if (k < chars_read) {
                    buffer.append(HexDump.dump(data[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
            }
            for (k = 0; k < chars_read; ++k) {
                if (data[k + j] >= 32 && data[k + j] < 127) {
                    buffer.append((char)data[k + j]);
                    continue;
                }
                buffer.append('.');
            }
            buffer.append(EOL);
            display_offset += (long)chars_read;
        }
        return buffer.toString();
    }

    private static String dump(long value) {
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        for (int j = 0; j < 8; ++j) {
            buf.append(_hexcodes[(int)(value >> _shifts[j + _shifts.length - 8]) & 0xF]);
        }
        return buf.toString();
    }

    private static String dump(byte value) {
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        for (int j = 0; j < 2; ++j) {
            buf.append(_hexcodes[value >> _shifts[j + 6] & 0xF]);
        }
        return buf.toString();
    }

    public static String toHex(byte[] value) {
        StringBuffer retVal = new StringBuffer();
        retVal.append('[');
        for (int x = 0; x < value.length; ++x) {
            if (x > 0) {
                retVal.append(", ");
            }
            retVal.append(HexDump.toHex(value[x]));
        }
        retVal.append(']');
        return retVal.toString();
    }

    public static String toHex(short[] value) {
        StringBuffer retVal = new StringBuffer();
        retVal.append('[');
        for (int x = 0; x < value.length; ++x) {
            retVal.append(HexDump.toHex(value[x]));
            retVal.append(", ");
        }
        retVal.append(']');
        return retVal.toString();
    }

    public static String toHex(byte[] value, int bytesPerLine) {
        int digits = (int)Math.round(Math.log(value.length) / Math.log(10.0) + 0.5);
        StringBuffer formatString = new StringBuffer();
        for (int i = 0; i < digits; ++i) {
            formatString.append('0');
        }
        formatString.append(": ");
        DecimalFormat format = new DecimalFormat(formatString.toString());
        StringBuffer retVal = new StringBuffer();
        retVal.append(format.format(0L));
        int i = -1;
        for (int x = 0; x < value.length; ++x) {
            if (++i == bytesPerLine) {
                retVal.append('\n');
                retVal.append(format.format(x));
                i = 0;
            }
            retVal.append(HexDump.toHex(value[x]));
            retVal.append(", ");
        }
        return retVal.toString();
    }

    public static String toHex(short value) {
        return HexDump.toHex(value, 4);
    }

    public static String toHex(byte value) {
        return HexDump.toHex(value, 2);
    }

    public static String toHex(int value) {
        return HexDump.toHex(value, 8);
    }

    public static String toHex(long value) {
        return HexDump.toHex(value, 16);
    }

    private static String toHex(long value, int digits) {
        StringBuffer result = new StringBuffer(digits);
        for (int j = 0; j < digits; ++j) {
            result.append(_hexcodes[(int)(value >> _shifts[j + (16 - digits)] & 0xFL)]);
        }
        return result.toString();
    }

    public static void dump(InputStream in, PrintStream out, int start, int bytesToDump) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        if (bytesToDump == -1) {
            int c = in.read();
            while (c != -1) {
                buf.write(c);
                c = in.read();
            }
        } else {
            int c;
            int bytesRemaining = bytesToDump;
            while (bytesRemaining-- > 0 && (c = in.read()) != -1) {
                buf.write(c);
            }
        }
        byte[] data = buf.toByteArray();
        HexDump.dump(data, 0L, out, start, data.length);
    }

    private static char[] toHexChars(long pValue, int nBytes) {
        int charPos = 2 + nBytes * 2;
        char[] result = new char[charPos];
        long value = pValue;
        do {
            result[--charPos] = _hexcodes[(int)(value & 0xFL)];
            value >>>= 4;
        } while (charPos > 1);
        result[0] = 48;
        result[1] = 120;
        return result;
    }

    public static char[] longToHex(long value) {
        return HexDump.toHexChars(value, 8);
    }

    public static char[] intToHex(int value) {
        return HexDump.toHexChars(value, 4);
    }

    public static char[] shortToHex(int value) {
        return HexDump.toHexChars(value, 2);
    }

    public static char[] byteToHex(int value) {
        return HexDump.toHexChars(value, 1);
    }

    public static void main(String[] args) throws Exception {
        File file = new File(args[0]);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        byte[] b = new byte[(int)file.length()];
        ((InputStream)in).read(b);
        System.out.println(HexDump.dump(b, 0L, 0));
        ((InputStream)in).close();
    }
}

