/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.org.apache.poi.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.CRC32;
import kr.dogfoot.hwplib.org.apache.poi.util.POILogFactory;
import kr.dogfoot.hwplib.org.apache.poi.util.POILogger;

public final class IOUtils {
    private static final POILogger logger = POILogFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int read = 0;
        while (read != -1) {
            read = stream.read(buffer);
            if (read <= 0) continue;
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    public static byte[] toByteArray(ByteBuffer buffer, int length) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0) {
            return buffer.array();
        }
        byte[] data = new byte[length];
        buffer.get(data);
        return data;
    }

    public static int readFully(InputStream in, byte[] b) throws IOException {
        return IOUtils.readFully(in, b, 0, b.length);
    }

    public static int readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int got;
        int total = 0;
        do {
            if ((got = in.read(b, off + total, len - total)) >= 0) continue;
            return total == 0 ? -1 : total;
        } while ((total += got) != len);
        return total;
    }

    public static int readFully(ReadableByteChannel channel, ByteBuffer b) throws IOException {
        int got;
        int total = 0;
        do {
            if ((got = channel.read(b)) >= 0) continue;
            return total == 0 ? -1 : total;
        } while ((total += got) != b.capacity() && b.position() != b.capacity());
        return total;
    }

    public static void copy(InputStream inp, OutputStream out) throws IOException {
        int count;
        byte[] buff = new byte[4096];
        while ((count = inp.read(buff)) != -1) {
            if (count <= 0) continue;
            out.write(buff, 0, count);
        }
    }

    public static long calculateChecksum(byte[] data) {
        CRC32 sum = new CRC32();
        sum.update(data, 0, data.length);
        return sum.getValue();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exc) {
            logger.log(7, (Object)("Unable to close resource: " + exc), exc);
        }
    }
}

