/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.bodytext.paragraph;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.ForParaCharShape;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.ForParaHeader;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.ForParaLineSeg;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.ForParaRangeTag;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.ForParaText;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.ForControl;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.form.ForFormControl;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForGsoControl;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForParagraph {
    private StreamReader sr;
    private short paraHeaderLevel;
    private Paragraph paragraph;

    public void read(Paragraph paragraph, StreamReader sr) throws Exception {
        if (sr.getCurrentRecordHeader().getTagID() != 66) {
            throw new Exception("This is not paragraph.");
        }
        this.sr = sr;
        this.paragraph = paragraph;
        this.paraHeaderLevel = sr.getCurrentRecordHeader().getLevel();
        this.paraHeaderBody();
        this.paraText();
        this.paraCharShape();
        this.paraLineSeg();
        this.paraRangeTag();
        while (!sr.isEndOfStream()) {
            if (!sr.isImmediatelyAfterReadingHeader()) {
                sr.readRecordHeader();
            }
            if (this.isOutOfParagraph(sr) || this.isFollowLastBatangPageInfo(sr) || this.isFollowMemo(sr)) break;
            if (sr.getCurrentRecordHeader().getTagID() == 71) {
                this.control();
                continue;
            }
            this.skipETCRecord();
        }
    }

    private void paraHeaderBody() throws Exception {
        ForParaHeader.read(this.paragraph.getHeader(), this.sr);
    }

    private void paraText() throws Exception {
        if (this.sr.isEndOfStream()) {
            return;
        }
        if (!this.sr.isImmediatelyAfterReadingHeader()) {
            this.sr.readRecordHeader();
        }
        if (this.sr.getCurrentRecordHeader().getTagID() == 67) {
            ForParaText.read(this.paragraph, this.sr);
        }
    }

    private void paraCharShape() throws IOException {
        if (this.sr.isEndOfStream()) {
            return;
        }
        if (!this.sr.isImmediatelyAfterReadingHeader()) {
            this.sr.readRecordHeader();
        }
        if (this.sr.getCurrentRecordHeader().getTagID() == 68) {
            ForParaCharShape.read(this.paragraph, this.sr);
        }
    }

    private void paraLineSeg() throws IOException {
        if (this.sr.isEndOfStream()) {
            return;
        }
        if (!this.sr.isImmediatelyAfterReadingHeader()) {
            this.sr.readRecordHeader();
        }
        if (this.sr.getCurrentRecordHeader().getTagID() == 69) {
            ForParaLineSeg.read(this.paragraph, this.sr);
        }
    }

    private void paraRangeTag() throws Exception {
        if (this.sr.isEndOfStream()) {
            return;
        }
        if (!this.sr.isImmediatelyAfterReadingHeader()) {
            this.sr.readRecordHeader();
        }
        if (this.sr.getCurrentRecordHeader().getTagID() == 70) {
            ForParaRangeTag.read(this.paragraph, this.sr);
        }
    }

    private boolean isOutOfParagraph(StreamReader sr) {
        return this.paraHeaderLevel >= sr.getCurrentRecordHeader().getLevel();
    }

    private boolean isFollowLastBatangPageInfo(StreamReader sr) {
        return this.paraHeaderLevel == 0 && sr.getCurrentRecordHeader().getTagID() == 72 && sr.getCurrentRecordHeader().getLevel() == 1;
    }

    private boolean isFollowMemo(StreamReader sr) {
        return this.paraHeaderLevel == 0 && sr.getCurrentRecordHeader().getTagID() == 93 && sr.getCurrentRecordHeader().getLevel() == 1;
    }

    private void control() throws Exception {
        long id = this.sr.readUInt4();
        if (id == ControlType.Gso.getCtrlId()) {
            ForGsoControl fgc = new ForGsoControl();
            fgc.read(this.paragraph, this.sr);
        } else if (id == ControlType.Form.getCtrlId()) {
            ForFormControl ffc = new ForFormControl();
            ForFormControl.read(this.paragraph, this.sr);
        } else {
            Control c = this.paragraph.addNewControl(id);
            ForControl.read(c, this.sr);
        }
    }

    private void skipETCRecord() throws IOException {
        byte[] buffer = new byte[(int)this.sr.getCurrentRecordHeader().getSize()];
        this.sr.readBytes(buffer);
    }
}

