/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.bodytext.paragraph.control;

import java.io.IOException;
import kr.dogfoot.hwplib.object.RecordHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.footnoteendnote.ListHeaderForFootnodeEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.sectiondefine.NumberShape;
import kr.dogfoot.hwplib.reader.bodytext.ForParagraphList;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForControlEndnote {
    private ControlEndnote en;
    private StreamReader sr;

    public void read(ControlEndnote en, StreamReader sr) throws Exception {
        this.en = en;
        this.sr = sr;
        this.ctrlHeader();
        this.listHeader();
        this.paragraphList();
    }

    private void ctrlHeader() throws IOException {
        CtrlHeaderEndnote h = this.en.getHeader();
        h.setNumber(this.sr.readUInt4());
        h.getBeforeDecorationLetter().setBytes(this.sr.readWChar());
        h.getAfterDecorationLetter().setBytes(this.sr.readWChar());
        h.setNumberShape(NumberShape.valueOf((short)this.sr.readUInt4()));
        if (!this.sr.isEndOfRecord()) {
            h.setInstanceId(this.sr.readUInt4());
        }
    }

    private void listHeader() throws Exception {
        RecordHeader rh = this.sr.readRecordHeader();
        if (rh.getTagID() != 72) {
            throw new Exception("List header must be located.");
        }
        ListHeaderForFootnodeEndnote lh = this.en.getListHeader();
        lh.setParaCount(this.sr.readSInt4());
        lh.getProperty().setValue(this.sr.readUInt4());
        this.sr.skipToEndRecord();
    }

    private void paragraphList() throws Exception {
        ForParagraphList.read(this.en.getParagraphList(), this.sr);
    }
}

