/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.bodytext.paragraph.control;

import java.io.IOException;
import java.util.ArrayList;
import kr.dogfoot.hwplib.object.bodytext.control.ControlTable;
import kr.dogfoot.hwplib.object.bodytext.control.table.Cell;
import kr.dogfoot.hwplib.object.bodytext.control.table.Row;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.bookmark.ForCtrlData;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.part.ForCaption;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.part.ForCtrlHeaderGso;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.tbl.ForCell;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.tbl.ForTable;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForControlTable {
    private ControlTable table;
    private StreamReader sr;

    public void read(ControlTable table, StreamReader sr) throws Exception {
        this.table = table;
        this.sr = sr;
        this.ctrlHeader();
        this.ctrlData();
        this.caption();
        this.table();
        this.rows();
    }

    private void ctrlHeader() throws IOException {
        ForCtrlHeaderGso.read(this.table.getHeader(), this.sr);
    }

    private void ctrlData() throws Exception {
        this.sr.readRecordHeader();
        if (this.sr.getCurrentRecordHeader().getTagID() == 87) {
            this.table.createCtrlData();
            ForCtrlData.read(this.table.getCtrlData(), this.sr);
        }
    }

    private void caption() throws Exception {
        if (!this.sr.isImmediatelyAfterReadingHeader()) {
            this.sr.readRecordHeader();
        }
        if (this.sr.getCurrentRecordHeader().getTagID() == 72) {
            this.table.createCaption();
            ForCaption.read(this.table.getCaption(), this.sr);
        }
    }

    private void table() throws IOException {
        if (!this.sr.isImmediatelyAfterReadingHeader()) {
            this.sr.readRecordHeader();
        }
        if (this.sr.getCurrentRecordHeader().getTagID() == 77) {
            ForTable.read(this.table.getTable(), this.sr);
        }
    }

    private void rows() throws Exception {
        int rowCount = this.table.getTable().getRowCount();
        ArrayList<Integer> cellCountOfRow = this.table.getTable().getCellCountOfRowList();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Row r = this.table.addNewRow();
            this.row(r, cellCountOfRow.get(rowIndex));
        }
    }

    private void row(Row r, int cellCount) throws Exception {
        for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
            Cell c = r.addNewCell();
            ForCell.read(c, this.sr);
        }
    }
}

