/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.docinfo;

import kr.dogfoot.hwplib.object.docinfo.CharShape;
import kr.dogfoot.hwplib.object.docinfo.charshape.CharOffsets;
import kr.dogfoot.hwplib.object.docinfo.charshape.CharSpaces;
import kr.dogfoot.hwplib.object.docinfo.charshape.FaceNameIds;
import kr.dogfoot.hwplib.object.docinfo.charshape.Ratios;
import kr.dogfoot.hwplib.object.docinfo.charshape.RelativeSizes;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForCharShape {
    public static void read(CharShape cs, StreamReader sr) throws Exception {
        ForCharShape.faceNameIds(cs.getFaceNameIds(), sr);
        ForCharShape.ratios(cs.getRatios(), sr);
        ForCharShape.charSpaces(cs.getCharSpaces(), sr);
        ForCharShape.relativeSizes(cs.getRelativeSizes(), sr);
        ForCharShape.charPositions(cs.getCharOffsets(), sr);
        cs.setBaseSize(sr.readSInt4());
        cs.getProperty().setValue(sr.readUInt4());
        cs.setShadowGap1(sr.readSInt1());
        cs.setShadowGap2(sr.readSInt1());
        cs.getCharColor().setValue(sr.readUInt4());
        cs.getUnderLineColor().setValue(sr.readUInt4());
        cs.getShadeColor().setValue(sr.readUInt4());
        cs.getShadowColor().setValue(sr.readUInt4());
        if (!sr.isEndOfRecord() && sr.getFileVersion().isOver(5, 0, 2, 1)) {
            cs.setBorderFillId(sr.readUInt2());
        }
        if (!sr.isEndOfRecord() && sr.getFileVersion().isOver(5, 0, 3, 0)) {
            cs.getStrikeLineColor().setValue(sr.readUInt4());
        }
    }

    private static void faceNameIds(FaceNameIds fnis, StreamReader sr) throws Exception {
        int[] array = new int[7];
        for (int index = 0; index < 7; ++index) {
            array[index] = sr.readUInt2();
        }
        fnis.setArray(array);
    }

    private static void ratios(Ratios rs, StreamReader sr) throws Exception {
        short[] array = new short[7];
        for (int index = 0; index < 7; ++index) {
            array[index] = sr.readUInt1();
        }
        rs.setArray(array);
    }

    private static void charSpaces(CharSpaces css, StreamReader sr) throws Exception {
        byte[] array = new byte[7];
        for (int index = 0; index < 7; ++index) {
            array[index] = sr.readSInt1();
        }
        css.setArray(array);
    }

    private static void relativeSizes(RelativeSizes rss, StreamReader sr) throws Exception {
        short[] array = new short[7];
        for (int index = 0; index < 7; ++index) {
            array[index] = sr.readUInt1();
        }
        rss.setArray(array);
    }

    private static void charPositions(CharOffsets cos, StreamReader sr) throws Exception {
        byte[] array = new byte[7];
        for (int index = 0; index < 7; ++index) {
            array[index] = sr.readSInt1();
        }
        cos.setArray(array);
    }
}

