/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.docinfo;

import java.io.IOException;
import kr.dogfoot.hwplib.object.docinfo.Numbering;
import kr.dogfoot.hwplib.object.docinfo.numbering.LevelNumbering;
import kr.dogfoot.hwplib.object.docinfo.numbering.ParagraphHeadInfo;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForNumbering {
    public static void read(Numbering n, StreamReader sr) throws Exception {
        ForNumbering.levelNumberingsFor1To7(n, sr);
        n.setStartNumber(sr.readUInt2());
        if (!sr.isEndOfRecord() && sr.getFileVersion().isOver(5, 0, 2, 5)) {
            ForNumbering.startNumbersFor1To7(n, sr);
        }
        if (!sr.isEndOfRecord()) {
            ForNumbering.levelNumberingsFor8To10(n, sr);
            ForNumbering.startNumbersFor8To10(n, sr);
        }
    }

    private static void levelNumberingsFor1To7(Numbering n, StreamReader sr) throws Exception {
        for (int level = 1; level <= 7; ++level) {
            ForNumbering.levelNumbering(n.getLevelNumbering(level), sr);
        }
    }

    private static void levelNumbering(LevelNumbering ln, StreamReader sr) throws IOException {
        ForNumbering.paragraphHeadInfo(ln.getParagraphHeadInfo(), sr);
        ln.getNumberFormat().setBytes(sr.readHWPString());
    }

    public static void paragraphHeadInfo(ParagraphHeadInfo phi, StreamReader sr) throws IOException {
        phi.getProperty().setValue(sr.readUInt4());
        phi.setCorrectionValueForWidth(sr.readUInt2());
        phi.setDistanceFromBody(sr.readUInt2());
        phi.setCharShapeID(sr.readUInt4());
    }

    private static void startNumbersFor1To7(Numbering n, StreamReader sr) throws Exception {
        for (int level = 1; level <= 7; ++level) {
            n.getLevelNumbering(level).setStartNumber(sr.readUInt4());
        }
    }

    private static void levelNumberingsFor8To10(Numbering n, StreamReader sr) throws Exception {
        for (int level = 8; level <= 10; ++level) {
            ForNumbering.levelNumbering(n.getLevelNumbering(level), sr);
        }
    }

    private static void startNumbersFor8To10(Numbering n, StreamReader sr) throws Exception {
        for (int level = 8; level <= 10; ++level) {
            n.getLevelNumbering(level).setStartNumber(sr.readUInt4());
        }
    }
}

