/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.docinfo.borderfill;

import java.io.IOException;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.FillInfo;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.GradientFill;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.GradientType;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.ImageFill;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.ImageFillType;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.PatternFill;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.PatternType;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.PictureEffect;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.PictureInfo;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForFillInfo {
    public static void read(FillInfo fi, StreamReader sr) throws IOException {
        fi.getType().setValue(sr.readUInt4());
        if (fi.getType().getValue() != 0L) {
            if (fi.getType().hasPatternFill()) {
                fi.createPatternFill();
                ForFillInfo.patternFill(fi.getPatternFill(), sr);
            }
            if (fi.getType().hasGradientFill()) {
                fi.createGradientFill();
                ForFillInfo.gradientFill(fi.getGradientFill(), sr);
            }
            if (fi.getType().hasImageFill()) {
                fi.createImageFill();
                ForFillInfo.imageFill(fi.getImageFill(), sr);
            }
            ForFillInfo.additionalProperty(fi, sr);
            if (!sr.isEndOfRecord()) {
                ForFillInfo.unknownBytes(fi, sr);
            }
        } else {
            sr.skip(4L);
        }
    }

    private static void patternFill(PatternFill pf, StreamReader sr) throws IOException {
        pf.getBackColor().setValue(sr.readUInt4());
        pf.getPatternColor().setValue(sr.readUInt4());
        pf.setPatternType(PatternType.valueOf((byte)sr.readSInt4()));
    }

    private static void gradientFill(GradientFill gf, StreamReader sr) throws IOException {
        int index;
        gf.setGradientType(GradientType.valueOf(sr.readSInt1()));
        gf.setStartAngle(sr.readUInt4());
        gf.setCenterX(sr.readUInt4());
        gf.setCenterY(sr.readUInt4());
        gf.setBlurringDegree(sr.readUInt4());
        long colorCount = sr.readUInt4();
        if (colorCount > 2L) {
            index = 0;
            while ((long)index < colorCount) {
                gf.addChangePoint(sr.readSInt4());
                ++index;
            }
        }
        index = 0;
        while ((long)index < colorCount) {
            gf.addNewColor().setValue(sr.readUInt4());
            ++index;
        }
    }

    private static void imageFill(ImageFill imf, StreamReader sr) throws IOException {
        imf.setImageFillType(ImageFillType.valueOf((byte)sr.readUInt1()));
        ForFillInfo.pictureInfo(imf.getPictureInfo(), sr);
    }

    public static void pictureInfo(PictureInfo pi, StreamReader sr) throws IOException {
        pi.setBrightness(sr.readSInt1());
        pi.setContrast(sr.readSInt1());
        pi.setEffect(PictureEffect.valueOf((byte)sr.readUInt1()));
        pi.setBinItemID(sr.readUInt2());
    }

    private static void additionalProperty(FillInfo fi, StreamReader sr) throws IOException {
        long size = sr.readUInt4();
        if (size == 1L) {
            if (fi.getType().hasGradientFill()) {
                fi.getGradientFill().setBlurringCenter(sr.readUInt1());
            }
        } else {
            sr.skip(size);
        }
    }

    private static void unknownBytes(FillInfo fi, StreamReader sr) throws IOException {
        if (fi.getType().hasPatternFill()) {
            sr.skip(1L);
        }
        if (fi.getType().hasGradientFill()) {
            sr.skip(1L);
        }
        if (fi.getType().hasImageFill()) {
            sr.skip(1L);
        }
    }
}

