/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.objectfinder;

import java.util.ArrayList;
import java.util.Iterator;
import kr.dogfoot.hwplib.object.HWPFile;
import kr.dogfoot.hwplib.object.bodytext.ParagraphListInterface;
import kr.dogfoot.hwplib.object.bodytext.Section;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFooter;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHiddenComment;
import kr.dogfoot.hwplib.object.bodytext.control.ControlTable;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlArc;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlEllipse;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPolygon;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlRectangle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.table.Cell;
import kr.dogfoot.hwplib.object.bodytext.control.table.Row;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.tool.objectfinder.ControlFilter;

public class ControlFinder {
    private ControlFilter filter;
    private ArrayList<Control> resultList;
    private Section currentSection;
    private Paragraph currentParagraph;

    private ControlFinder() {
    }

    public static ArrayList<Control> find(HWPFile hwpFile, ControlFilter filter) {
        ControlFinder finder = new ControlFinder();
        return finder.go(hwpFile, filter);
    }

    private ArrayList<Control> go(HWPFile hwpFile, ControlFilter filter) {
        this.resultList = new ArrayList();
        this.filter = filter;
        Iterator<Section> iterator = hwpFile.getBodyText().getSectionList().iterator();
        while (iterator.hasNext()) {
            Section s;
            this.currentSection = s = iterator.next();
            this.forParagraphList(s);
        }
        return this.resultList;
    }

    private void forParagraphList(ParagraphListInterface paraList) {
        Iterator iterator = paraList.iterator();
        while (iterator.hasNext()) {
            Paragraph p;
            this.currentParagraph = p = (Paragraph)iterator.next();
            this.forParagraph(p);
        }
    }

    private void forParagraph(Paragraph p) {
        if (p.getControlList() == null) {
            return;
        }
        for (Control c : p.getControlList()) {
            if (this.filter.isMatched(c, this.currentParagraph, this.currentSection)) {
                this.resultList.add(c);
            }
            this.forParagraphInControl(c);
        }
    }

    private void forParagraphInControl(Control c) {
        switch (c.getType()) {
            case Table: {
                this.forTable((ControlTable)c);
                break;
            }
            case Gso: {
                this.forGso((GsoControl)c);
                break;
            }
            case Equation: {
                break;
            }
            case SectionDefine: {
                break;
            }
            case ColumnDefine: {
                break;
            }
            case Header: {
                this.forHeader((ControlHeader)c);
                break;
            }
            case Footer: {
                this.forFooter((ControlFooter)c);
                break;
            }
            case Footnote: {
                this.forFootnote((ControlFootnote)c);
                break;
            }
            case Endnote: {
                this.forEndnote((ControlEndnote)c);
                break;
            }
            case AutoNumber: {
                break;
            }
            case NewNumber: {
                break;
            }
            case PageHide: {
                break;
            }
            case PageOddEvenAdjust: {
                break;
            }
            case PageNumberPosition: {
                break;
            }
            case IndexMark: {
                break;
            }
            case Bookmark: {
                break;
            }
            case OverlappingLetter: {
                break;
            }
            case AdditionalText: {
                break;
            }
            case HiddenComment: {
                this.forHiddenComment((ControlHiddenComment)c);
                break;
            }
        }
    }

    private void forTable(ControlTable table) {
        for (Row r : table.getRowList()) {
            for (Cell c : r.getCellList()) {
                this.forParagraphList(c.getParagraphList());
            }
        }
    }

    private void forHeader(ControlHeader header) {
        this.forParagraphList(header.getParagraphList());
    }

    private void forFooter(ControlFooter footer) {
        this.forParagraphList(footer.getParagraphList());
    }

    private void forFootnote(ControlFootnote footnote) {
        this.forParagraphList(footnote.getParagraphList());
    }

    private void forEndnote(ControlEndnote endnote) {
        this.forParagraphList(endnote.getParagraphList());
    }

    private void forHiddenComment(ControlHiddenComment hiddenComment) {
        this.forParagraphList(hiddenComment.getParagraphList());
    }

    private void forGso(GsoControl gc) {
        switch (gc.getGsoType()) {
            case Line: {
                break;
            }
            case Rectangle: {
                this.forRectangle((ControlRectangle)gc);
                break;
            }
            case Ellipse: {
                this.forEllipse((ControlEllipse)gc);
                break;
            }
            case Arc: {
                this.forArc((ControlArc)gc);
                break;
            }
            case Polygon: {
                this.forPolygon((ControlPolygon)gc);
                break;
            }
            case Curve: {
                this.forCurve((ControlCurve)gc);
                break;
            }
            case Picture: {
                break;
            }
            case OLE: {
                break;
            }
            case Container: {
                this.forContainer((ControlContainer)gc);
                break;
            }
        }
    }

    private void forRectangle(ControlRectangle rectangle) {
        if (rectangle.getTextBox() != null) {
            this.forParagraphList(rectangle.getTextBox().getParagraphList());
        }
    }

    private void forEllipse(ControlEllipse ellipse) {
        if (ellipse.getTextBox() == null) {
            return;
        }
        this.forParagraphList(ellipse.getTextBox().getParagraphList());
    }

    private void forArc(ControlArc arc) {
        if (arc.getTextBox() == null) {
            return;
        }
        this.forParagraphList(arc.getTextBox().getParagraphList());
    }

    private void forPolygon(ControlPolygon polygon) {
        if (polygon.getTextBox() == null) {
            return;
        }
        this.forParagraphList(polygon.getTextBox().getParagraphList());
    }

    private void forCurve(ControlCurve curve) {
        if (curve.getTextBox() == null) {
            return;
        }
        this.forParagraphList(curve.getTextBox().getParagraphList());
    }

    private void forContainer(ControlContainer container) {
        for (GsoControl child : container.getChildControlList()) {
            if (this.filter.isMatched(child, this.currentParagraph, this.currentSection)) {
                this.resultList.add(child);
            }
            this.forGso(child);
        }
    }
}

