/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.objectfinder.forField.gettext;

import java.io.UnsupportedEncodingException;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFooter;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHiddenComment;
import kr.dogfoot.hwplib.object.bodytext.control.ControlTable;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.table.Cell;
import kr.dogfoot.hwplib.object.bodytext.control.table.Row;
import kr.dogfoot.hwplib.tool.objectfinder.forField.ForParagraphList;
import kr.dogfoot.hwplib.tool.objectfinder.forField.gettext.ForGso;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractMethod;

public class ForControl {
    public static String getFieldText(Control c, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        if (!c.isField()) {
            switch (c.getType()) {
                case Table: {
                    return ForControl.table((ControlTable)c, fieldType, fieldName, temInField);
                }
                case Gso: {
                    return ForGso.getFieldText((GsoControl)c, fieldType, fieldName, temInField);
                }
                case Equation: {
                    break;
                }
                case SectionDefine: {
                    break;
                }
                case ColumnDefine: {
                    break;
                }
                case Header: {
                    return ForControl.header((ControlHeader)c, fieldType, fieldName, temInField);
                }
                case Footer: {
                    return ForControl.footer((ControlFooter)c, fieldType, fieldName, temInField);
                }
                case Footnote: {
                    return ForControl.footnote((ControlFootnote)c, fieldType, fieldName, temInField);
                }
                case Endnote: {
                    return ForControl.endnote((ControlEndnote)c, fieldType, fieldName, temInField);
                }
                case AutoNumber: {
                    break;
                }
                case NewNumber: {
                    break;
                }
                case PageHide: {
                    break;
                }
                case PageOddEvenAdjust: {
                    break;
                }
                case PageNumberPosition: {
                    break;
                }
                case IndexMark: {
                    break;
                }
                case Bookmark: {
                    break;
                }
                case OverlappingLetter: {
                    break;
                }
                case AdditionalText: {
                    break;
                }
                case HiddenComment: {
                    return ForControl.hiddenComment((ControlHiddenComment)c, fieldType, fieldName, temInField);
                }
            }
        }
        return null;
    }

    private static String table(ControlTable table, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        for (Row r : table.getRowList()) {
            for (Cell c : r.getCellList()) {
                String text = ForParagraphList.getFieldText(c.getParagraphList(), fieldType, fieldName, temInField);
                if (text == null) continue;
                return text;
            }
        }
        return null;
    }

    private static String header(ControlHeader header, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        return ForParagraphList.getFieldText(header.getParagraphList(), fieldType, fieldName, temInField);
    }

    private static String footer(ControlFooter footer, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        return ForParagraphList.getFieldText(footer.getParagraphList(), fieldType, fieldName, temInField);
    }

    private static String footnote(ControlFootnote footnote, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        return ForParagraphList.getFieldText(footnote.getParagraphList(), fieldType, fieldName, temInField);
    }

    private static String endnote(ControlEndnote endnote, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        return ForParagraphList.getFieldText(endnote.getParagraphList(), fieldType, fieldName, temInField);
    }

    private static String hiddenComment(ControlHiddenComment hiddenComment, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        return ForParagraphList.getFieldText(hiddenComment.getParagraphList(), fieldType, fieldName, temInField);
    }
}

