/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.objectfinder.forField.settext;

import java.io.UnsupportedEncodingException;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFooter;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHiddenComment;
import kr.dogfoot.hwplib.object.bodytext.control.ControlTable;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.table.Cell;
import kr.dogfoot.hwplib.object.bodytext.control.table.Row;
import kr.dogfoot.hwplib.tool.objectfinder.SetFieldResult;
import kr.dogfoot.hwplib.tool.objectfinder.TextBuffer;
import kr.dogfoot.hwplib.tool.objectfinder.forField.ForParagraphList;
import kr.dogfoot.hwplib.tool.objectfinder.forField.settext.ForGso;

public class ForControl {
    public static SetFieldResult setFieldText(Control c, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        if (!c.isField()) {
            switch (c.getType()) {
                case Table: {
                    return ForControl.table((ControlTable)c, fieldType, fieldName, textBuffer);
                }
                case Gso: {
                    return ForGso.setFieldText((GsoControl)c, fieldType, fieldName, textBuffer);
                }
                case Equation: {
                    break;
                }
                case SectionDefine: {
                    break;
                }
                case ColumnDefine: {
                    break;
                }
                case Header: {
                    return ForControl.header((ControlHeader)c, fieldType, fieldName, textBuffer);
                }
                case Footer: {
                    return ForControl.footer((ControlFooter)c, fieldType, fieldName, textBuffer);
                }
                case Footnote: {
                    return ForControl.footnote((ControlFootnote)c, fieldType, fieldName, textBuffer);
                }
                case Endnote: {
                    return ForControl.endnote((ControlEndnote)c, fieldType, fieldName, textBuffer);
                }
                case AutoNumber: {
                    break;
                }
                case NewNumber: {
                    break;
                }
                case PageHide: {
                    break;
                }
                case PageOddEvenAdjust: {
                    break;
                }
                case PageNumberPosition: {
                    break;
                }
                case IndexMark: {
                    break;
                }
                case Bookmark: {
                    break;
                }
                case OverlappingLetter: {
                    break;
                }
                case AdditionalText: {
                    break;
                }
                case HiddenComment: {
                    return ForControl.hiddenComment((ControlHiddenComment)c, fieldType, fieldName, textBuffer);
                }
            }
        }
        return SetFieldResult.InProcess;
    }

    private static SetFieldResult table(ControlTable table, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        for (Row r : table.getRowList()) {
            for (Cell c : r.getCellList()) {
                if (ForParagraphList.setFieldText(c.getParagraphList(), fieldType, fieldName, textBuffer) != SetFieldResult.NotEnoughText) continue;
                return SetFieldResult.NotEnoughText;
            }
        }
        return SetFieldResult.InProcess;
    }

    private static SetFieldResult header(ControlHeader header, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        return ForParagraphList.setFieldText(header.getParagraphList(), fieldType, fieldName, textBuffer);
    }

    private static SetFieldResult footer(ControlFooter footer, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        return ForParagraphList.setFieldText(footer.getParagraphList(), fieldType, fieldName, textBuffer);
    }

    private static SetFieldResult footnote(ControlFootnote footnote, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        return ForParagraphList.setFieldText(footnote.getParagraphList(), fieldType, fieldName, textBuffer);
    }

    private static SetFieldResult endnote(ControlEndnote endnote, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        return ForParagraphList.setFieldText(endnote.getParagraphList(), fieldType, fieldName, textBuffer);
    }

    private static SetFieldResult hiddenComment(ControlHiddenComment hiddenComment, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        return ForParagraphList.setFieldText(hiddenComment.getParagraphList(), fieldType, fieldName, textBuffer);
    }
}

