/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder;

import java.util.ArrayList;
import kr.dogfoot.hwplib.object.HWPFile;
import kr.dogfoot.hwplib.object.bodytext.ParagraphListInterface;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.tool.paragraphadder.ParagraphCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.ParagraphMerger;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;

public class ParagraphAdder {
    private HWPFile targetHWPFile;
    private ParagraphListInterface targetParaList;
    private int indexToInsert;
    private ParagraphCopier paraCopier;

    public ParagraphAdder(HWPFile targetHWPFile, ParagraphListInterface targetParaList) {
        this.targetHWPFile = targetHWPFile;
        this.targetParaList = targetParaList;
        this.indexToInsert = -1;
    }

    public ParagraphAdder(HWPFile targetHWPFile, ParagraphListInterface targetParaList, int indexToInsert) {
        this.targetHWPFile = targetHWPFile;
        this.targetParaList = targetParaList;
        this.indexToInsert = indexToInsert;
    }

    public void add(HWPFile hwpFile, Paragraph p) throws Exception {
        this.paraCopier = new ParagraphCopier(new DocInfoAdder(hwpFile, this.targetHWPFile));
        this.copyAndAdd(p);
    }

    private void copyAndAdd(Paragraph p) throws Exception {
        if (this.indexToInsert == -1) {
            this.paraCopier.copy(p, this.targetParaList.addNewParagraph());
        } else {
            this.paraCopier.copy(p, this.targetParaList.insertNewParagraph(this.indexToInsert));
            ++this.indexToInsert;
        }
    }

    public void add(HWPFile hwpFile, ArrayList<Paragraph> list) throws Exception {
        this.paraCopier = new ParagraphCopier(new DocInfoAdder(hwpFile, this.targetHWPFile));
        for (Paragraph p : list) {
            this.copyAndAdd(p);
        }
    }

    public void add(HWPFile hwpFile, ParagraphListInterface paragraphListInterface) throws Exception {
        this.paraCopier = new ParagraphCopier(new DocInfoAdder(hwpFile, this.targetHWPFile));
        for (Paragraph p : paragraphListInterface) {
            this.copyAndAdd(p);
        }
    }

    public void addIncludingSectionInfo(HWPFile hwpFile, ParagraphListInterface paragraphListInterface) throws Exception {
        this.paraCopier = new ParagraphCopier(new DocInfoAdder(hwpFile, this.targetHWPFile));
        for (Paragraph p : paragraphListInterface) {
            this.paraCopier.copyIncludingSectionInfo(p, this.targetParaList.addNewParagraph());
        }
    }

    public void merge(Paragraph targetParagraph, HWPFile hwpFile, Paragraph p) throws Exception {
        ParagraphMerger merger = new ParagraphMerger(new DocInfoAdder(hwpFile, this.targetHWPFile));
        merger.merge(p, targetParagraph);
    }
}

