/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder;

import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlAdditionalText;
import kr.dogfoot.hwplib.object.bodytext.control.ControlAutoNumber;
import kr.dogfoot.hwplib.object.bodytext.control.ControlBookmark;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEquation;
import kr.dogfoot.hwplib.object.bodytext.control.ControlField;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFooter;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlForm;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHiddenComment;
import kr.dogfoot.hwplib.object.bodytext.control.ControlIndexMark;
import kr.dogfoot.hwplib.object.bodytext.control.ControlNewNumber;
import kr.dogfoot.hwplib.object.bodytext.control.ControlOverlappingLetter;
import kr.dogfoot.hwplib.object.bodytext.control.ControlPageHide;
import kr.dogfoot.hwplib.object.bodytext.control.ControlPageNumberPosition;
import kr.dogfoot.hwplib.object.bodytext.control.ControlPageOddEvenAdjust;
import kr.dogfoot.hwplib.object.bodytext.control.ControlTable;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.object.bodytext.paragraph.charshape.CharPositionShapeIdPair;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlExtend;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharType;
import kr.dogfoot.hwplib.tool.paragraphadder.ParagraphCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.AdditionalTextCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.ETCControlCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.EquationCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.GsoCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.OverlappingLetterCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.TableCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;

public class ParagraphMerger {
    private DocInfoAdder docInfoAdder;
    private Paragraph source;
    private Paragraph target;
    private int targetCharPosition;
    private int sourceCharPosition;
    private int sourceCharShapeIndex;
    private int sourceControlIndex;

    public ParagraphMerger() {
        this.docInfoAdder = null;
    }

    public ParagraphMerger(DocInfoAdder docInfoAdder) {
        this.docInfoAdder = docInfoAdder;
    }

    public void merge(Paragraph source, Paragraph target) throws Exception {
        this.source = source;
        this.target = target;
        this.removeLastParaBreakCharFromTarget();
        this.moveTextAndCharShapeAndControl();
        this.deleteLineSeg();
        this.deleteRangeTag();
        this.copyMemoList();
    }

    private void removeLastParaBreakCharFromTarget() {
        HWPChar lastChar;
        if (this.target.getText() == null) {
            return;
        }
        int count = this.target.getText().getCharList().size();
        if (count > 0 && (lastChar = this.target.getText().getCharList().get(count - 1)).getType() == HWPCharType.ControlChar && lastChar.getCode() == 13) {
            this.target.getText().getCharList().remove(count - 1);
        }
    }

    private void moveTextAndCharShapeAndControl() {
        if (this.target.getText() == null) {
            this.target.createText();
        }
        this.targetCharPosition = this.target.getText().getCharSize();
        this.sourceCharPosition = 0;
        this.sourceCharShapeIndex = 0;
        this.sourceControlIndex = 0;
        for (HWPChar hwpChar : this.source.getText().getCharList()) {
            switch (hwpChar.getType()) {
                case Normal: {
                    this.moveCharAndCharShape(hwpChar);
                    break;
                }
                case ControlChar: {
                    this.moveCharAndCharShape(hwpChar);
                    break;
                }
                case ControlInline: {
                    this.moveCharAndCharShape(hwpChar);
                    break;
                }
                case ControlExtend: {
                    this.moveExtendChar((HWPCharControlExtend)hwpChar);
                }
            }
            this.sourceCharPosition += hwpChar.getCharSize();
        }
    }

    private void moveCharAndCharShape(HWPChar hwpChar) {
        this.target.getText().getCharList().add(hwpChar);
        this.moveCharSpace();
        this.targetCharPosition += hwpChar.getCharSize();
    }

    private void moveCharSpace() {
        CharPositionShapeIdPair cpsip;
        if (this.sourceCharShapeIndex < this.source.getCharShape().getPositonShapeIdPairList().size() && (cpsip = this.source.getCharShape().getPositonShapeIdPairList().get(this.sourceCharShapeIndex)).getPosition() <= (long)this.sourceCharPosition) {
            this.target.getCharShape().addParaCharShape(this.targetCharPosition, this.docInfoAdder == null ? cpsip.getShapeId() : (long)this.docInfoAdder.forCharShape().processById((int)cpsip.getShapeId()));
            ++this.sourceCharShapeIndex;
        }
    }

    private void moveExtendChar(HWPCharControlExtend hwpChar) {
        if (this.canMoveExtendChar(hwpChar)) {
            this.target.getText().getCharList().add(hwpChar);
            this.moveCharSpace();
            this.targetCharPosition += hwpChar.getCharSize();
            this.moveControl(this.source.getControlList().get(this.sourceControlIndex));
        }
        ++this.sourceControlIndex;
    }

    private boolean canMoveExtendChar(HWPCharControlExtend hwpChar) {
        return hwpChar.getCode() == 3 || hwpChar.getCode() == 11 || hwpChar.getCode() == 15 || hwpChar.getCode() == 16 || hwpChar.getCode() == 17 || hwpChar.getCode() == 18 || hwpChar.getCode() == 21 || hwpChar.getCode() == 22 || hwpChar.getCode() == 23;
    }

    private void moveControl(Control sourceControl) {
        if (this.target.getControlList() == null) {
            this.target.createControlList();
        }
        switch (sourceControl.getType()) {
            case Table: {
                TableCopier.copy((ControlTable)sourceControl, (ControlTable)this.target.addNewControl(ControlType.Table), this.docInfoAdder);
                break;
            }
            case Gso: {
                GsoCopier.copy((GsoControl)sourceControl, this.target.addNewGsoControl(((GsoControl)sourceControl).getGsoType()), this.docInfoAdder);
                break;
            }
            case Equation: {
                EquationCopier.copy((ControlEquation)sourceControl, (ControlEquation)this.target.addNewControl(ControlType.Equation), this.docInfoAdder);
                break;
            }
            case Header: {
                ETCControlCopier.copyHeader((ControlHeader)sourceControl, (ControlHeader)this.target.addNewControl(ControlType.Header), this.docInfoAdder);
                break;
            }
            case Footer: {
                ETCControlCopier.copyFooter((ControlFooter)sourceControl, (ControlFooter)this.target.addNewControl(ControlType.Footer), this.docInfoAdder);
                break;
            }
            case Footnote: {
                ETCControlCopier.copyFootnote((ControlFootnote)sourceControl, (ControlFootnote)this.target.addNewControl(ControlType.Footnote), this.docInfoAdder);
                break;
            }
            case Endnote: {
                ETCControlCopier.copyEndnote((ControlEndnote)sourceControl, (ControlEndnote)this.target.addNewControl(ControlType.Endnote), this.docInfoAdder);
                break;
            }
            case AutoNumber: {
                ETCControlCopier.copyAutoNumber((ControlAutoNumber)sourceControl, (ControlAutoNumber)this.target.addNewControl(ControlType.AutoNumber), this.docInfoAdder);
                break;
            }
            case NewNumber: {
                ETCControlCopier.copyNewNumber((ControlNewNumber)sourceControl, (ControlNewNumber)this.target.addNewControl(ControlType.NewNumber), this.docInfoAdder);
                break;
            }
            case PageHide: {
                ETCControlCopier.copyPageHide((ControlPageHide)sourceControl, (ControlPageHide)this.target.addNewControl(ControlType.PageHide), this.docInfoAdder);
                break;
            }
            case PageOddEvenAdjust: {
                ETCControlCopier.copyPageOddEvenAdjust((ControlPageOddEvenAdjust)sourceControl, (ControlPageOddEvenAdjust)this.target.addNewControl(ControlType.PageOddEvenAdjust), this.docInfoAdder);
                break;
            }
            case PageNumberPosition: {
                ETCControlCopier.copyPageNumberPosition((ControlPageNumberPosition)sourceControl, (ControlPageNumberPosition)this.target.addNewControl(ControlType.PageNumberPosition), this.docInfoAdder);
                break;
            }
            case IndexMark: {
                ETCControlCopier.copyIndexMark((ControlIndexMark)sourceControl, (ControlIndexMark)this.target.addNewControl(ControlType.IndexMark), this.docInfoAdder);
                break;
            }
            case Bookmark: {
                ETCControlCopier.copyBookmark((ControlBookmark)sourceControl, (ControlBookmark)this.target.addNewControl(ControlType.Bookmark), this.docInfoAdder);
                break;
            }
            case OverlappingLetter: {
                OverlappingLetterCopier.copy((ControlOverlappingLetter)sourceControl, (ControlOverlappingLetter)this.target.addNewControl(ControlType.OverlappingLetter), this.docInfoAdder);
                break;
            }
            case AdditionalText: {
                AdditionalTextCopier.copy((ControlAdditionalText)sourceControl, (ControlAdditionalText)this.target.addNewControl(ControlType.AdditionalText), this.docInfoAdder);
                break;
            }
            case HiddenComment: {
                ETCControlCopier.copyHiddenComment((ControlHiddenComment)sourceControl, (ControlHiddenComment)this.target.addNewControl(ControlType.HiddenComment), this.docInfoAdder);
                break;
            }
            case Form: {
                ETCControlCopier.copyForm((ControlForm)sourceControl, (ControlForm)this.target.addNewControl(ControlType.Form), this.docInfoAdder);
                break;
            }
            case FIELD_UNKNOWN: 
            case FIELD_DATE: 
            case FIELD_DOCDATE: 
            case FIELD_PATH: 
            case FIELD_BOOKMARK: 
            case FIELD_MAILMERGE: 
            case FIELD_CROSSREF: 
            case FIELD_FORMULA: 
            case FIELD_CLICKHERE: 
            case FIELD_SUMMARY: 
            case FIELD_USERINFO: 
            case FIELD_HYPERLINK: 
            case FIELD_REVISION_SIGN: 
            case FIELD_REVISION_DELETE: 
            case FIELD_REVISION_ATTACH: 
            case FIELD_REVISION_CLIPPING: 
            case FIELD_REVISION_THINKING: 
            case FIELD_REVISION_PRAISE: 
            case FIELD_REVISION_LINE: 
            case FIELD_REVISION_SIMPLECHANGE: 
            case FIELD_REVISION_HYPERLINK: 
            case FIELD_REVISION_LINEATTACH: 
            case FIELD_REVISION_LINELINK: 
            case FIELD_REVISION_LINETRANSFER: 
            case FIELD_REVISION_RIGHTMOVE: 
            case FIELD_REVISION_LEFTMOVE: 
            case FIELD_REVISION_TRANSFER: 
            case FIELD_REVISION_SIMPLEINSERT: 
            case FIELD_REVISION_SPLIT: 
            case FIELD_REVISION_CHANGE: 
            case FIELD_MEMO: 
            case FIELD_PRIVATE_INFO_SECURITY: 
            case FIELD_TABLEOFCONTENTS: {
                ETCControlCopier.copyField((ControlField)sourceControl, (ControlField)this.target.addNewControl(((ControlField)sourceControl).getHeader().getCtrlId()), this.docInfoAdder);
            }
        }
    }

    private void deleteLineSeg() {
        this.target.deleteLineSeg();
    }

    private void deleteRangeTag() throws Exception {
        this.target.deleteRangeTag();
    }

    private void copyMemoList() {
        ParagraphCopier.copyMemoList(this.source, this.target, this.docInfoAdder);
    }
}

