/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder.control;

import java.nio.charset.StandardCharsets;
import kr.dogfoot.hwplib.object.bodytext.control.ControlAutoNumber;
import kr.dogfoot.hwplib.object.bodytext.control.ControlBookmark;
import kr.dogfoot.hwplib.object.bodytext.control.ControlColumnDefine;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlField;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFooter;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlForm;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHiddenComment;
import kr.dogfoot.hwplib.object.bodytext.control.ControlIndexMark;
import kr.dogfoot.hwplib.object.bodytext.control.ControlNewNumber;
import kr.dogfoot.hwplib.object.bodytext.control.ControlPageHide;
import kr.dogfoot.hwplib.object.bodytext.control.ControlPageNumberPosition;
import kr.dogfoot.hwplib.object.bodytext.control.ControlPageOddEvenAdjust;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderAutoNumber;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderBookmark;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderColumnDefine;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderField;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderFooter;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderGso;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderIndexMark;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderNewNumber;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderPageHide;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderPageNumberPosition;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderPageOddEvenAdjust;
import kr.dogfoot.hwplib.object.bodytext.control.footnoteendnote.ListHeaderForFootnodeEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.form.FormObject;
import kr.dogfoot.hwplib.object.bodytext.control.headerfooter.ListHeaderForHeaderFooter;
import kr.dogfoot.hwplib.object.bodytext.control.hiddencomment.ListHeaderForHiddenComment;
import kr.dogfoot.hwplib.object.bodytext.paragraph.memo.Memo;
import kr.dogfoot.hwplib.tool.paragraphadder.ParagraphCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.CtrlDataCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;

public class ETCControlCopier {
    public static void copyAutoNumber(ControlAutoNumber source, ControlAutoNumber target, DocInfoAdder docInfoAdder) {
        CtrlHeaderAutoNumber sourceH = source.getHeader();
        CtrlHeaderAutoNumber targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
    }

    public static void copyColumnDefine(ControlColumnDefine source, ControlColumnDefine target, DocInfoAdder docInfoAdder) {
        CtrlHeaderColumnDefine sourceH = source.getHeader();
        CtrlHeaderColumnDefine targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
    }

    public static void copyEndnote(ControlEndnote source, ControlEndnote target, DocInfoAdder docInfoAdder) {
        CtrlHeaderEndnote sourceH = source.getHeader();
        CtrlHeaderEndnote targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
        ListHeaderForFootnodeEndnote sourceLH = source.getListHeader();
        ListHeaderForFootnodeEndnote targetLH = target.getListHeader();
        targetLH.copy(sourceLH);
        ParagraphCopier.listCopy(source.getParagraphList(), target.getParagraphList(), docInfoAdder);
    }

    public static void copyField(ControlField source, ControlField target, DocInfoAdder docInfoAdder) {
        Memo sourceMemo;
        CtrlHeaderField sourceH = source.getHeader();
        CtrlHeaderField targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
        if (ETCControlCopier.isMemo(source) && (sourceMemo = ETCControlCopier.getSourceMemo(sourceH.getMemoIndex(), docInfoAdder)) != null) {
            long newMemoIndex = ETCControlCopier.addMemoToTarget(sourceMemo, docInfoAdder);
            ETCControlCopier.setNewMemoIndex(targetH, newMemoIndex);
        }
    }

    private static boolean isMemo(ControlField source) {
        if (source.getHeader().getCommand().getBytes() == null) {
            return false;
        }
        return source.getHeader().getCommand().toUTF16LEString().startsWith("MEMO");
    }

    private static Memo getSourceMemo(int memoIndex, DocInfoAdder docInfoAdder) {
        if (docInfoAdder.getSourceHWPFile().getBodyText().getMemoList() != null) {
            for (Memo memo : docInfoAdder.getSourceHWPFile().getBodyText().getMemoList()) {
                if (memo.getMemoList().getMemoIndex() != (long)memoIndex) continue;
                return memo;
            }
        }
        return null;
    }

    private static long addMemoToTarget(Memo sourceMemo, DocInfoAdder docInfoAdder) {
        long maxMemoIndex = 0L;
        if (docInfoAdder.getTargetHWPFile().getBodyText().getMemoList() != null) {
            for (Memo memo : docInfoAdder.getTargetHWPFile().getBodyText().getMemoList()) {
                maxMemoIndex = Math.max(maxMemoIndex, memo.getMemoList().getMemoIndex());
            }
        }
        Memo clonedMemo = sourceMemo.clone();
        clonedMemo.getMemoList().setMemoIndex(++maxMemoIndex);
        docInfoAdder.getTargetHWPFile().getBodyText().getMemoList().add(clonedMemo);
        return maxMemoIndex;
    }

    private static void setNewMemoIndex(CtrlHeaderField targetH, long newMemoIndex) {
        if (targetH.getCommand().getBytes() != null) {
            String[] commands = targetH.getCommand().toUTF16LEString().split("/");
            commands[2] = Long.toString(newMemoIndex);
            targetH.getCommand().setBytes(ETCControlCopier.stringJoin("/", commands).getBytes(StandardCharsets.UTF_16LE));
            targetH.setMemoIndex((int)newMemoIndex);
        }
    }

    private static String stringJoin(String s, String[] array) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < array.length; ++index) {
            if (index != array.length - 1) {
                sb.append(array[index]).append(s);
                continue;
            }
            sb.append(array[index]);
        }
        return sb.toString();
    }

    public static void copyFooter(ControlFooter source, ControlFooter target, DocInfoAdder docInfoAdder) {
        CtrlHeaderFooter sourceH = source.getHeader();
        CtrlHeaderFooter targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
        ListHeaderForHeaderFooter sourceLH = source.getListHeader();
        ListHeaderForHeaderFooter targetLH = target.getListHeader();
        targetLH.copy(sourceLH);
        ParagraphCopier.listCopy(source.getParagraphList(), target.getParagraphList(), docInfoAdder);
    }

    public static void copyFootnote(ControlFootnote source, ControlFootnote target, DocInfoAdder docInfoAdder) {
        CtrlHeaderFootnote sourceH = source.getHeader();
        CtrlHeaderFootnote targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
        ListHeaderForFootnodeEndnote sourceLH = source.getListHeader();
        ListHeaderForFootnodeEndnote targetLH = target.getListHeader();
        targetLH.copy(sourceLH);
        ParagraphCopier.listCopy(source.getParagraphList(), target.getParagraphList(), docInfoAdder);
    }

    public static void copyHeader(ControlHeader source, ControlHeader target, DocInfoAdder docInfoAdder) {
        CtrlHeaderHeader sourceH = source.getHeader();
        CtrlHeaderHeader targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
        ListHeaderForHeaderFooter sourceLH = source.getListHeader();
        ListHeaderForHeaderFooter targetLH = target.getListHeader();
        targetLH.copy(sourceLH);
        ParagraphCopier.listCopy(source.getParagraphList(), target.getParagraphList(), docInfoAdder);
    }

    public static void copyIndexMark(ControlIndexMark source, ControlIndexMark target, DocInfoAdder docInfoAdder) {
        CtrlHeaderIndexMark sourceH = source.getHeader();
        CtrlHeaderIndexMark targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
    }

    public static void copyNewNumber(ControlNewNumber source, ControlNewNumber target, DocInfoAdder docInfoAdder) {
        CtrlHeaderNewNumber sourceH = source.getHeader();
        CtrlHeaderNewNumber targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
    }

    public static void copyPageHide(ControlPageHide source, ControlPageHide target, DocInfoAdder docInfoAdder) {
        CtrlHeaderPageHide sourceH = source.getHeader();
        CtrlHeaderPageHide targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
    }

    public static void copyPageNumberPosition(ControlPageNumberPosition source, ControlPageNumberPosition target, DocInfoAdder docInfoAdder) {
        CtrlHeaderPageNumberPosition sourceH = source.getHeader();
        CtrlHeaderPageNumberPosition targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
    }

    public static void copyPageOddEvenAdjust(ControlPageOddEvenAdjust source, ControlPageOddEvenAdjust target, DocInfoAdder docInfoAdder) {
        CtrlHeaderPageOddEvenAdjust sourceH = source.getHeader();
        CtrlHeaderPageOddEvenAdjust targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
    }

    public static void copyBookmark(ControlBookmark source, ControlBookmark target, DocInfoAdder docInfoAdder) {
        CtrlHeaderBookmark sourceH = source.getHeader();
        CtrlHeaderBookmark targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
    }

    public static void copyHiddenComment(ControlHiddenComment source, ControlHiddenComment target, DocInfoAdder docInfoAdder) {
        CtrlHeader sourceH = source.getHeader();
        CtrlHeader targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
        ListHeaderForHiddenComment sourceLH = source.getListHeader();
        ListHeaderForHiddenComment targetLH = target.getListHeader();
        targetLH.copy(sourceLH);
        ParagraphCopier.listCopy(source.getParagraphList(), target.getParagraphList(), docInfoAdder);
    }

    public static void copyForm(ControlForm source, ControlForm target, DocInfoAdder docInfoAdder) {
        CtrlHeaderGso sourceH = source.getHeader();
        CtrlHeaderGso targetH = target.getHeader();
        targetH.copy(sourceH);
        CtrlDataCopier.copy(source, target, docInfoAdder);
        FormObject sourceFO = source.getFormObject();
        FormObject targetFO = target.getFormObject();
        targetFO.copy(sourceFO);
    }
}

