/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder.control;

import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlArc;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlEllipse;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlLine;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlOLE;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlObjectLinkLine;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPicture;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPolygon;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlRectangle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlTextArt;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentArc;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentEllipse;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentLine;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentLineForObjectLinkLine;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentOLE;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentPicture;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentPolygon;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentRectangle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.ShapeComponentTextArt;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.InnerMargin;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.PictureEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.polygon.PositionXY;
import kr.dogfoot.hwplib.object.bodytext.control.gso.textbox.ListHeaderForTextBox;
import kr.dogfoot.hwplib.object.bodytext.control.gso.textbox.TextBox;
import kr.dogfoot.hwplib.tool.paragraphadder.ParagraphCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.control.GsoCommonPartCopier;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;

public class GsoCopier {
    public static void copy(GsoControl source, GsoControl target, DocInfoAdder docInfoAdder) {
        GsoCommonPartCopier.copy(source, target, docInfoAdder);
        switch (source.getGsoType()) {
            case Line: {
                GsoCopier.line((ControlLine)source, (ControlLine)target, docInfoAdder);
                break;
            }
            case Rectangle: {
                GsoCopier.rectangle((ControlRectangle)source, (ControlRectangle)target, docInfoAdder);
                break;
            }
            case Ellipse: {
                GsoCopier.ellipse((ControlEllipse)source, (ControlEllipse)target, docInfoAdder);
                break;
            }
            case Arc: {
                GsoCopier.arc((ControlArc)source, (ControlArc)target, docInfoAdder);
                break;
            }
            case Polygon: {
                GsoCopier.polygon((ControlPolygon)source, (ControlPolygon)target, docInfoAdder);
                break;
            }
            case Curve: {
                GsoCopier.curve((ControlCurve)source, (ControlCurve)target, docInfoAdder);
                break;
            }
            case Picture: {
                GsoCopier.picture((ControlPicture)source, (ControlPicture)target, docInfoAdder);
                break;
            }
            case OLE: {
                GsoCopier.ole((ControlOLE)source, (ControlOLE)target, docInfoAdder);
                break;
            }
            case Container: {
                GsoCopier.container((ControlContainer)source, (ControlContainer)target, docInfoAdder);
                break;
            }
            case ObjectLinkLine: {
                GsoCopier.objectLinkLine((ControlObjectLinkLine)source, (ControlObjectLinkLine)target, docInfoAdder);
                break;
            }
            case TextArt: {
                GsoCopier.textArt((ControlTextArt)source, (ControlTextArt)target, docInfoAdder);
            }
        }
    }

    private static void line(ControlLine source, ControlLine target, DocInfoAdder docInfoAdder) {
        ShapeComponentLine sourceSCL = source.getShapeComponentLine();
        ShapeComponentLine targetSCL = target.getShapeComponentLine();
        targetSCL.copy(sourceSCL);
    }

    private static void rectangle(ControlRectangle source, ControlRectangle target, DocInfoAdder docInfoAdder) {
        if (source.getTextBox() != null) {
            target.createTextBox();
            GsoCopier.textBox(source.getTextBox(), target.getTextBox(), docInfoAdder);
        }
        ShapeComponentRectangle sourceSCR = source.getShapeComponentRectangle();
        ShapeComponentRectangle targetSCR = target.getShapeComponentRectangle();
        targetSCR.copy(sourceSCR);
    }

    private static void textBox(TextBox source, TextBox target, DocInfoAdder docInfoAdder) {
        GsoCopier.listHeader(source.getListHeader(), target.getListHeader());
        ParagraphCopier.listCopy(source.getParagraphList(), target.getParagraphList(), docInfoAdder);
    }

    private static void listHeader(ListHeaderForTextBox source, ListHeaderForTextBox target) {
        target.copy(source);
    }

    private static void ellipse(ControlEllipse source, ControlEllipse target, DocInfoAdder docInfoAdder) {
        if (source.getTextBox() != null) {
            target.createTextBox();
            GsoCopier.textBox(source.getTextBox(), target.getTextBox(), docInfoAdder);
        }
        ShapeComponentEllipse sourceSCE = source.getShapeComponentEllipse();
        ShapeComponentEllipse targetSCE = target.getShapeComponentEllipse();
        targetSCE.copy(sourceSCE);
    }

    private static void arc(ControlArc source, ControlArc target, DocInfoAdder docInfoAdder) {
        if (source.getTextBox() != null) {
            target.createTextBox();
            GsoCopier.textBox(source.getTextBox(), target.getTextBox(), docInfoAdder);
        }
        ShapeComponentArc sourceSCA = source.getShapeComponentArc();
        ShapeComponentArc targetSCA = target.getShapeComponentArc();
        targetSCA.copy(sourceSCA);
    }

    private static void polygon(ControlPolygon source, ControlPolygon target, DocInfoAdder docInfoAdder) {
        if (source.getTextBox() != null) {
            target.createTextBox();
            GsoCopier.textBox(source.getTextBox(), target.getTextBox(), docInfoAdder);
        }
        ShapeComponentPolygon sourceSCP = source.getShapeComponentPolygon();
        ShapeComponentPolygon targetSCP = target.getShapeComponentPolygon();
        targetSCP.copy(sourceSCP);
    }

    private static void curve(ControlCurve source, ControlCurve target, DocInfoAdder docInfoAdder) {
        if (source.getTextBox() != null) {
            target.createTextBox();
            GsoCopier.textBox(source.getTextBox(), target.getTextBox(), docInfoAdder);
        }
        ShapeComponentCurve sourceSCC = source.getShapeComponentCurve();
        ShapeComponentCurve targetSCC = target.getShapeComponentCurve();
        targetSCC.copy(sourceSCC);
    }

    private static void picture(ControlPicture source, ControlPicture target, DocInfoAdder docInfoAdder) {
        ShapeComponentPicture sourceSCP = source.getShapeComponentPicture();
        ShapeComponentPicture targetSCP = target.getShapeComponentPicture();
        targetSCP.getBorderColor().setValue(sourceSCP.getBorderColor().getValue());
        targetSCP.setBorderThickness(sourceSCP.getBorderThickness());
        targetSCP.getBorderProperty().setValue(sourceSCP.getBorderProperty().getValue());
        GsoCopier.positionXY(sourceSCP.getLeftTop(), targetSCP.getLeftTop());
        GsoCopier.positionXY(sourceSCP.getRightTop(), targetSCP.getRightTop());
        GsoCopier.positionXY(sourceSCP.getLeftBottom(), targetSCP.getLeftBottom());
        GsoCopier.positionXY(sourceSCP.getRightBottom(), targetSCP.getRightBottom());
        targetSCP.setLeftAfterCutting(sourceSCP.getLeftAfterCutting());
        targetSCP.setTopAfterCutting(sourceSCP.getTopAfterCutting());
        targetSCP.setRightAfterCutting(sourceSCP.getRightAfterCutting());
        targetSCP.setBottomAfterCutting(sourceSCP.getBottomAfterCutting());
        GsoCopier.innerMargin(sourceSCP.getInnerMargin(), targetSCP.getInnerMargin());
        GsoCommonPartCopier.pictureInfo(sourceSCP.getPictureInfo(), targetSCP.getPictureInfo(), docInfoAdder);
        targetSCP.setBorderTransparency(sourceSCP.getBorderTransparency());
        targetSCP.setInstanceId(sourceSCP.getInstanceId());
        GsoCopier.pictureEffect(sourceSCP.getPictureEffect(), targetSCP.getPictureEffect());
        targetSCP.setImageWidth(sourceSCP.getImageWidth());
        targetSCP.setImageHeight(sourceSCP.getImageHeight());
    }

    private static void positionXY(PositionXY source, PositionXY target) {
        target.copy(source);
    }

    private static void innerMargin(InnerMargin source, InnerMargin target) {
        target.copy(source);
    }

    private static void pictureEffect(PictureEffect source, PictureEffect target) {
        target.copy(source);
    }

    private static void ole(ControlOLE source, ControlOLE target, DocInfoAdder docInfoAdder) {
        ShapeComponentOLE sourceSCO = source.getShapeComponentOLE();
        ShapeComponentOLE targetSCO = target.getShapeComponentOLE();
        targetSCO.getProperty().setValue(sourceSCO.getProperty().getValue());
        targetSCO.setExtentWidth(sourceSCO.getExtentWidth());
        targetSCO.setExtentHeight(sourceSCO.getExtentHeight());
        targetSCO.setBinDataId(docInfoAdder == null ? sourceSCO.getBinDataId() : docInfoAdder.forBinData().processById(sourceSCO.getBinDataId()));
        targetSCO.getBorderColor().setValue(sourceSCO.getBorderColor().getValue());
        targetSCO.setBorderThickness(sourceSCO.getBorderThickness());
        targetSCO.getBorderProperty().setValue(sourceSCO.getBorderProperty().getValue());
        targetSCO.setUnknown(sourceSCO.getUnknown());
    }

    private static void container(ControlContainer source, ControlContainer target, DocInfoAdder docInfoAdder) {
        for (GsoControl sourceChild : source.getChildControlList()) {
            GsoControl targetChild = target.addNewChildControl(sourceChild.getGsoType());
            GsoCopier.copy(sourceChild, targetChild, docInfoAdder);
        }
    }

    private static void objectLinkLine(ControlObjectLinkLine source, ControlObjectLinkLine target, DocInfoAdder docInfoAdder) {
        ShapeComponentLineForObjectLinkLine sourceSCL = source.getShapeComponentLine();
        ShapeComponentLineForObjectLinkLine targetSCL = target.getShapeComponentLine();
        targetSCL.copy(sourceSCL);
    }

    private static void textArt(ControlTextArt source, ControlTextArt target, DocInfoAdder docInfoAdder) {
        ShapeComponentTextArt sourceSCTA = source.getShapeComponentTextArt();
        ShapeComponentTextArt targetSCTA = target.getShapeComponentTextArt();
        targetSCTA.copy(sourceSCTA);
    }
}

