/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder.docinfo;

import java.util.HashMap;
import kr.dogfoot.hwplib.object.docinfo.Bullet;
import kr.dogfoot.hwplib.object.docinfo.numbering.ParagraphHeadInfo;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.ForFillInfo;

public class BulletAdder {
    private DocInfoAdder docInfoAdder;
    private HashMap<Integer, Integer> idMatchingMap;

    public BulletAdder(DocInfoAdder docInfoAdder) {
        this.docInfoAdder = docInfoAdder;
        this.idMatchingMap = new HashMap();
    }

    public int processById(int sourceId) {
        Bullet source;
        if (this.docInfoAdder.getSourceHWPFile() == this.docInfoAdder.getTargetHWPFile()) {
            return sourceId;
        }
        if (this.idMatchingMap.containsKey(sourceId)) {
            return this.idMatchingMap.get(sourceId);
        }
        try {
            source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getBulletList().get(sourceId - 1);
        }
        catch (Exception e) {
            return sourceId;
        }
        int id = this.findFromTarget(source);
        if (id == -1) {
            id = this.addAndCopy(source);
        }
        this.idMatchingMap.put(sourceId, id);
        return id;
    }

    private int findFromTarget(Bullet source) {
        int count = this.docInfoAdder.getTargetHWPFile().getDocInfo().getBulletList().size();
        for (int index = 0; index < count; ++index) {
            Bullet target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getBulletList().get(index);
            if (!this.equal(source, target)) continue;
            return index + 1;
        }
        return -1;
    }

    private boolean equal(Bullet source, Bullet target) {
        return this.equalParagraphHeadInfo(source.getParagraphHeadInfo(), target.getParagraphHeadInfo()) && source.getBulletChar().equals(target.getBulletChar()) && source.getCheckBulletChar().equals(target.getCheckBulletChar()) && !(source.getImageBullet() == target.getImageBullet());
    }

    private boolean equalParagraphHeadInfo(ParagraphHeadInfo source, ParagraphHeadInfo target) {
        return source.getProperty().getValue() == target.getProperty().getValue() && source.getCorrectionValueForWidth() == target.getCorrectionValueForWidth() && source.getDistanceFromBody() == target.getDistanceFromBody() && this.docInfoAdder.forCharShape().equalById((int)source.getCharShapeID(), (int)target.getCharShapeID());
    }

    private int addAndCopy(Bullet source) {
        Bullet target = this.docInfoAdder.getTargetHWPFile().getDocInfo().addNewBullet();
        this.copyParagraphHeadInfo(source.getParagraphHeadInfo(), target.getParagraphHeadInfo());
        target.getBulletChar().copy(source.getBulletChar());
        target.setImageBullet(source.getImageBullet());
        ForFillInfo.copyPictureInfo(source.getImageBulletInfo(), target.getImageBulletInfo(), this.docInfoAdder);
        target.getCheckBulletChar().copy(source.getCheckBulletChar());
        return this.docInfoAdder.getTargetHWPFile().getDocInfo().getBulletList().size();
    }

    private void copyParagraphHeadInfo(ParagraphHeadInfo source, ParagraphHeadInfo target) {
        target.getProperty().setValue(source.getProperty().getValue());
        target.setCorrectionValueForWidth(source.getCorrectionValueForWidth());
        target.setDistanceFromBody(source.getDistanceFromBody());
        target.setCharShapeID(this.docInfoAdder.forCharShape().processById((int)source.getCharShapeID()));
    }

    public boolean equalById(int sourceId, int targetId) {
        Bullet target;
        Bullet source;
        try {
            source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getBulletList().get(sourceId - 1);
        }
        catch (Exception e) {
            source = null;
        }
        try {
            target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getBulletList().get(targetId - 1);
        }
        catch (Exception e) {
            target = null;
        }
        if (source == null && target == null) {
            return sourceId == targetId;
        }
        if (source == null || target == null) {
            return false;
        }
        return this.equal(source, target);
    }
}

