/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder.docinfo;

import java.util.HashMap;
import kr.dogfoot.hwplib.object.docinfo.Numbering;
import kr.dogfoot.hwplib.object.docinfo.numbering.LevelNumbering;
import kr.dogfoot.hwplib.object.docinfo.numbering.ParagraphHeadInfo;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;

public class NumberingAdder {
    private DocInfoAdder docInfoAdder;
    private HashMap<Integer, Integer> idMatchingMap;

    public NumberingAdder(DocInfoAdder docInfoAdder) {
        this.docInfoAdder = docInfoAdder;
        this.idMatchingMap = new HashMap();
    }

    public int processById(int sourceId) {
        Numbering source;
        if (this.docInfoAdder.getSourceHWPFile() == this.docInfoAdder.getTargetHWPFile()) {
            return sourceId;
        }
        if (this.idMatchingMap.containsKey(sourceId)) {
            return this.idMatchingMap.get(sourceId);
        }
        try {
            source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getNumberingList().get(sourceId - 1);
        }
        catch (Exception e) {
            return sourceId;
        }
        int id = this.findFromTarget(source);
        if (id == -1) {
            id = this.addAndCopy(source);
        }
        this.idMatchingMap.put(sourceId, id);
        return id;
    }

    private int findFromTarget(Numbering source) {
        int count = this.docInfoAdder.getTargetHWPFile().getDocInfo().getNumberingList().size();
        for (int index = 0; index < count; ++index) {
            Numbering target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getNumberingList().get(index);
            if (!this.equal(source, target)) continue;
            return index + 1;
        }
        return -1;
    }

    private boolean equal(Numbering source, Numbering target) {
        return this.equalLevelNumberingList(source, target) && source.getStartNumber() == target.getStartNumber();
    }

    private boolean equalLevelNumberingList(Numbering source, Numbering target) {
        for (int level = 0; level < 7; ++level) {
            try {
                if (!this.equalLevelNumbering(source.getLevelNumbering(level), target.getLevelNumbering(level))) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean equalLevelNumbering(LevelNumbering source, LevelNumbering target) {
        return this.equalParagraphHeadInfo(source.getParagraphHeadInfo(), target.getParagraphHeadInfo()) && source.getNumberFormat().equals(target.getNumberFormat()) && source.getStartNumber() == target.getStartNumber();
    }

    private boolean equalParagraphHeadInfo(ParagraphHeadInfo source, ParagraphHeadInfo target) {
        return source.getProperty().getValue() == target.getProperty().getValue() && source.getCorrectionValueForWidth() == target.getCorrectionValueForWidth() && source.getDistanceFromBody() == target.getDistanceFromBody() && this.docInfoAdder.forCharShape().equalById((int)source.getCharShapeID(), (int)target.getCharShapeID());
    }

    private int addAndCopy(Numbering source) {
        Numbering target = this.docInfoAdder.getTargetHWPFile().getDocInfo().addNewNumbering();
        for (int level = 0; level < 10; ++level) {
            try {
                this.copyLevelNumbering(source.getLevelNumbering(level), target.getLevelNumbering(level));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        target.setStartNumber(source.getStartNumber());
        return this.docInfoAdder.getTargetHWPFile().getDocInfo().getNumberingList().size();
    }

    private void copyLevelNumbering(LevelNumbering source, LevelNumbering target) {
        this.copyParagraphHeadInfo(source.getParagraphHeadInfo(), target.getParagraphHeadInfo());
        target.getNumberFormat().copy(source.getNumberFormat());
        target.setStartNumber(source.getStartNumber());
    }

    private void copyParagraphHeadInfo(ParagraphHeadInfo source, ParagraphHeadInfo target) {
        target.getProperty().setValue(source.getProperty().getValue());
        target.setCorrectionValueForWidth(source.getCorrectionValueForWidth());
        target.setDistanceFromBody(source.getDistanceFromBody());
        target.setCharShapeID(this.docInfoAdder.forCharShape().processById((int)source.getCharShapeID()));
    }

    public boolean equalById(int sourceId, int targetId) {
        Numbering source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getNumberingList().get(sourceId - 1);
        Numbering target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getNumberingList().get(targetId - 1);
        return this.equal(source, target);
    }
}

