/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.textextractor;

import java.io.UnsupportedEncodingException;
import kr.dogfoot.hwplib.object.bodytext.ParagraphListInterface;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlAdditionalText;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlEquation;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFooter;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ControlHiddenComment;
import kr.dogfoot.hwplib.object.bodytext.control.ControlTable;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.table.Cell;
import kr.dogfoot.hwplib.object.bodytext.control.table.Row;
import kr.dogfoot.hwplib.tool.textextractor.ForGso;
import kr.dogfoot.hwplib.tool.textextractor.ForParagraphList;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractMethod;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractOption;
import kr.dogfoot.hwplib.tool.textextractor.paraHead.ParaHeadMaker;

public class ForControl {
    public static void extract(Control c, TextExtractMethod tem, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForControl.extract(c, new TextExtractOption(tem), paraHeadMaker, sb);
    }

    public static void extract(Control c, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        if (!c.isField()) {
            switch (c.getType()) {
                case Table: {
                    ForControl.table((ControlTable)c, option, paraHeadMaker, sb);
                    break;
                }
                case Gso: {
                    ForGso.extract((GsoControl)c, option, paraHeadMaker, sb);
                    break;
                }
                case Equation: {
                    ForControl.equation((ControlEquation)c, sb);
                    break;
                }
                case SectionDefine: {
                    break;
                }
                case ColumnDefine: {
                    break;
                }
                case Header: {
                    ForControl.header((ControlHeader)c, option, paraHeadMaker, sb);
                    break;
                }
                case Footer: {
                    ForControl.footer((ControlFooter)c, option, paraHeadMaker, sb);
                    break;
                }
                case Footnote: {
                    ForControl.footnote((ControlFootnote)c, option, paraHeadMaker, sb);
                    break;
                }
                case Endnote: {
                    ForControl.endnote((ControlEndnote)c, option, paraHeadMaker, sb);
                    break;
                }
                case AutoNumber: {
                    break;
                }
                case NewNumber: {
                    break;
                }
                case PageHide: {
                    break;
                }
                case PageOddEvenAdjust: {
                    break;
                }
                case PageNumberPosition: {
                    break;
                }
                case IndexMark: {
                    break;
                }
                case Bookmark: {
                    break;
                }
                case OverlappingLetter: {
                    break;
                }
                case AdditionalText: {
                    ForControl.additionalText((ControlAdditionalText)c, sb);
                    break;
                }
                case HiddenComment: {
                    ForControl.hiddenComment((ControlHiddenComment)c, option, paraHeadMaker, sb);
                    break;
                }
            }
        }
    }

    private static void table(ControlTable table, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        for (Row r : table.getRowList()) {
            for (Cell c : r.getCellList()) {
                ForParagraphList.extract((ParagraphListInterface)c.getParagraphList(), option, paraHeadMaker, sb);
            }
        }
    }

    private static void equation(ControlEquation equation, StringBuffer sb) {
        sb.append(equation.getEQEdit().getScript().toUTF16LEString()).append("\n");
    }

    private static void header(ControlHeader header, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraphList.extract((ParagraphListInterface)header.getParagraphList(), option, paraHeadMaker, sb);
    }

    private static void footer(ControlFooter footer, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraphList.extract((ParagraphListInterface)footer.getParagraphList(), option, paraHeadMaker, sb);
    }

    private static void footnote(ControlFootnote footnote, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraphList.extract((ParagraphListInterface)footnote.getParagraphList(), option, paraHeadMaker, sb);
    }

    private static void endnote(ControlEndnote endnote, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraphList.extract((ParagraphListInterface)endnote.getParagraphList(), option, paraHeadMaker, sb);
    }

    private static void additionalText(ControlAdditionalText additionalText, StringBuffer sb) {
        sb.append(additionalText.getHeader().getMainText()).append("\n");
        sb.append(additionalText.getHeader().getSubText()).append("\n");
    }

    private static void hiddenComment(ControlHiddenComment hiddenComment, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraphList.extract((ParagraphListInterface)hiddenComment.getParagraphList(), option, paraHeadMaker, sb);
    }
}

