/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.textextractor;

import java.io.UnsupportedEncodingException;
import kr.dogfoot.hwplib.object.bodytext.ParagraphListInterface;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.tool.textextractor.ForParagraph;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractMethod;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractOption;
import kr.dogfoot.hwplib.tool.textextractor.paraHead.ParaHeadMaker;

public class ForParagraphList {
    public static void extract(ParagraphListInterface paragraphList, TextExtractMethod tem, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraphList.extract(paragraphList, new TextExtractOption(tem, true), paraHeadMaker, sb);
    }

    public static void extract(ParagraphListInterface paragraphList, TextExtractOption option, ParaHeadMaker paraHeadMaker, StringBuffer sb) throws UnsupportedEncodingException {
        if (paragraphList == null || paragraphList.getParagraphCount() == 0) {
            return;
        }
        if (paragraphList.getParagraphCount() == 1) {
            ForParagraph.extract(paragraphList.getParagraph(0), -1, 65535, false, option, paraHeadMaker, sb);
        } else {
            for (int index = 0; index < paragraphList.getParagraphCount() - 2; ++index) {
                ForParagraph.extract(paragraphList.getParagraph(index), -1, 65535, true, option, paraHeadMaker, sb);
            }
            Paragraph lastPara = paragraphList.getParagraph(paragraphList.getParagraphCount() - 1);
            ForParagraph.extract(lastPara, -1, 65535, false, option, paraHeadMaker, sb);
        }
    }

    public static void extract(ParagraphListInterface paragraphList, int startParaIndex, int startCharIndex, int endParaIndex, int endCharIndex, TextExtractOption option, StringBuffer sb) throws UnsupportedEncodingException {
        if (startParaIndex == endParaIndex) {
            ForParagraph.extract(paragraphList.getParagraph(startParaIndex), startCharIndex, endCharIndex, false, option, null, sb);
        } else {
            ForParagraph.extract(paragraphList.getParagraph(startParaIndex), startCharIndex, 65535, true, option, null, sb);
            if (startParaIndex + 1 < endParaIndex) {
                for (int paraIndex = startParaIndex + 1; paraIndex <= endParaIndex - 1; ++paraIndex) {
                    ForParagraph.extract(paragraphList.getParagraph(paraIndex), -1, 65535, true, option, null, sb);
                }
            }
            ForParagraph.extract(paragraphList.getParagraph(endParaIndex), -1, endCharIndex, false, option, null, sb);
        }
    }

    public static void extract(ParagraphListInterface paragraphList, int startParaIndex, int startCharIndex, int endParaIndex, int endCharIndex, boolean appendLF, TextExtractMethod tem, StringBuffer sb) throws UnsupportedEncodingException {
        ForParagraphList.extract(paragraphList, startParaIndex, startCharIndex, endParaIndex, endCharIndex, new TextExtractOption(tem, appendLF), sb);
    }
}

