/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.textextractor.paraHead;

import kr.dogfoot.hwplib.object.docinfo.numbering.ParagraphNumberFormat;

public class ParaHeadNumber {
    private static String[] circledNumbers;
    private static String[] circledUppercaseAlphabets;
    private static String[] circledLowercaseAlphabets;
    private static String[] hangul;
    private static String[] circledHangul;
    private static String[] hangulJamo;
    private static String[] circledHangulJamo;
    private static String[] hangulNumber;
    private static String[] hanjaNumber;
    private static String[] circledHanjaNumber;
    private static String[] sibGanHangul;
    private static String[] sibGanHanja;

    private static void setCircledNumbers() {
        String chars = "\u2460\u2461\u2462\u2463\u2464\u2465\u2466\u2467\u2468\u2469\u246a\u246b\u246c\u246d\u246e\u246f\u2470\u2471\u2472\u2473";
        circledNumbers = new String[chars.length()];
        for (int index = 0; index < circledNumbers.length; ++index) {
            ParaHeadNumber.circledNumbers[index] = chars.substring(index, index + 1);
        }
    }

    private static void setCircledUppercaseAlphabets() {
        String chars = "\u24b6\u24b7\u24b8\u24b9\u24ba\u24bb\u24bc\u24bd\u24be\u24bf\u24c0\u24c1\u24c2\u24c3\u24c4\u24c5\u24c6\u24c7\u24c8\u24c9\u24ca\u24cb\u24cc\u24cd\u24ce\u24cf";
        circledUppercaseAlphabets = new String[chars.length()];
        for (int index = 0; index < circledUppercaseAlphabets.length; ++index) {
            ParaHeadNumber.circledUppercaseAlphabets[index] = chars.substring(index, index + 1);
        }
    }

    private static void setCircledLowercaseAlphabets() {
        String chars = "\u24d0\u24d1\u24d2\u24d3\u24d4\u24d5\u24d6\u24d7\u24d8\u24d9\u24da\u24db\u24dc\u24dd\u24de\u24df\u24e0\u24e1\u24e2\u24e3\u24e4\u24e5\u24e6\u24e7\u24e8\u24e9";
        circledLowercaseAlphabets = new String[chars.length()];
        for (int index = 0; index < circledLowercaseAlphabets.length; ++index) {
            ParaHeadNumber.circledLowercaseAlphabets[index] = chars.substring(index, index + 1);
        }
    }

    private static void setHangul() {
        String chars = "\uac00\ub098\ub2e4\ub77c\ub9c8\ubc14\uc0ac\uc544\uc790\ucc28\uce74\ud0c0\ud30c\ud558\uac70\ub108\ub354\ub7ec\uba38\ubc84\uc11c\uc5b4\uc800\ucc98\ucee4\ud130\ud37c\ud5c8\uace0\ub178\ub3c4\ub85c\ubaa8\ubcf4\uc18c\uc624\uc870\ucd08\ucf54\ud1a0\ud3ec\ud638\uad6c\ub204\ub450\ub8e8\ubb34\ubd80\uc218\uc6b0\uc8fc\ucd94\ucfe0\ud22c\ud478\ud6c4\uadf8\ub290\ub4dc\ub974\ubbc0\ube0c\uc2a4\uc73c\uc988\uce20\ud06c\ud2b8\ud504\ud750\uae30\ub2c8\ub514\ub9ac\ubbf8\ube44\uc2dc\uc774\uc9c0\uce58\ud0a4\ud53c\ud53c\ud788";
        hangul = new String[chars.length()];
        for (int index = 0; index < hangul.length; ++index) {
            ParaHeadNumber.hangul[index] = chars.substring(index, index + 1);
        }
    }

    private static void setCircledHangul() {
        String chars = "\u326e\u326f\u3270\u3271\u3272\u3273\u3274\u3275\u3276\u3277\u3278\u3279\u327a\u327b";
        circledHangul = new String[chars.length()];
        for (int index = 0; index < circledHangul.length; ++index) {
            ParaHeadNumber.circledHangul[index] = chars.substring(index, index + 1);
        }
    }

    private static void setHangulJamo() {
        String chars = "\u3131\u3134\u3137\u3139\u3141\u3142\u3145\u3147\u3148\u314a\u314b\u314c\u314d\u314e";
        hangulJamo = new String[chars.length()];
        for (int index = 0; index < hangulJamo.length; ++index) {
            ParaHeadNumber.hangulJamo[index] = chars.substring(index, index + 1);
        }
    }

    private static void setCircledHangulJamo() {
        String chars = "\u3260\u3261\u3262\u3263\u3264\u3265\u3266\u3267\u3268\u3269\u326a\u326b\u326c\u326d";
        circledHangulJamo = new String[chars.length()];
        for (int index = 0; index < circledHangulJamo.length; ++index) {
            ParaHeadNumber.circledHangulJamo[index] = chars.substring(index, index + 1);
        }
    }

    private static void setHangulNumber() {
        String chars = "\uc77c\uc774\uc0bc\uc0ac\uc624\uc721\uce60\ud314\uad6c\uc2ed";
        hangulNumber = new String[chars.length()];
        for (int index = 0; index < hangulNumber.length; ++index) {
            ParaHeadNumber.hangulNumber[index] = chars.substring(index, index + 1);
        }
    }

    private static void setHanjaNumber() {
        String chars = "\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341";
        hanjaNumber = new String[chars.length()];
        for (int index = 0; index < hanjaNumber.length; ++index) {
            ParaHeadNumber.hanjaNumber[index] = chars.substring(index, index + 1);
        }
    }

    private static void setCircledHanjaNumber() {
        String chars = "\u3280\u3281\u3282\u3283\u3284\u3285\u3286\u3287\u3288\u3289";
        circledHanjaNumber = new String[chars.length()];
        for (int index = 0; index < circledHanjaNumber.length; ++index) {
            ParaHeadNumber.circledHanjaNumber[index] = chars.substring(index, index + 1);
        }
    }

    private static void setSibGanHangul() {
        String chars = "\uac11\uc744\ubcd1\uc815\ubb34\uae30\uacbd\uc2e0\uc784\uacc4";
        sibGanHangul = new String[chars.length()];
        for (int index = 0; index < sibGanHangul.length; ++index) {
            ParaHeadNumber.sibGanHangul[index] = chars.substring(index, index + 1);
        }
    }

    private static void setSibGanHanja() {
        String chars = "\u7532\u4e59\u4e19\u4e01\u620a\u5df1\u5e9a\u8f9b\u58ec\u7678";
        sibGanHanja = new String[chars.length()];
        for (int index = 0; index < sibGanHanja.length; ++index) {
            ParaHeadNumber.sibGanHanja[index] = chars.substring(index, index + 1);
        }
    }

    public static String toString(int value, ParagraphNumberFormat format) {
        if (value <= 0) {
            return "";
        }
        switch (format) {
            case Number: {
                return String.valueOf(value);
            }
            case CircledNumber: {
                return ParaHeadNumber.circledNumber(value);
            }
            case UppercaseRomanNumber: {
                return ParaHeadNumber.romanNumber(value, true);
            }
            case LowercaseRomanNumber: {
                return ParaHeadNumber.romanNumber(value, false);
            }
            case UppercaseAlphabet: {
                return ParaHeadNumber.uppercaseAlphabet(value);
            }
            case LowercaseAlphabet: {
                return ParaHeadNumber.lowercaseAlphabet(value);
            }
            case CircledUppercaseAlphabet: {
                return ParaHeadNumber.circledUppercaseAlphabet(value);
            }
            case CircledLowercaseAlphabet: {
                return ParaHeadNumber.circledLowercaseAlphabet(value);
            }
            case Hangul: {
                return ParaHeadNumber.hangul(value);
            }
            case CircledHangul: {
                return ParaHeadNumber.circledHangul(value);
            }
            case HangulJamo: {
                return ParaHeadNumber.hangulJamo(value);
            }
            case CircledHangulJamo: {
                return ParaHeadNumber.circledHangulJamo(value);
            }
            case HangulNumber: {
                return ParaHeadNumber.hangulNumber(value);
            }
            case HanjaNumber: {
                return ParaHeadNumber.hanjaNumber(value);
            }
            case CircledHanjaNumber: {
                return ParaHeadNumber.circledHanjaNumber(value);
            }
            case SibGanHangul: {
                return ParaHeadNumber.sibGanHangul(value);
            }
            case SibGanHanja: {
                return ParaHeadNumber.sibGanHanja(value);
            }
        }
        return String.valueOf(value);
    }

    private static String romanNumber(int value, boolean uppercase) {
        String[] roman = uppercase ? new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"} : new String[]{"m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", "i"};
        int[] decimal = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String romanNumber = "";
        for (int i = 0; i < 13; ++i) {
            while (value >= decimal[i]) {
                romanNumber = romanNumber + roman[i];
                value -= decimal[i];
            }
        }
        return romanNumber;
    }

    private static String circledNumber(int value) {
        return circledNumbers[(value - 1) % 20];
    }

    private static String uppercaseAlphabet(int value) {
        return new Character((char)(65 + (value - 1) % 26)).toString();
    }

    private static String lowercaseAlphabet(int value) {
        return new Character((char)(97 + (value - 1) % 26)).toString();
    }

    private static String circledUppercaseAlphabet(int value) {
        return circledUppercaseAlphabets[(value - 1) % 26];
    }

    private static String circledLowercaseAlphabet(int value) {
        return circledLowercaseAlphabets[(value - 1) % 26];
    }

    private static String hangul(int value) {
        if (value > 0) {
            return hangul[(value - 1) % 84];
        }
        return null;
    }

    private static String circledHangul(int value) {
        return circledHangul[(value - 1) % 14];
    }

    private static String hangulJamo(int value) {
        return hangulJamo[(value - 1) % 14];
    }

    private static String circledHangulJamo(int value) {
        return circledHangulJamo[(value - 1) % 14];
    }

    private static String hangulNumber(int value) {
        int value2 = (value - 1) % 99 + 1;
        if (value2 <= 10) {
            return hangulNumber[value2 - 1];
        }
        if (value2 <= 19) {
            return hangulNumber[9] + hangulNumber[(value2 - 1) % 10];
        }
        if (value2 % 10 == 0) {
            return hangulNumber[value2 / 10 - 1] + hangulNumber[9];
        }
        return hangulNumber[value2 / 10 - 1] + hangulNumber[9] + hangulNumber[(value2 - 1) % 10];
    }

    private static String hanjaNumber(int value) {
        int value2 = (value - 1) % 99 + 1;
        if (value2 <= 10) {
            return hanjaNumber[value2 - 1];
        }
        if (value2 <= 19) {
            return hanjaNumber[9] + hanjaNumber[(value2 - 1) % 10];
        }
        if (value2 % 10 == 0) {
            return hanjaNumber[value2 / 10 - 1] + hanjaNumber[9];
        }
        return hanjaNumber[value2 / 10 - 1] + hanjaNumber[9] + hanjaNumber[(value2 - 1) % 10];
    }

    private static String circledHanjaNumber(int value) {
        return circledHanjaNumber[(value - 1) % 10];
    }

    private static String sibGanHangul(int value) {
        return sibGanHangul[(value - 1) % 10];
    }

    private static String sibGanHanja(int value) {
        return sibGanHanja[(value - 1) % 10];
    }

    static {
        ParaHeadNumber.setCircledNumbers();
        ParaHeadNumber.setCircledUppercaseAlphabets();
        ParaHeadNumber.setCircledLowercaseAlphabets();
        ParaHeadNumber.setHangul();
        ParaHeadNumber.setCircledHangul();
        ParaHeadNumber.setHangulJamo();
        ParaHeadNumber.setCircledHangulJamo();
        ParaHeadNumber.setHangulNumber();
        ParaHeadNumber.setHanjaNumber();
        ParaHeadNumber.setCircledHanjaNumber();
        ParaHeadNumber.setSibGanHangul();
        ParaHeadNumber.setSibGanHanja();
    }
}

