/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.util.compoundFile.reader;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import kr.dogfoot.hwplib.object.RecordHeader;
import kr.dogfoot.hwplib.object.docinfo.DocInfo;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.util.binary.BitFlag;

public abstract class StreamReader {
    private long size = 0L;
    private long read = 0L;
    private RecordHeader header = new RecordHeader();
    private long readAfterHeader = 0L;
    private FileVersion fileVersion;
    private DocInfo docInfo = null;

    public abstract void readBytes(byte[] var1) throws IOException;

    public abstract byte readSInt1() throws IOException;

    public abstract short readSInt2() throws IOException;

    public abstract int readSInt4() throws IOException;

    public abstract short readUInt1() throws IOException;

    public abstract int readUInt2() throws IOException;

    public abstract long readUInt4() throws IOException;

    public abstract double readDouble() throws IOException;

    public abstract float readFloat() throws IOException;

    public abstract void skip(long var1) throws IOException;

    public abstract void close() throws IOException;

    protected StreamReader() {
    }

    protected void forwardPosition(long n) {
        this.read += n;
        this.readAfterHeader += n;
    }

    public RecordHeader readRecordHeader() throws IOException {
        if (this.isEndOfStream()) {
            this.header.setTagID((short)0);
            this.header.setLevel((short)0);
            this.header.setSize(0L);
        } else {
            long value = this.readUInt4();
            this.header.setTagID((short)BitFlag.get(value, 0, 9));
            this.header.setLevel((short)BitFlag.get(value, 10, 19));
            this.header.setSize((short)BitFlag.get(value, 20, 31));
            if (this.header.getSize() == 4095L) {
                this.header.setSize(this.readUInt4());
            }
        }
        this.readAfterHeader = 0L;
        return this.header;
    }

    public String readUTF16LEString() throws IOException {
        int len = this.readUInt2();
        if (len > 0) {
            byte[] arr = new byte[len * 2];
            this.readBytes(arr);
            return new String(arr, 0, arr.length, StandardCharsets.UTF_16LE);
        }
        return null;
    }

    public byte[] readHWPString() throws IOException {
        int len = this.readUInt2();
        if (len > 0) {
            byte[] arr = new byte[len * 2];
            this.readBytes(arr);
            return arr;
        }
        return null;
    }

    public byte[] readWChar() throws IOException {
        byte[] arr = new byte[2];
        this.readBytes(arr);
        return arr;
    }

    public long getSize() {
        return this.size;
    }

    protected void setSize(long size) {
        this.size = size;
    }

    public long getCurrentPosition() {
        return this.read;
    }

    public boolean isEndOfStream() {
        return this.read >= this.size;
    }

    public RecordHeader getCurrentRecordHeader() {
        return this.header;
    }

    public long getCurrentPositionAfterHeader() {
        return this.readAfterHeader;
    }

    public FileVersion getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(FileVersion fileVersion) {
        this.fileVersion = fileVersion;
    }

    public boolean isEndOfRecord() {
        return this.readAfterHeader >= this.header.getSize();
    }

    public boolean isImmediatelyAfterReadingHeader() {
        return this.readAfterHeader == 0L;
    }

    public void nextRecord() {
        this.readAfterHeader = -1L;
    }

    public void skipToEndRecord() throws IOException {
        long n = this.getCurrentRecordHeader().getSize() - this.getCurrentPositionAfterHeader();
        if (n > 0L) {
            this.skip(n);
        }
    }

    public void setDocInfo(DocInfo docInfo) {
        this.docInfo = docInfo;
    }

    public int correctParaShapeId(int oldParaShapeId) {
        if (this.docInfo != null) {
            return oldParaShapeId - this.docInfo.getIDMappings().getParaShapeCount() + this.docInfo.getParaShapeList().size();
        }
        return oldParaShapeId;
    }
}

