/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.util.compoundFile.reader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Inflater;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentEntry;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentInputStream;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class StreamReaderForCompress
extends StreamReader {
    private ByteArrayInputStream bis;

    public StreamReaderForCompress(DocumentEntry de, FileVersion fileVersion) throws Exception {
        this.setByteArrayInputStream(de);
        this.setFileVersion(fileVersion);
    }

    private void setByteArrayInputStream(DocumentEntry de) throws Exception {
        DocumentInputStream dis = new DocumentInputStream(de);
        byte[] compressed = this.getCompressedBytes(dis, de.getSize());
        dis.close();
        try {
            byte[] decompressed = this.decompress(compressed);
            this.bis = new ByteArrayInputStream(decompressed);
            this.setSize(decompressed.length);
        }
        catch (Exception e) {
            this.bis = new ByteArrayInputStream(compressed);
            this.setSize(compressed.length);
        }
    }

    private byte[] getCompressedBytes(DocumentInputStream dis, int size) throws IOException {
        byte[] buffer = new byte[size];
        dis.read(buffer);
        return buffer;
    }

    private byte[] decompress(byte[] compressed) throws Exception {
        Inflater decompressor = new Inflater(true);
        decompressor.setInput(compressed, 0, compressed.length);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressed.length);
        byte[] buf = new byte[8096];
        while (!decompressor.finished()) {
            int count = decompressor.inflate(buf);
            if (count > 0) {
                bos.write(buf, 0, count);
                continue;
            }
            throw new Exception("can't decompress data");
        }
        bos.close();
        return bos.toByteArray();
    }

    @Override
    public void readBytes(byte[] buffer) throws IOException {
        this.forwardPosition(buffer.length);
        this.bis.read(buffer);
    }

    @Override
    public byte readSInt1() throws IOException {
        byte[] buffer = this.readBytes(1);
        return buffer[0];
    }

    private byte[] readBytes(int n) throws IOException {
        byte[] buffer = new byte[n];
        this.readBytes(buffer);
        return buffer;
    }

    @Override
    public short readSInt2() throws IOException {
        byte[] buffer = this.readBytes(2);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    @Override
    public int readSInt4() throws IOException {
        byte[] buffer = this.readBytes(4);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    @Override
    public short readUInt1() throws IOException {
        return (short)(this.readSInt1() & 0xFF);
    }

    @Override
    public int readUInt2() throws IOException {
        return this.readSInt2() & 0xFFFF;
    }

    @Override
    public long readUInt4() throws IOException {
        return this.readSInt4() & 0xFFFFFFFF;
    }

    @Override
    public double readDouble() throws IOException {
        byte[] buffer = this.readBytes(8);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    @Override
    public float readFloat() throws IOException {
        byte[] buffer = this.readBytes(4);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    @Override
    public void skip(long n) throws IOException {
        this.readBytes((int)n);
    }

    @Override
    public void close() throws IOException {
        this.bis.close();
        this.bis = null;
    }
}

