/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.util.compoundFile.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentEntry;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DocumentInputStream;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class StreamReaderForNormal
extends StreamReader {
    private DocumentInputStream dis;

    public StreamReaderForNormal(DocumentEntry de, FileVersion fileVersion) throws IOException {
        this.dis = new DocumentInputStream(de);
        this.setSize(de.getSize());
        this.setFileVersion(fileVersion);
    }

    @Override
    public void readBytes(byte[] buffer) throws IOException {
        this.forwardPosition(buffer.length);
        this.dis.read(buffer);
    }

    @Override
    public byte readSInt1() {
        this.forwardPosition(1L);
        return this.dis.readByte();
    }

    @Override
    public short readSInt2() {
        this.forwardPosition(2L);
        return this.dis.readShort();
    }

    @Override
    public int readSInt4() {
        this.forwardPosition(4L);
        return this.dis.readInt();
    }

    @Override
    public short readUInt1() {
        this.forwardPosition(1L);
        return (short)(this.dis.readByte() & 0xFF);
    }

    @Override
    public int readUInt2() {
        this.forwardPosition(2L);
        return this.dis.readShort() & 0xFFFF;
    }

    @Override
    public long readUInt4() {
        this.forwardPosition(4L);
        return this.dis.readInt() & 0xFFFFFFFF;
    }

    @Override
    public double readDouble() {
        this.forwardPosition(8L);
        return this.dis.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        byte[] arr = new byte[4];
        this.readBytes(arr);
        return ByteBuffer.wrap(arr).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    @Override
    public void skip(long n) throws IOException {
        this.forwardPosition(n);
        this.dis.skip(n);
    }

    @Override
    public void close() {
        this.dis.close();
        this.dis = null;
    }
}

