/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kr.dogfoot.hwplib.object.HWPFile;
import kr.dogfoot.hwplib.object.bindata.EmbeddedBinaryData;
import kr.dogfoot.hwplib.object.bodytext.Section;
import kr.dogfoot.hwplib.object.bodytext.paragraph.memo.Memo;
import kr.dogfoot.hwplib.object.docinfo.bindata.BinDataCompress;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.org.apache.poi.hpsf.WritingNotSupportedException;
import kr.dogfoot.hwplib.util.compoundFile.writer.CompoundFileWriter;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;
import kr.dogfoot.hwplib.writer.ForFileHeader;
import kr.dogfoot.hwplib.writer.autosetter.AutoSetter;
import kr.dogfoot.hwplib.writer.autosetter.InstanceID;
import kr.dogfoot.hwplib.writer.bodytext.ForSection;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.memo.ForMemo;
import kr.dogfoot.hwplib.writer.docinfo.ForDocInfo;

public class HWPWriter {
    private HWPFile hwpFile;
    private CompoundFileWriter cfw;

    public static void toFile(HWPFile hwpFile, String filepath) throws Exception {
        if (hwpFile.getFileHeader().hasPassword()) {
            throw new Exception("Files with passwords are not supported.");
        }
        HWPWriter w = new HWPWriter(hwpFile);
        w.autoSet();
        w.fileHeader();
        w.docInfo();
        w.bodyText();
        w.binData();
        w.summaryInformation();
        w.writeAndClose(filepath);
    }

    public static void toStream(HWPFile hwpFile, OutputStream os) throws Exception {
        if (hwpFile.getFileHeader().hasPassword()) {
            throw new Exception("Files with passwords are not supported.");
        }
        HWPWriter w = new HWPWriter(hwpFile);
        w.autoSet();
        w.fileHeader();
        w.docInfo();
        w.bodyText();
        w.binData();
        w.summaryInformation();
        w.writeAndClose(os);
    }

    private HWPWriter(HWPFile hwpFile) {
        this.hwpFile = hwpFile;
        this.cfw = new CompoundFileWriter();
    }

    private void autoSet() {
        InstanceID iid = new InstanceID();
        AutoSetter.autoSet(this.hwpFile, iid);
    }

    private void fileHeader() throws IOException {
        StreamWriter sw = this.cfw.openCurrentStream("FileHeader", false, this.getVersion());
        ForFileHeader.write(this.hwpFile.getFileHeader(), sw);
        this.cfw.closeCurrentStream();
    }

    private FileVersion getVersion() {
        return this.hwpFile.getFileHeader().getVersion();
    }

    private void docInfo() throws Exception {
        StreamWriter sw = this.cfw.openCurrentStream("DocInfo", this.isCompressed(), this.getVersion());
        ForDocInfo fdi = new ForDocInfo();
        fdi.write(this.hwpFile.getDocInfo(), sw);
        this.cfw.closeCurrentStream();
    }

    private boolean isCompressed() {
        return this.hwpFile.getFileHeader().isCompressed();
    }

    private void bodyText() throws Exception {
        this.cfw.openCurrentStorage("BodyText");
        int index = 0;
        for (Section s : this.hwpFile.getBodyText().getSectionList()) {
            this.seciton(index, s);
            ++index;
        }
        this.cfw.closeCurrentStorage();
    }

    private void seciton(int index, Section s) throws Exception {
        StreamWriter sw = this.cfw.openCurrentStream("Section" + index, this.isCompressed(), this.getVersion());
        ForSection.write(s, sw);
        if (this.isLastSection(index) && this.hwpFile.getBodyText().getMemoList() != null) {
            for (Memo memo : this.hwpFile.getBodyText().getMemoList()) {
                ForMemo.write(memo, sw);
            }
        }
        this.cfw.closeCurrentStream();
    }

    private boolean isLastSection(int index) {
        return index + 1 == this.hwpFile.getBodyText().getSectionList().size();
    }

    private void binData() throws IOException {
        if (this.hasBinData()) {
            this.cfw.openCurrentStorage("BinData");
            for (EmbeddedBinaryData ebd : this.hwpFile.getBinData().getEmbeddedBinaryDataList()) {
                this.embeddedBinaryData(ebd);
            }
            this.cfw.closeCurrentStorage();
        }
    }

    private boolean hasBinData() {
        return this.hwpFile.getBinData().getEmbeddedBinaryDataList().size() > 0;
    }

    private void embeddedBinaryData(EmbeddedBinaryData ebd) throws IOException {
        StreamWriter sw = this.cfw.openCurrentStream(ebd.getName(), this.isCompressBinData(ebd.getCompressMethod()), this.getVersion());
        sw.writeBytes(ebd.getData());
        this.cfw.closeCurrentStream();
    }

    private boolean isCompressBinData(BinDataCompress compressMethod) {
        switch (compressMethod) {
            case ByStorageDefault: {
                return this.isCompressed();
            }
            case Compress: {
                return true;
            }
            case NoCompress: {
                return false;
            }
        }
        return false;
    }

    private void summaryInformation() throws WritingNotSupportedException, IOException {
        if (this.hwpFile.getSummaryInformation() != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.hwpFile.getSummaryInformation().write(bos);
            if (bos.size() > 0) {
                this.cfw.saveToStream("\u0005HwpSummaryInformation", new ByteArrayInputStream(bos.toByteArray()));
            }
        }
    }

    private void writeAndClose(String filepath) throws IOException {
        this.cfw.write(filepath);
        this.cfw.close();
    }

    private void writeAndClose(OutputStream os) throws IOException {
        this.cfw.write(os);
        this.cfw.close();
    }
}

