/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.paragraph.header.ParaHeader;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class ForParaHeader {
    public static void write(ParaHeader ph, StreamWriter sw) throws IOException {
        ForParaHeader.recordHeader(ph, sw);
        ForParaHeader.lastInList_TextCount(ph, sw);
        sw.writeUInt4(ph.getControlMask().getValue());
        sw.writeUInt2(ph.getParaShapeId());
        sw.writeUInt1(ph.getStyleId());
        sw.writeUInt1(ph.getDivideSort().getValue());
        sw.writeUInt2(ph.getCharShapeCount());
        sw.writeUInt2(ph.getRangeTagCount());
        sw.writeUInt2(ph.getLineAlignCount());
        sw.writeUInt4(ph.getInstanceID());
        if (sw.getFileVersion().isOver(5, 0, 3, 2)) {
            sw.writeUInt2(ph.getIsMergedByTrack());
        }
    }

    private static void recordHeader(ParaHeader ph, StreamWriter sw) throws IOException {
        sw.writeRecordHeader(66, ForParaHeader.getSize(sw.getFileVersion()));
    }

    private static int getSize(FileVersion version) {
        int size = 0;
        size += 22;
        if (version.isOver(5, 0, 3, 2)) {
            size += 2;
        }
        return size;
    }

    private static void lastInList_TextCount(ParaHeader ph, StreamWriter sw) throws IOException {
        long value = 0L;
        if (ph.isLastInList()) {
            value += Integer.MIN_VALUE;
        }
        sw.writeUInt4(value += ph.getCharacterCount() & Integer.MAX_VALUE);
    }
}

