/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.paragraph.lineseg.LineSegItem;
import kr.dogfoot.hwplib.object.bodytext.paragraph.lineseg.ParaLineSeg;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class ForParaLineSeg {
    public static void write(ParaLineSeg pls, StreamWriter sw) throws IOException {
        if (pls == null) {
            return;
        }
        ForParaLineSeg.recordHeader(pls, sw);
        for (LineSegItem lsi : pls.getLineSegItemList()) {
            ForParaLineSeg.lineSegItem(lsi, sw);
        }
    }

    private static void recordHeader(ParaLineSeg pls, StreamWriter sw) throws IOException {
        long size = ForParaLineSeg.getSize(pls);
        sw.writeRecordHeader(69, size);
    }

    private static int getSize(ParaLineSeg pls) {
        return pls.getLineSegItemList().size() * 36;
    }

    private static void lineSegItem(LineSegItem lsi, StreamWriter sw) throws IOException {
        sw.writeUInt4(lsi.getTextStartPosition());
        sw.writeSInt4(lsi.getLineVerticalPosition());
        sw.writeSInt4(lsi.getLineHeight());
        sw.writeSInt4(lsi.getTextPartHeight());
        sw.writeSInt4(lsi.getDistanceBaseLineToLineVerticalPosition());
        sw.writeSInt4(lsi.getLineSpace());
        sw.writeSInt4(lsi.getStartPositionFromColumn());
        sw.writeSInt4(lsi.getSegmentWidth());
        sw.writeUInt4(lsi.getTag().getValue());
    }
}

