/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.ControlOverlappingLetter;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderOverlappingLetter;
import kr.dogfoot.hwplib.object.etc.HWPString;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class ForControlOverlappingLetter {
    public static void write(ControlOverlappingLetter ol, StreamWriter sw) throws IOException {
        ForControlOverlappingLetter.ctrlHeader(ol.getHeader(), sw);
    }

    private static void ctrlHeader(CtrlHeaderOverlappingLetter h, StreamWriter sw) throws IOException {
        ForControlOverlappingLetter.recordHeader(h, sw);
        sw.writeUInt4(h.getCtrlId());
        ForControlOverlappingLetter.overlappingLetters(h, sw);
        sw.writeUInt1(h.getBorderType());
        sw.writeSInt1(h.getInternalFontSize());
        sw.writeUInt1(h.getExpendInsideLetter());
        ForControlOverlappingLetter.charShapeIds(h, sw);
    }

    private static void recordHeader(CtrlHeaderOverlappingLetter h, StreamWriter sw) throws IOException {
        sw.writeRecordHeader(71, ForControlOverlappingLetter.getSize(h));
    }

    private static int getSize(CtrlHeaderOverlappingLetter h) {
        int size = 0;
        size += 4;
        size += 2;
        size += h.getOverlappingLetterList().size() * 2;
        size += 3;
        ++size;
        return size += h.getCharShapeIdList().size() * 4;
    }

    private static void overlappingLetters(CtrlHeaderOverlappingLetter h, StreamWriter sw) throws IOException {
        sw.writeUInt2(h.getOverlappingLetterList().size());
        for (HWPString letter : h.getOverlappingLetterList()) {
            sw.writeWChar(letter.getBytes());
        }
    }

    private static void charShapeIds(CtrlHeaderOverlappingLetter h, StreamWriter sw) throws IOException {
        sw.writeUInt1((short)h.getCharShapeIdList().size());
        for (long charShapeId : h.getCharShapeIdList()) {
            sw.writeUInt4(charShapeId);
        }
    }
}

