/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlArc;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlEllipse;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlLine;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlOLE;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlObjectLinkLine;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPicture;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPolygon;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlRectangle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlTextArt;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControlType;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.ShapeComponentContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.ShapeComponentNormal;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlArc;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlContainer;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlCurve;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlEllipse;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlLine;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlOLE;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlObjectLinkLine;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlPicture;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlPolygon;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlRectangle;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.ForControlTextArt;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.part.ForCaption;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.part.ForCtrlHeaderGso;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.part.shapecomponent.ForShapeComponentForContainer;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.part.shapecomponent.ForShapeComponentForNormal;

public class ForGsoControl {
    public static void write(GsoControl gso, StreamWriter sw) throws Exception {
        ForCtrlHeaderGso.write(gso.getHeader(), sw);
        sw.upRecordLevel();
        ForCaption.write(gso.getCaption(), sw);
        ForGsoControl.shapeComponent(gso, sw);
        ForGsoControl.restPart(gso, sw);
        sw.downRecordLevel();
    }

    private static void shapeComponent(GsoControl gso, StreamWriter sw) throws IOException {
        if (gso.getGsoType() == GsoControlType.Container) {
            ForShapeComponentForContainer.write((ShapeComponentContainer)gso.getShapeComponent(), sw);
        } else {
            ForShapeComponentForNormal.write((ShapeComponentNormal)gso.getShapeComponent(), sw);
        }
    }

    private static void restPart(GsoControl gso, StreamWriter sw) throws Exception {
        switch (gso.getGsoType()) {
            case Line: {
                ForControlLine.writeRest((ControlLine)gso, sw);
                break;
            }
            case Rectangle: {
                ForControlRectangle.writeRest((ControlRectangle)gso, sw);
                break;
            }
            case Ellipse: {
                ForControlEllipse.writeRest((ControlEllipse)gso, sw);
                break;
            }
            case Arc: {
                ForControlArc.writeRest((ControlArc)gso, sw);
                break;
            }
            case Polygon: {
                ForControlPolygon.writeRest((ControlPolygon)gso, sw);
                break;
            }
            case Curve: {
                ForControlCurve.writeRest((ControlCurve)gso, sw);
                break;
            }
            case Picture: {
                ForControlPicture.writeRest((ControlPicture)gso, sw);
                break;
            }
            case OLE: {
                ForControlOLE.writeRest((ControlOLE)gso, sw);
                break;
            }
            case Container: {
                ForControlContainer.writeRest((ControlContainer)gso, sw);
                break;
            }
            case ObjectLinkLine: {
                ForControlObjectLinkLine.writeRest((ControlObjectLinkLine)gso, sw);
                break;
            }
            case TextArt: {
                ForControlTextArt.writeRest((ControlTextArt)gso, sw);
            }
        }
    }

    public static void writeInContainer(GsoControl child, StreamWriter sw) throws Exception {
        sw.upRecordLevel();
        ForGsoControl.shapeComponentInContainer(child, sw);
        ForGsoControl.restPart(child, sw);
        sw.downRecordLevel();
    }

    private static void shapeComponentInContainer(GsoControl child, StreamWriter sw) throws IOException {
        if (child.getGsoType() == GsoControlType.Container) {
            ForShapeComponentForContainer.writeInContainer((ShapeComponentContainer)child.getShapeComponent(), sw);
        } else {
            ForShapeComponentForNormal.writeInContainer((ShapeComponentNormal)child.getShapeComponent(), sw);
        }
    }
}

