/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.part;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.ColorEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.ColorWithEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.NeonEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.PictureEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.ReflectionEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.ShadowEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.SoftEdgeEffect;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class ForPictureEffect {
    public static void write(PictureEffect pe, StreamWriter sw) throws Exception {
        sw.writeUInt4(pe.getProperty().getValue());
        ForPictureEffect.shadowEffect(pe.getShadowEffect(), sw);
        ForPictureEffect.neonEffect(pe.getNeonEffect(), sw);
        ForPictureEffect.softEdgeEffect(pe.getSoftEdgeEffect(), sw);
        ForPictureEffect.reflectionEffect(pe.getReflectionEffect(), sw);
    }

    private static void shadowEffect(ShadowEffect se, StreamWriter sw) throws Exception {
        if (se == null) {
            return;
        }
        sw.writeSInt4(se.getStyle());
        sw.writeFloat(se.getTransparency());
        sw.writeFloat(se.getCloudy());
        sw.writeFloat(se.getDirection());
        sw.writeFloat(se.getDistance());
        sw.writeSInt4(se.getSort());
        sw.writeFloat(se.getTiltAngleX());
        sw.writeFloat(se.getTiltAngleY());
        sw.writeFloat(se.getZoomRateX());
        sw.writeFloat(se.getZoomRateY());
        sw.writeSInt4(se.getRotateWithShape());
        ForPictureEffect.colorPropery(se.getColor(), sw);
    }

    private static void colorPropery(ColorWithEffect cp, StreamWriter sw) throws Exception {
        sw.writeSInt4(cp.getType());
        if (cp.getType() != 0) {
            throw new Exception("not supported color type !!!");
        }
        sw.writeBytes(cp.getColor());
        int colorEffectCount = cp.getColorEffectList().size();
        sw.writeUInt4(colorEffectCount);
        for (ColorEffect ce : cp.getColorEffectList()) {
            sw.writeSInt4(ce.getSort().getValue());
            sw.writeFloat(ce.getValue());
        }
    }

    private static void neonEffect(NeonEffect ne, StreamWriter sw) throws Exception {
        if (ne == null) {
            return;
        }
        sw.writeFloat(ne.getTransparency());
        sw.writeFloat(ne.getRadius());
        ForPictureEffect.colorPropery(ne.getColor(), sw);
    }

    private static void softEdgeEffect(SoftEdgeEffect see, StreamWriter sw) throws IOException {
        if (see == null) {
            return;
        }
        sw.writeFloat(see.getRadius());
    }

    private static void reflectionEffect(ReflectionEffect re, StreamWriter sw) throws IOException {
        if (re == null) {
            return;
        }
        sw.writeSInt4(re.getStyle());
        sw.writeFloat(re.getRadius());
        sw.writeFloat(re.getDirection());
        sw.writeFloat(re.getDistance());
        sw.writeFloat(re.getTiltAngleX());
        sw.writeFloat(re.getTiltAngleY());
        sw.writeFloat(re.getZoomRateX());
        sw.writeFloat(re.getZoomRateY());
        sw.writeSInt4(re.getRotationStyle());
        sw.writeFloat(re.getStartTransparency());
        sw.writeFloat(re.getStartPosition());
        sw.writeFloat(re.getEndTransparency());
        sw.writeFloat(re.getEndPosition());
        sw.writeFloat(re.getOffsetDirection());
    }

    public static int getSize(PictureEffect pe) {
        int size = 0;
        size += 4;
        if (pe.getShadowEffect() != null) {
            size += 44;
            size += ForPictureEffect.getSize(pe.getShadowEffect().getColor());
        }
        if (pe.getNeonEffect() != null) {
            size += 8;
            size += ForPictureEffect.getSize(pe.getNeonEffect().getColor());
        }
        if (pe.getSoftEdgeEffect() != null) {
            size += 4;
        }
        if (pe.getReflectionEffect() != null) {
            size += 56;
        }
        return size;
    }

    private static int getSize(ColorWithEffect color) {
        int size = 0;
        size += 8;
        size += 4;
        return size += 8 * color.getColorEffectList().size();
    }
}

