/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.part;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.ParameterSet;
import kr.dogfoot.hwplib.object.bodytext.control.gso.textbox.ListHeaderForTextBox;
import kr.dogfoot.hwplib.object.bodytext.control.gso.textbox.TextBox;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.ForParagraphList;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.bookmark.ForParameterSet;

public class ForTextBox {
    public static void write(TextBox tb, StreamWriter sw) throws Exception {
        if (tb == null) {
            return;
        }
        ForTextBox.listHeader(tb.getListHeader(), sw);
        ForParagraphList.write(tb.getParagraphList(), sw);
    }

    private static void listHeader(ListHeaderForTextBox lh, StreamWriter sw) throws IOException {
        ParameterSet psFieldName = ParameterSet.createForFieldName(lh.getFieldName());
        ForTextBox.recordHeader(psFieldName, sw);
        sw.writeSInt4(lh.getParaCount());
        sw.writeUInt4(lh.getProperty().getValue());
        sw.writeUInt2(lh.getLeftMargin());
        sw.writeUInt2(lh.getRightMargin());
        sw.writeUInt2(lh.getTopMargin());
        sw.writeUInt2(lh.getBottomMargin());
        sw.writeUInt4(lh.getTextWidth());
        sw.writeZero(8);
        if (lh.isEditableAtFormMode()) {
            sw.writeSInt4(1);
        } else {
            sw.writeSInt4(0);
        }
        if (psFieldName != null) {
            short flag = 255;
            sw.writeUInt1(flag);
            ForParameterSet.write(psFieldName, sw);
        } else {
            short flag = 0;
            sw.writeUInt1(flag);
        }
    }

    private static void recordHeader(ParameterSet psFieldName, StreamWriter sw) throws IOException {
        sw.writeRecordHeader(72, ForTextBox.getSize(psFieldName));
    }

    private static int getSize(ParameterSet psFieldName) {
        int size = 0;
        size += 32;
        if (psFieldName != null) {
            ++size;
            size += ForParameterSet.getSize(psFieldName);
        } else {
            ++size;
        }
        return size;
    }
}

