/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control.tbl;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.ParameterSet;
import kr.dogfoot.hwplib.object.bodytext.control.table.Cell;
import kr.dogfoot.hwplib.object.bodytext.control.table.ListHeaderForCell;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.ForParagraphList;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.bookmark.ForParameterSet;

public class ForCell {
    public static void write(Cell c, StreamWriter sw) throws Exception {
        ForCell.listHeader(c.getListHeader(), sw);
        ForParagraphList.write(c.getParagraphList(), sw);
    }

    private static void listHeader(ListHeaderForCell lh, StreamWriter sw) throws IOException {
        ParameterSet psFieldName = ParameterSet.createForFieldName(lh.getFieldName());
        ForCell.recordHeader(psFieldName, sw);
        sw.writeSInt4(lh.getParaCount());
        sw.writeUInt4(lh.getProperty().getValue());
        sw.writeUInt2(lh.getColIndex());
        sw.writeUInt2(lh.getRowIndex());
        sw.writeUInt2(lh.getColSpan());
        sw.writeUInt2(lh.getRowSpan());
        sw.writeUInt4(lh.getWidth());
        sw.writeUInt4(lh.getHeight());
        sw.writeUInt2(lh.getLeftMargin());
        sw.writeUInt2(lh.getRightMargin());
        sw.writeUInt2(lh.getTopMargin());
        sw.writeUInt2(lh.getBottomMargin());
        sw.writeUInt2(lh.getBorderFillId());
        sw.writeUInt4(lh.getTextWidth());
        if (psFieldName != null) {
            short flag = 255;
            sw.writeUInt1(flag);
            ForParameterSet.write(psFieldName, sw);
        } else {
            short flag = 0;
            sw.writeUInt1(flag);
        }
        sw.writeZero(8);
    }

    private static void recordHeader(ParameterSet psFieldName, StreamWriter sw) throws IOException {
        sw.writeRecordHeader(72, ForCell.getSize(psFieldName));
    }

    private static int getSize(ParameterSet psFieldName) {
        int size = 0;
        size += 38;
        if (psFieldName != null) {
            ++size;
            size += ForParameterSet.getSize(psFieldName);
        } else {
            ++size;
        }
        return size += 8;
    }
}

