/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control.tbl;

import java.io.IOException;
import java.util.ArrayList;
import kr.dogfoot.hwplib.object.bodytext.control.table.Table;
import kr.dogfoot.hwplib.object.bodytext.control.table.ZoneInfo;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class ForTable {
    public static void write(Table t, StreamWriter sw) throws IOException {
        ForTable.recordHeader(t, sw);
        sw.writeUInt4(t.getProperty().getValue());
        sw.writeUInt2(t.getRowCount());
        sw.writeUInt2(t.getColumnCount());
        sw.writeUInt2(t.getCellSpacing());
        sw.writeUInt2(t.getLeftInnerMargin());
        sw.writeUInt2(t.getRightInnerMargin());
        sw.writeUInt2(t.getTopInnerMargin());
        sw.writeUInt2(t.getBottomInnerMargin());
        for (int index = 0; index < t.getRowCount(); ++index) {
            sw.writeUInt2(t.getCellCountOfRowList().get(index));
        }
        sw.writeUInt2(t.getBorderFillId());
        if (sw.getFileVersion().isOver(5, 0, 1, 0)) {
            ForTable.zoneInfo(t, sw);
        }
    }

    private static void recordHeader(Table t, StreamWriter sw) throws IOException {
        sw.writeRecordHeader(77, ForTable.getSize(t, sw.getFileVersion()));
    }

    private static int getSize(Table t, FileVersion version) {
        int size = 0;
        size += 18;
        size += 2 * t.getRowCount();
        size += 2;
        if (version.isOver(5, 0, 1, 0)) {
            size += 2;
            size += 10 * t.getZoneInfoList().size();
        }
        return size;
    }

    private static void zoneInfo(Table t, StreamWriter sw) throws IOException {
        ArrayList<ZoneInfo> ziList = t.getZoneInfoList();
        int count = ziList.size();
        sw.writeUInt2(count);
        for (int index = 0; index < count; ++index) {
            ZoneInfo zi = ziList.get(index);
            sw.writeUInt2(zi.getStartColumn());
            sw.writeUInt2(zi.getStartRow());
            sw.writeUInt2(zi.getEndColumn());
            sw.writeUInt2(zi.getEndRow());
            sw.writeUInt2(zi.getBorderFillId());
        }
    }
}

