/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.docinfo;

import java.io.IOException;
import java.util.ArrayList;
import kr.dogfoot.hwplib.object.docinfo.BinData;
import kr.dogfoot.hwplib.object.docinfo.BorderFill;
import kr.dogfoot.hwplib.object.docinfo.Bullet;
import kr.dogfoot.hwplib.object.docinfo.CharShape;
import kr.dogfoot.hwplib.object.docinfo.DocInfo;
import kr.dogfoot.hwplib.object.docinfo.DocumentProperties;
import kr.dogfoot.hwplib.object.docinfo.FaceName;
import kr.dogfoot.hwplib.object.docinfo.IDMappings;
import kr.dogfoot.hwplib.object.docinfo.MemoShape;
import kr.dogfoot.hwplib.object.docinfo.Numbering;
import kr.dogfoot.hwplib.object.docinfo.ParaShape;
import kr.dogfoot.hwplib.object.docinfo.Style;
import kr.dogfoot.hwplib.object.docinfo.TabDef;
import kr.dogfoot.hwplib.object.etc.UnknownRecord;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;
import kr.dogfoot.hwplib.writer.ForUnknown;
import kr.dogfoot.hwplib.writer.docinfo.ForBinData;
import kr.dogfoot.hwplib.writer.docinfo.ForBorderFill;
import kr.dogfoot.hwplib.writer.docinfo.ForBullet;
import kr.dogfoot.hwplib.writer.docinfo.ForCharShape;
import kr.dogfoot.hwplib.writer.docinfo.ForCompatibleDocument;
import kr.dogfoot.hwplib.writer.docinfo.ForDocumentProperties;
import kr.dogfoot.hwplib.writer.docinfo.ForFaceName;
import kr.dogfoot.hwplib.writer.docinfo.ForIDMappings;
import kr.dogfoot.hwplib.writer.docinfo.ForLayoutCompatibility;
import kr.dogfoot.hwplib.writer.docinfo.ForMemoShape;
import kr.dogfoot.hwplib.writer.docinfo.ForNumbering;
import kr.dogfoot.hwplib.writer.docinfo.ForParaShape;
import kr.dogfoot.hwplib.writer.docinfo.ForStyle;
import kr.dogfoot.hwplib.writer.docinfo.ForTabDef;

public class ForDocInfo {
    private DocInfo docInfo;
    private StreamWriter sw;

    public void write(DocInfo docInfo, StreamWriter sw) throws Exception {
        this.docInfo = docInfo;
        this.sw = sw;
        this.documentProperties();
        this.idMappings();
        sw.upRecordLevel();
        this.binData();
        this.faceName();
        this.borderFill();
        this.charShape();
        this.tabDef();
        this.numbering();
        this.bullet();
        this.paraShape();
        this.style();
        this.memoShape();
        this.trackChangeAuthor();
        this.trackChange2();
        sw.downRecordLevel();
        this.docData();
        this.forbiddenChar();
        this.compatibleDocument();
        sw.upRecordLevel();
        this.layoutCompatibility();
        sw.downRecordLevel();
        this.distributeDocData();
        sw.upRecordLevel();
        this.trackChange();
        sw.downRecordLevel();
    }

    private void documentProperties() throws IOException {
        DocumentProperties dp = this.docInfo.getDocumentProperties();
        if (dp == null) {
            return;
        }
        ForDocumentProperties.write(dp, this.sw);
    }

    private void idMappings() throws IOException {
        IDMappings im = this.docInfo.getIDMappings();
        if (im == null) {
            return;
        }
        ForIDMappings.write(im, this.sw);
    }

    private void binData() throws IOException {
        for (BinData bd : this.docInfo.getBinDataList()) {
            ForBinData.write(bd, this.sw);
        }
    }

    private void faceName() throws IOException {
        this.faceNameList(this.docInfo.getHangulFaceNameList());
        this.faceNameList(this.docInfo.getEnglishFaceNameList());
        this.faceNameList(this.docInfo.getHanjaFaceNameList());
        this.faceNameList(this.docInfo.getJapaneseFaceNameList());
        this.faceNameList(this.docInfo.getEtcFaceNameList());
        this.faceNameList(this.docInfo.getSymbolFaceNameList());
        this.faceNameList(this.docInfo.getUserFaceNameList());
    }

    private void faceNameList(ArrayList<FaceName> faceNameList) throws IOException {
        for (FaceName fa : faceNameList) {
            ForFaceName.write(fa, this.sw);
        }
    }

    private void borderFill() throws IOException {
        for (BorderFill bf : this.docInfo.getBorderFillList()) {
            ForBorderFill.write(bf, this.sw);
        }
    }

    private void charShape() throws IOException {
        for (CharShape cs : this.docInfo.getCharShapeList()) {
            ForCharShape.write(cs, this.sw);
        }
    }

    private void tabDef() throws IOException {
        for (TabDef td : this.docInfo.getTabDefList()) {
            ForTabDef.write(td, this.sw);
        }
    }

    private void numbering() throws Exception {
        for (Numbering n : this.docInfo.getNumberingList()) {
            ForNumbering.write(n, this.sw);
        }
    }

    private void bullet() throws IOException {
        for (Bullet b : this.docInfo.getBulletList()) {
            ForBullet.write(b, this.sw);
        }
    }

    private void paraShape() throws IOException {
        for (ParaShape ps : this.docInfo.getParaShapeList()) {
            ForParaShape.write(ps, this.sw);
        }
    }

    private void style() throws IOException {
        for (Style s : this.docInfo.getStyleList()) {
            ForStyle.write(s, this.sw);
        }
    }

    private void docData() throws IOException {
        if (this.docInfo.getDocData() != null) {
            ForUnknown.write(this.docInfo.getDocData(), 27, this.sw);
        }
    }

    private void forbiddenChar() throws IOException {
        if (this.docInfo.getForbiddenChar() != null) {
            ForUnknown.write(this.docInfo.getForbiddenChar(), 94, this.sw);
        }
    }

    private void distributeDocData() throws IOException {
        if (this.docInfo.getDistributeDocData() != null) {
            ForUnknown.write(this.docInfo.getDistributeDocData(), 28, this.sw);
        }
    }

    private void compatibleDocument() throws IOException {
        if (this.docInfo.getCompatibleDocument() != null) {
            ForCompatibleDocument.write(this.docInfo.getCompatibleDocument(), this.sw);
        }
    }

    private void layoutCompatibility() throws IOException {
        if (this.docInfo.getLayoutCompatibility() != null) {
            ForLayoutCompatibility.write(this.docInfo.getLayoutCompatibility(), this.sw);
        }
    }

    private void trackChange() throws IOException {
        if (this.docInfo.getTrackChange() != null) {
            ForUnknown.write(this.docInfo.getTrackChange(), 32, this.sw);
        }
    }

    private void memoShape() throws IOException {
        for (MemoShape memoShape : this.docInfo.getMemoShapeList()) {
            ForMemoShape.write(memoShape, this.sw);
        }
    }

    private void trackChange2() throws IOException {
        for (UnknownRecord trackChange2 : this.docInfo.getTrackChange2List()) {
            ForUnknown.write(trackChange2, 96, this.sw);
        }
    }

    private void trackChangeAuthor() throws IOException {
        for (UnknownRecord trackChangeAuthor : this.docInfo.getTrackChangeAuthorList()) {
            ForUnknown.write(trackChangeAuthor, 97, this.sw);
        }
    }
}

