/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.docinfo;

import java.io.IOException;
import kr.dogfoot.hwplib.object.docinfo.IDMappings;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class ForIDMappings {
    public static void write(IDMappings im, StreamWriter sw) throws IOException {
        ForIDMappings.recordHeader(sw);
        sw.writeSInt4(im.getBinDataCount());
        sw.writeSInt4(im.getHangulFaceNameCount());
        sw.writeSInt4(im.getEnglishFaceNameCount());
        sw.writeSInt4(im.getHanjaFaceNameCount());
        sw.writeSInt4(im.getJapaneseFaceNameCount());
        sw.writeSInt4(im.getEtcFaceNameCount());
        sw.writeSInt4(im.getSymbolFaceNameCount());
        sw.writeSInt4(im.getUserFaceNameCount());
        sw.writeSInt4(im.getBorderFillCount());
        sw.writeSInt4(im.getCharShapeCount());
        sw.writeSInt4(im.getTabDefCount());
        sw.writeSInt4(im.getNumberingCount());
        sw.writeSInt4(im.getBulletCount());
        sw.writeSInt4(im.getParaShapeCount());
        sw.writeSInt4(im.getStyleCount());
        if (sw.getFileVersion().isOver(5, 0, 2, 1)) {
            sw.writeSInt4(im.getMemoShapeCount());
        }
        if (sw.getFileVersion().isOver(5, 0, 3, 2)) {
            sw.writeSInt4(im.getTrackChangeCount());
            sw.writeSInt4(im.getTrackChangeAuthorCount());
        }
    }

    private static void recordHeader(StreamWriter sw) throws IOException {
        sw.writeRecordHeader(17, ForIDMappings.getSize(sw.getFileVersion()));
    }

    private static int getSize(FileVersion version) {
        if (version.isOver(5, 0, 3, 2)) {
            return 72;
        }
        if (version.isOver(5, 0, 2, 1)) {
            return 64;
        }
        return 60;
    }
}

