(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'j-logger', 'kotlinx-coroutines-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('j-logger'), require('kotlinx-coroutines-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'j-logger-j-logger-coroutine'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'j-logger-j-logger-coroutine'.");
    }
    if (typeof this['j-logger'] === 'undefined') {
      throw new Error("Error loading module 'j-logger-j-logger-coroutine'. Its dependency 'j-logger' was not found. Please, check whether 'j-logger' is loaded prior to 'j-logger-j-logger-coroutine'.");
    }
    if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'j-logger-j-logger-coroutine'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'j-logger-j-logger-coroutine'.");
    }
    root['j-logger-j-logger-coroutine'] = factory(typeof this['j-logger-j-logger-coroutine'] === 'undefined' ? {} : this['j-logger-j-logger-coroutine'], kotlin, this['j-logger'], this['kotlinx-coroutines-core']);
  }
}(this, function (_, Kotlin, $module$j_logger, $module$kotlinx_coroutines_core) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var context = $module$j_logger.kr.jadekim.logger.context;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var CoroutineContext$Key = Kotlin.kotlin.coroutines.CoroutineContext.Key;
  var MutableLogContext = $module$j_logger.kr.jadekim.logger.context.MutableLogContext_jbvn2s$;
  var AbstractCoroutineContextElement = Kotlin.kotlin.coroutines.AbstractCoroutineContextElement;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var MutableLogContext_0 = $module$j_logger.kr.jadekim.logger.context.MutableLogContext;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var LogExtra = $module$j_logger.kr.jadekim.logger.LogExtra;
  var LogLevel = $module$j_logger.kr.jadekim.logger.LogLevel;
  var JLogPipe$Key = $module$j_logger.kr.jadekim.logger.pipeline.JLogPipe.Key;
  var Unit = Kotlin.kotlin.Unit;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var CoroutineName = $module$kotlinx_coroutines_core.kotlinx.coroutines.CoroutineName;
  var Channel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.Channel_lsve6m$;
  var handle = $module$j_logger.kr.jadekim.logger.pipeline.handle_9nxs8e$;
  var CoroutineScope = $module$kotlinx_coroutines_core.kotlinx.coroutines.CoroutineScope;
  var JLogPipe = $module$j_logger.kr.jadekim.logger.pipeline.JLogPipe;
  var ChannelResult$Failed = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.ChannelResult.Failed;
  CoroutineLogContext.prototype = Object.create(AbstractCoroutineContextElement.prototype);
  CoroutineLogContext.prototype.constructor = CoroutineLogContext;
  function CoroutineLogContext(data) {
    CoroutineLogContext$Key_getInstance();
    if (data === void 0)
      data = MutableLogContext();
    AbstractCoroutineContextElement.call(this, CoroutineLogContext$Key_getInstance());
    this.$delegate_ss61iq$_0 = data;
  }
  function CoroutineLogContext$Key() {
    CoroutineLogContext$Key_instance = this;
  }
  CoroutineLogContext$Key.prototype.get = function (continuation) {
    var tmp$;
    return (tmp$ = continuation.context.get_j3r2sn$(CoroutineLogContext$Key_getInstance())) != null ? tmp$ : context.ThreadLogContext;
  };
  CoroutineLogContext$Key.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Key',
    interfaces: [CoroutineContext$Key]
  };
  var CoroutineLogContext$Key_instance = null;
  function CoroutineLogContext$Key_getInstance() {
    if (CoroutineLogContext$Key_instance === null) {
      new CoroutineLogContext$Key();
    }
    return CoroutineLogContext$Key_instance;
  }
  Object.defineProperty(CoroutineLogContext.prototype, 'entries', {
    configurable: true,
    get: function () {
      return this.$delegate_ss61iq$_0.entries;
    }
  });
  Object.defineProperty(CoroutineLogContext.prototype, 'keys', {
    configurable: true,
    get: function () {
      return this.$delegate_ss61iq$_0.keys;
    }
  });
  Object.defineProperty(CoroutineLogContext.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.$delegate_ss61iq$_0.size;
    }
  });
  Object.defineProperty(CoroutineLogContext.prototype, 'values', {
    configurable: true,
    get: function () {
      return this.$delegate_ss61iq$_0.values;
    }
  });
  CoroutineLogContext.prototype.clear = function () {
    return this.$delegate_ss61iq$_0.clear();
  };
  CoroutineLogContext.prototype.clone = function () {
    return this.$delegate_ss61iq$_0.clone();
  };
  CoroutineLogContext.prototype.containsKey_11rb$ = function (key) {
    return this.$delegate_ss61iq$_0.containsKey_11rb$(key);
  };
  CoroutineLogContext.prototype.containsValue_11rc$ = function (value) {
    return this.$delegate_ss61iq$_0.containsValue_11rc$(value);
  };
  CoroutineLogContext.prototype.get_11rb$ = function (key) {
    return this.$delegate_ss61iq$_0.get_11rb$(key);
  };
  CoroutineLogContext.prototype.isEmpty = function () {
    return this.$delegate_ss61iq$_0.isEmpty();
  };
  CoroutineLogContext.prototype.plus_lyhonf$ = function (other) {
    return this.$delegate_ss61iq$_0.plus_lyhonf$(other);
  };
  CoroutineLogContext.prototype.plusAssign_lyhonf$ = function (other) {
    return this.$delegate_ss61iq$_0.plusAssign_lyhonf$(other);
  };
  CoroutineLogContext.prototype.put_xwzc9p$ = function (key, value) {
    return this.$delegate_ss61iq$_0.put_xwzc9p$(key, value);
  };
  CoroutineLogContext.prototype.putAll_a2k3zr$ = function (from) {
    return this.$delegate_ss61iq$_0.putAll_a2k3zr$(from);
  };
  CoroutineLogContext.prototype.remove_11rb$ = function (key) {
    return this.$delegate_ss61iq$_0.remove_11rb$(key);
  };
  CoroutineLogContext.prototype.snap = function () {
    return this.$delegate_ss61iq$_0.snap();
  };
  CoroutineLogContext.prototype.toImmutable = function () {
    return this.$delegate_ss61iq$_0.toImmutable();
  };
  CoroutineLogContext.prototype.toMutable = function () {
    return this.$delegate_ss61iq$_0.toMutable();
  };
  CoroutineLogContext.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CoroutineLogContext',
    interfaces: [MutableLogContext_0, AbstractCoroutineContextElement]
  };
  function sLog($receiver, level, message, throwable, meta, context, continuation) {
    if (throwable === void 0)
      throwable = null;
    if (meta === void 0)
      meta = emptyMap();
    if (context === void 0)
      context = null;
    var tmp$, tmp$_0;
    var coroutineLogContext = (tmp$ = continuation.context.get_j3r2sn$(CoroutineLogContext$Key_getInstance())) != null ? tmp$.snap() : null;
    if (coroutineLogContext == null) {
      tmp$_0 = context;
    } else {
      tmp$_0 = coroutineLogContext.plus_lyhonf$(context);
    }
    var logContext = tmp$_0;
    $receiver.log_g30ot4$(level, message, throwable, meta, logContext);
  }
  function Coroutine$sLog($receiver_0, level_0, log_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$level = level_0;
    this.local$log = log_0;
  }
  Coroutine$sLog.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sLog.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sLog.prototype.constructor = Coroutine$sLog;
  Coroutine$sLog.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (!this.local$level.isPrintable_4q0x8g$(this.local$$receiver.level)) {
              return;
            } else {
              this.state_0 = 2;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            var extra = new LogExtra();
            var message = this.local$log(extra);
            this.state_0 = 3;
            this.result_0 = sLog(this.local$$receiver, this.local$level, message, extra.throwable, extra.meta, extra.context, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sLog_0($receiver_0, level_0, log_0, continuation_0, suspended) {
    var instance = new Coroutine$sLog($receiver_0, level_0, log_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sFetal($receiver_0, message_0, throwable_0, meta_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$message = message_0;
    this.local$throwable = throwable_0;
    this.local$meta = meta_0;
  }
  Coroutine$sFetal.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sFetal.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sFetal.prototype.constructor = Coroutine$sFetal;
  Coroutine$sFetal.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$throwable === void 0)
              this.local$throwable = null;
            if (this.local$meta === void 0)
              this.local$meta = emptyMap();
            this.state_0 = 2;
            this.result_0 = sLog(this.local$$receiver, LogLevel.FETAL, this.local$message, this.local$throwable, this.local$meta, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sFetal($receiver_0, message_0, throwable_0, meta_0, continuation_0, suspended) {
    var instance = new Coroutine$sFetal($receiver_0, message_0, throwable_0, meta_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sFetal_0($receiver_0, body_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$body = body_0;
  }
  Coroutine$sFetal_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sFetal_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sFetal_0.prototype.constructor = Coroutine$sFetal_0;
  Coroutine$sFetal_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = sLog_0(this.local$$receiver, LogLevel.FETAL, this.local$body, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sFetal_0($receiver_0, body_0, continuation_0, suspended) {
    var instance = new Coroutine$sFetal_0($receiver_0, body_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sError($receiver_0, message_0, throwable_0, meta_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$message = message_0;
    this.local$throwable = throwable_0;
    this.local$meta = meta_0;
  }
  Coroutine$sError.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sError.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sError.prototype.constructor = Coroutine$sError;
  Coroutine$sError.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$throwable === void 0)
              this.local$throwable = null;
            if (this.local$meta === void 0)
              this.local$meta = emptyMap();
            this.state_0 = 2;
            this.result_0 = sLog(this.local$$receiver, LogLevel.ERROR, this.local$message, this.local$throwable, this.local$meta, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sError($receiver_0, message_0, throwable_0, meta_0, continuation_0, suspended) {
    var instance = new Coroutine$sError($receiver_0, message_0, throwable_0, meta_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sError_0($receiver_0, body_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$body = body_0;
  }
  Coroutine$sError_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sError_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sError_0.prototype.constructor = Coroutine$sError_0;
  Coroutine$sError_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = sLog_0(this.local$$receiver, LogLevel.ERROR, this.local$body, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sError_0($receiver_0, body_0, continuation_0, suspended) {
    var instance = new Coroutine$sError_0($receiver_0, body_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sWarning($receiver_0, message_0, throwable_0, meta_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$message = message_0;
    this.local$throwable = throwable_0;
    this.local$meta = meta_0;
  }
  Coroutine$sWarning.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sWarning.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sWarning.prototype.constructor = Coroutine$sWarning;
  Coroutine$sWarning.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$throwable === void 0)
              this.local$throwable = null;
            if (this.local$meta === void 0)
              this.local$meta = emptyMap();
            this.state_0 = 2;
            this.result_0 = sLog(this.local$$receiver, LogLevel.WARNING, this.local$message, this.local$throwable, this.local$meta, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sWarning($receiver_0, message_0, throwable_0, meta_0, continuation_0, suspended) {
    var instance = new Coroutine$sWarning($receiver_0, message_0, throwable_0, meta_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sWarning_0($receiver_0, body_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$body = body_0;
  }
  Coroutine$sWarning_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sWarning_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sWarning_0.prototype.constructor = Coroutine$sWarning_0;
  Coroutine$sWarning_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = sLog_0(this.local$$receiver, LogLevel.WARNING, this.local$body, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sWarning_0($receiver_0, body_0, continuation_0, suspended) {
    var instance = new Coroutine$sWarning_0($receiver_0, body_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sInfo($receiver_0, message_0, throwable_0, meta_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$message = message_0;
    this.local$throwable = throwable_0;
    this.local$meta = meta_0;
  }
  Coroutine$sInfo.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sInfo.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sInfo.prototype.constructor = Coroutine$sInfo;
  Coroutine$sInfo.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$throwable === void 0)
              this.local$throwable = null;
            if (this.local$meta === void 0)
              this.local$meta = emptyMap();
            this.state_0 = 2;
            this.result_0 = sLog(this.local$$receiver, LogLevel.INFO, this.local$message, this.local$throwable, this.local$meta, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sInfo($receiver_0, message_0, throwable_0, meta_0, continuation_0, suspended) {
    var instance = new Coroutine$sInfo($receiver_0, message_0, throwable_0, meta_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sInfo_0($receiver_0, body_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$body = body_0;
  }
  Coroutine$sInfo_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sInfo_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sInfo_0.prototype.constructor = Coroutine$sInfo_0;
  Coroutine$sInfo_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = sLog_0(this.local$$receiver, LogLevel.INFO, this.local$body, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sInfo_0($receiver_0, body_0, continuation_0, suspended) {
    var instance = new Coroutine$sInfo_0($receiver_0, body_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sDebug($receiver_0, message_0, throwable_0, meta_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$message = message_0;
    this.local$throwable = throwable_0;
    this.local$meta = meta_0;
  }
  Coroutine$sDebug.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sDebug.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sDebug.prototype.constructor = Coroutine$sDebug;
  Coroutine$sDebug.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$throwable === void 0)
              this.local$throwable = null;
            if (this.local$meta === void 0)
              this.local$meta = emptyMap();
            this.state_0 = 2;
            this.result_0 = sLog(this.local$$receiver, LogLevel.DEBUG, this.local$message, this.local$throwable, this.local$meta, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sDebug($receiver_0, message_0, throwable_0, meta_0, continuation_0, suspended) {
    var instance = new Coroutine$sDebug($receiver_0, message_0, throwable_0, meta_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sDebug_0($receiver_0, body_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$body = body_0;
  }
  Coroutine$sDebug_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sDebug_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sDebug_0.prototype.constructor = Coroutine$sDebug_0;
  Coroutine$sDebug_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = sLog_0(this.local$$receiver, LogLevel.DEBUG, this.local$body, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sDebug_0($receiver_0, body_0, continuation_0, suspended) {
    var instance = new Coroutine$sDebug_0($receiver_0, body_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sTrace($receiver_0, message_0, throwable_0, meta_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$message = message_0;
    this.local$throwable = throwable_0;
    this.local$meta = meta_0;
  }
  Coroutine$sTrace.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sTrace.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sTrace.prototype.constructor = Coroutine$sTrace;
  Coroutine$sTrace.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$throwable === void 0)
              this.local$throwable = null;
            if (this.local$meta === void 0)
              this.local$meta = emptyMap();
            this.state_0 = 2;
            this.result_0 = sLog(this.local$$receiver, LogLevel.TRACE, this.local$message, this.local$throwable, this.local$meta, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sTrace($receiver_0, message_0, throwable_0, meta_0, continuation_0, suspended) {
    var instance = new Coroutine$sTrace($receiver_0, message_0, throwable_0, meta_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$sTrace_0($receiver_0, body_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$body = body_0;
  }
  Coroutine$sTrace_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sTrace_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sTrace_0.prototype.constructor = Coroutine$sTrace_0;
  Coroutine$sTrace_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = sLog_0(this.local$$receiver, LogLevel.TRACE, this.local$body, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function sTrace_0($receiver_0, body_0, continuation_0, suspended) {
    var instance = new Coroutine$sTrace_0($receiver_0, body_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function AsyncPipeline(pipeline, queueCapacity) {
    AsyncPipeline$Key_getInstance();
    if (queueCapacity === void 0)
      queueCapacity = 2147483647;
    this.pipeline = pipeline;
    this.coroutineContext_tv4bz1$_0 = new CoroutineName('JLogger-AsyncPipeline');
    this.queue_0 = Channel(queueCapacity);
    launch(this, void 0, void 0, AsyncPipeline_init$lambda(this));
    this.key_yjr933$_0 = AsyncPipeline$Key_getInstance();
  }
  function AsyncPipeline$Key() {
    AsyncPipeline$Key_instance = this;
  }
  AsyncPipeline$Key.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Key',
    interfaces: [JLogPipe$Key]
  };
  var AsyncPipeline$Key_instance = null;
  function AsyncPipeline$Key_getInstance() {
    if (AsyncPipeline$Key_instance === null) {
      new AsyncPipeline$Key();
    }
    return AsyncPipeline$Key_instance;
  }
  Object.defineProperty(AsyncPipeline.prototype, 'coroutineContext', {
    configurable: true,
    get: function () {
      return this.coroutineContext_tv4bz1$_0;
    }
  });
  Object.defineProperty(AsyncPipeline.prototype, 'key', {
    configurable: true,
    get: function () {
      return this.key_yjr933$_0;
    }
  });
  function Coroutine$AsyncPipeline$handle$lambda$lambda(this$AsyncPipeline_0, closure$log_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$AsyncPipeline = this$AsyncPipeline_0;
    this.local$closure$log = closure$log_0;
  }
  Coroutine$AsyncPipeline$handle$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$AsyncPipeline$handle$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$AsyncPipeline$handle$lambda$lambda.prototype.constructor = Coroutine$AsyncPipeline$handle$lambda$lambda;
  Coroutine$AsyncPipeline$handle$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$AsyncPipeline.queue_0.send_11rb$(this.local$closure$log, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function AsyncPipeline$handle$lambda$lambda(this$AsyncPipeline_0, closure$log_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$AsyncPipeline$handle$lambda$lambda(this$AsyncPipeline_0, closure$log_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  AsyncPipeline.prototype.handle_jm7aqs$ = function (log) {
    var $receiver = this.queue_0.trySend_11rb$(log);
    if (Kotlin.isType($receiver.holder, ChannelResult$Failed)) {
      $receiver.exceptionOrNull();
      launch(this, void 0, void 0, AsyncPipeline$handle$lambda$lambda(this, log));
    }
    return log;
  };
  function Coroutine$AsyncPipeline_init$lambda(this$AsyncPipeline_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$AsyncPipeline = this$AsyncPipeline_0;
    this.local$tmp$ = void 0;
  }
  Coroutine$AsyncPipeline_init$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$AsyncPipeline_init$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$AsyncPipeline_init$lambda.prototype.constructor = Coroutine$AsyncPipeline_init$lambda;
  Coroutine$AsyncPipeline_init$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.local$this$AsyncPipeline.queue_0.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$tmp$.hasNext(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            if (!this.result_0) {
              this.state_0 = 5;
              continue;
            } else {
              this.state_0 = 4;
              continue;
            }

          case 4:
            var log = this.local$tmp$.next();
            handle(this.local$this$AsyncPipeline.pipeline, log);
            this.state_0 = 2;
            continue;
          case 5:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function AsyncPipeline_init$lambda(this$AsyncPipeline_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$AsyncPipeline_init$lambda(this$AsyncPipeline_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  AsyncPipeline.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AsyncPipeline',
    interfaces: [JLogPipe, CoroutineScope]
  };
  Object.defineProperty(CoroutineLogContext, 'Key', {
    get: CoroutineLogContext$Key_getInstance
  });
  var package$kr = _.kr || (_.kr = {});
  var package$jadekim = package$kr.jadekim || (package$kr.jadekim = {});
  var package$logger = package$jadekim.logger || (package$jadekim.logger = {});
  var package$coroutine = package$logger.coroutine || (package$logger.coroutine = {});
  var package$context = package$coroutine.context || (package$coroutine.context = {});
  package$context.CoroutineLogContext = CoroutineLogContext;
  package$coroutine.sLog_tku7i5$ = sLog;
  package$coroutine.sLog_us0nkv$ = sLog_0;
  package$coroutine.sFetal_s44hqw$ = sFetal;
  package$coroutine.sFetal_hs87b7$ = sFetal_0;
  package$coroutine.sError_s44hqw$ = sError;
  package$coroutine.sError_hs87b7$ = sError_0;
  package$coroutine.sWarning_s44hqw$ = sWarning;
  package$coroutine.sWarning_hs87b7$ = sWarning_0;
  package$coroutine.sInfo_s44hqw$ = sInfo;
  package$coroutine.sInfo_hs87b7$ = sInfo_0;
  package$coroutine.sDebug_s44hqw$ = sDebug;
  package$coroutine.sDebug_hs87b7$ = sDebug_0;
  package$coroutine.sTrace_s44hqw$ = sTrace;
  package$coroutine.sTrace_hs87b7$ = sTrace_0;
  Object.defineProperty(AsyncPipeline, 'Key', {
    get: AsyncPipeline$Key_getInstance
  });
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  var package$pipeline = package$coroutine.pipeline || (package$coroutine.pipeline = {});
  package$pipeline.AsyncPipeline = AsyncPipeline;
  AsyncPipeline.prototype.install_zewg7a$ = JLogPipe.prototype.install_zewg7a$;
  Kotlin.defineModule('j-logger-j-logger-coroutine', _);
  return _;
}));

//# sourceMappingURL=j-logger-j-logger-coroutine.js.map
