/*
 * Decompiled with CFR 0.152.
 */
package kr.jadekim.jext.exposed.koin;

import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.RdsUtilities;
import software.amazon.awssdk.services.rds.model.GenerateAuthenticationTokenRequest;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "rdsInit", "", "urlString", "", "username", "resolveRegion", "Lsoftware/amazon/awssdk/regions/Region;", "host", "jext-exposed-koin"})
public final class RdsKt {
    private static final Logger logger = LoggerFactory.getLogger((String)"kr.jadekim.jext.exposed.koin.RdsUtils");

    public static final void rdsInit(@NotNull String urlString, @NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        if (!StringsKt.startsWith$default((String)urlString, (String)"jdbc:mysql:aws", (boolean)false, (int)2, null)) {
            return;
        }
        String string = urlString.substring(17);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        URI uri = new URI("mysql://" + string);
        logger.info("Init RDS (" + username + " - " + urlString + ")");
        String string2 = uri.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.host");
        Region region = RdsKt.resolveRegion(string2);
        DefaultCredentialsProvider provider = DefaultCredentialsProvider.create();
        GetCallerIdentityResponse identity = ((StsClient)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)provider)).build()).getCallerIdentity();
        RdsUtilities utilities = RdsUtilities.builder().credentialsProvider((AwsCredentialsProvider)provider).region(region).build();
        String token = utilities.generateAuthenticationToken(arg_0 -> RdsKt.rdsInit$lambda$0(uri, username, arg_0));
        logger.info("Initialized RDS (" + username + " - " + urlString + ") with " + identity + " (" + token + ")");
    }

    private static final Region resolveRegion(String host) {
        char[] cArray = new char[]{'.'};
        List tokens = CollectionsKt.asReversed((List)StringsKt.split$default((CharSequence)host, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        if (tokens.size() < 4) {
            Region region = Region.AP_NORTHEAST_2;
            Intrinsics.checkNotNullExpressionValue((Object)region, (String)"AP_NORTHEAST_2");
            return region;
        }
        Region region = Region.of((String)((String)tokens.get(3)));
        if (region == null) {
            Region region2 = Region.AP_NORTHEAST_2;
            region = region2;
            Intrinsics.checkNotNullExpressionValue((Object)region2, (String)"AP_NORTHEAST_2");
        }
        return region;
    }

    private static final void rdsInit$lambda$0(URI $uri, String $username, GenerateAuthenticationTokenRequest.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
        Intrinsics.checkNotNullParameter((Object)$username, (String)"$username");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.hostname($uri.getHost()).port($uri.getPort()).username($username);
    }
}

