/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.javaagent.jettyalpn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.motd.javaagent.jettyalpn.Util;

final class JavaVersion {
    private static final Pattern VERSION_PATTERN;
    private static final int major;
    private static final int minor;
    private static final int micro;
    private static final int patch;

    static int major() {
        return major;
    }

    static int minor() {
        return minor;
    }

    static int micro() {
        return micro;
    }

    static int patch() {
        return patch;
    }

    private JavaVersion() {
    }

    static {
        String versionStr;
        VERSION_PATTERN = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(?:_([0-9]+)?)$");
        Matcher m = VERSION_PATTERN.matcher(versionStr = System.getProperty("java.version", ""));
        if (!m.matches()) {
            Util.log("Could not parse java.version: " + versionStr);
            major = 0;
            minor = 0;
            micro = 0;
            patch = 0;
        } else {
            major = Integer.parseInt(m.group(1));
            minor = Integer.parseInt(m.group(2));
            micro = Integer.parseInt(m.group(3));
            String patchStr = m.group(4);
            patch = patchStr == null ? 0 : Integer.parseInt(patchStr);
        }
    }
}

