/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.os;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kr.motd.maven.os.DetectionException;

public abstract class Detector {
    public static final String DETECTED_NAME = "os.detected.name";
    public static final String DETECTED_ARCH = "os.detected.arch";
    public static final String DETECTED_CLASSIFIER = "os.detected.classifier";
    private static final String UNKNOWN = "unknown";

    protected void detect(Properties props) throws DetectionException {
        this.log("------------------------------------------------------------------------");
        this.log("Detecting the operating system and CPU architecture");
        this.log("------------------------------------------------------------------------");
        Properties allProps = new Properties(System.getProperties());
        allProps.putAll((Map<?, ?>)props);
        String osName = allProps.getProperty("os.name");
        String osArch = allProps.getProperty("os.arch");
        String detectedName = Detector.normalizeOs(osName);
        String detectedArch = Detector.normalizeArch(osArch);
        String detectedClassifier = detectedName + '-' + detectedArch;
        this.setProperty(props, DETECTED_NAME, detectedName);
        this.setProperty(props, DETECTED_ARCH, detectedArch);
        this.setProperty(props, DETECTED_CLASSIFIER, detectedClassifier);
        String failOnUnknownOS = allProps.getProperty("failOnUnknownOS");
        if (failOnUnknownOS == null || !failOnUnknownOS.equalsIgnoreCase("false")) {
            if (UNKNOWN.equals(detectedName)) {
                throw new DetectionException("unknown os.name: " + osName);
            }
            if (UNKNOWN.equals(detectedArch)) {
                throw new DetectionException("unknown os.arch: " + osArch);
            }
        }
    }

    private void setProperty(Properties props, String name, String value) {
        props.setProperty(name, value);
        System.setProperty(name, value);
        this.logProperty(name, value);
    }

    protected abstract void log(String var1);

    protected abstract void logProperty(String var1, String var2);

    private static String normalizeOs(String value) {
        if ((value = Detector.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("os400") && (value.length() <= 5 || !Character.isDigit(value.charAt(5)))) {
            return "os400";
        }
        if (value.startsWith("linux")) {
            return "linux";
        }
        if (value.startsWith("macosx") || value.startsWith("osx")) {
            return "osx";
        }
        if (value.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("solaris") || value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        return UNKNOWN;
    }

    private static String normalizeArch(String value) {
        if ((value = Detector.normalize(value)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value.matches("^(ia64|itanium64)$")) {
            return "itanium_64";
        }
        if (value.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if (value.equals("aarch64")) {
            return "aarch_64";
        }
        if (value.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if (value.equals("ppc64")) {
            return "ppc_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }
}

