/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.os;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kr.motd.maven.os.DetectionException;

public abstract class Detector {
    public static final String DETECTED_NAME = "os.detected.name";
    public static final String DETECTED_ARCH = "os.detected.arch";
    public static final String DETECTED_CLASSIFIER = "os.detected.classifier";
    public static final String DETECTED_RELEASE = "os.detected.release";
    public static final String DETECTED_RELEASE_VERSION = "os.detected.release.version";
    public static final String DETECTED_RELEASE_LIKE_PREFIX = "os.detected.release.like.";
    private static final String UNKNOWN = "unknown";
    private static final String LINUX_ID_PREFIX = "ID=";
    private static final String LINUX_ID_LIKE_PREFIX = "ID_LIKE=";
    private static final String LINUX_VERSION_ID_PREFIX = "VERSION_ID=";
    private static final String[] LINUX_OS_RELEASE_FILES = new String[]{"/etc/os-release", "/usr/lib/os-release"};
    private static final String REDHAT_RELEASE_FILE = "/etc/redhat-release";
    private static final String[] DEFAULT_REDHAT_VARIANTS = new String[]{"rhel", "fedora"};

    protected void detect(Properties props, List<String> classifierWithLikes) {
        LinuxRelease linuxRelease;
        this.log("------------------------------------------------------------------------");
        this.log("Detecting the operating system and CPU architecture");
        this.log("------------------------------------------------------------------------");
        Properties allProps = new Properties(System.getProperties());
        allProps.putAll((Map<?, ?>)props);
        String osName = allProps.getProperty("os.name");
        String osArch = allProps.getProperty("os.arch");
        String detectedName = Detector.normalizeOs(osName);
        String detectedArch = Detector.normalizeArch(osArch);
        this.setProperty(props, DETECTED_NAME, detectedName);
        this.setProperty(props, DETECTED_ARCH, detectedArch);
        String failOnUnknownOS = allProps.getProperty("failOnUnknownOS");
        if (!"false".equalsIgnoreCase(failOnUnknownOS)) {
            if (UNKNOWN.equals(detectedName)) {
                throw new DetectionException("unknown os.name: " + osName);
            }
            if (UNKNOWN.equals(detectedArch)) {
                throw new DetectionException("unknown os.arch: " + osArch);
            }
        }
        String detectedClassifier = detectedName + '-' + detectedArch;
        LinuxRelease linuxRelease2 = linuxRelease = "linux".equals(detectedName) ? Detector.getLinuxRelease() : null;
        if (linuxRelease != null) {
            this.setProperty(props, DETECTED_RELEASE, linuxRelease.id);
            if (linuxRelease.version != null) {
                this.setProperty(props, DETECTED_RELEASE_VERSION, linuxRelease.version);
            }
            for (String like : linuxRelease.like) {
                String propKey = DETECTED_RELEASE_LIKE_PREFIX + like;
                this.setProperty(props, propKey, "true");
            }
            for (String classifierLike : classifierWithLikes) {
                if (!linuxRelease.like.contains(classifierLike)) continue;
                detectedClassifier = detectedClassifier + "-" + classifierLike;
                break;
            }
        }
        this.setProperty(props, DETECTED_CLASSIFIER, detectedClassifier);
    }

    private void setProperty(Properties props, String name, String value) {
        props.setProperty(name, value);
        System.setProperty(name, value);
        this.logProperty(name, value);
    }

    protected abstract void log(String var1);

    protected abstract void logProperty(String var1, String var2);

    private static String normalizeOs(String value) {
        if ((value = Detector.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("os400") && (value.length() <= 5 || !Character.isDigit(value.charAt(5)))) {
            return "os400";
        }
        if (value.startsWith("linux")) {
            return "linux";
        }
        if (value.startsWith("macosx") || value.startsWith("osx")) {
            return "osx";
        }
        if (value.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("solaris") || value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        return UNKNOWN;
    }

    private static String normalizeArch(String value) {
        if ((value = Detector.normalize(value)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value.matches("^(ia64|itanium64)$")) {
            return "itanium_64";
        }
        if (value.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(value)) {
            return "aarch_64";
        }
        if (value.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if ("ppc64".equals(value)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(value)) {
            return "ppcle_64";
        }
        if ("s390".equals(value)) {
            return "s390_32";
        }
        if ("s390x".equals(value)) {
            return "s390_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static LinuxRelease getLinuxRelease() {
        for (String osReleaseFileName : LINUX_OS_RELEASE_FILES) {
            File file = new File(osReleaseFileName);
            if (!file.exists()) continue;
            return Detector.parseLinuxOsReleaseFile(file);
        }
        File file = new File(REDHAT_RELEASE_FILE);
        if (file.exists()) {
            return Detector.parseLinuxRedhatReleaseFile(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LinuxRelease parseLinuxOsReleaseFile(File file) {
        BufferedReader reader;
        block6: {
            LinuxRelease linuxRelease;
            reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
                String id = null;
                String version = null;
                LinkedHashSet<String> likeSet = new LinkedHashSet<String>();
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(LINUX_ID_PREFIX)) {
                        id = line.substring(LINUX_ID_PREFIX.length());
                        likeSet.add(id);
                        continue;
                    }
                    if (line.startsWith(LINUX_VERSION_ID_PREFIX)) {
                        version = Detector.normalizeReleaseVersion(line.substring(LINUX_VERSION_ID_PREFIX.length()));
                        continue;
                    }
                    if (!line.startsWith(LINUX_ID_LIKE_PREFIX)) continue;
                    line = line.substring(LINUX_ID_LIKE_PREFIX.length());
                    String[] parts = line.split("\\s+");
                    Collections.addAll(likeSet, parts);
                }
                if (id == null) break block6;
                linuxRelease = new LinuxRelease(id, version, likeSet);
            }
            catch (IOException iOException) {
                Detector.closeQuietly(reader);
            }
            catch (Throwable throwable) {
                Detector.closeQuietly(reader);
                throw throwable;
            }
            Detector.closeQuietly(reader);
            return linuxRelease;
        }
        Detector.closeQuietly(reader);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LinuxRelease parseLinuxRedhatReleaseFile(File file) {
        block9: {
            BufferedReader reader;
            block7: {
                LinuxRelease linuxRelease;
                String id;
                block8: {
                    reader = null;
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
                    String line = reader.readLine();
                    if (line == null) break block7;
                    if ((line = line.toLowerCase(Locale.US)).contains("centos")) {
                        id = "centos";
                        break block8;
                    }
                    if (line.contains("fedora")) {
                        id = "fedora";
                        break block8;
                    }
                    if (line.contains("red hat enterprise linux")) {
                        id = "rhel";
                        break block8;
                    }
                    LinuxRelease linuxRelease2 = null;
                    Detector.closeQuietly(reader);
                    return linuxRelease2;
                }
                try {
                    LinkedHashSet<String> likeSet = new LinkedHashSet<String>();
                    likeSet.addAll(Arrays.asList(DEFAULT_REDHAT_VARIANTS));
                    likeSet.add(id);
                    linuxRelease = new LinuxRelease(id, null, likeSet);
                }
                catch (IOException iOException) {
                    Detector.closeQuietly(reader);
                    break block9;
                }
                catch (Throwable throwable) {
                    Detector.closeQuietly(reader);
                    throw throwable;
                }
                Detector.closeQuietly(reader);
                return linuxRelease;
            }
            Detector.closeQuietly(reader);
        }
        return null;
    }

    private static String normalizeReleaseVersion(String version) {
        return version.trim().replace("\"", "");
    }

    private static void closeQuietly(Closeable obj) {
        try {
            if (obj != null) {
                obj.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class LinuxRelease {
        final String id;
        final String version;
        final Collection<String> like;

        LinuxRelease(String id, String version, Set<String> like) {
            this.id = id;
            this.version = version;
            this.like = Collections.unmodifiableCollection(like);
        }
    }
}

