/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.sphinx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kr.motd.maven.sphinx.SphinxException;
import net.sourceforge.plantuml.UmlDiagram;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public abstract class SphinxRunner {
    private static final String DIST_PREFIX = SphinxRunner.class.getPackage().getName().replace('.', '/') + "/dist/";
    private final String plantUmlCommand;

    protected SphinxRunner(File sphinxSourceDirectory) {
        if (sphinxSourceDirectory == null) {
            throw new IllegalArgumentException("sphinxSourceDirectory is empty.");
        }
        this.extractSphinx(sphinxSourceDirectory);
        File plantUmlJar = this.findPlantUmlJar();
        this.plantUmlCommand = "java -jar " + plantUmlJar.getPath().replace("\\", "\\\\");
        this.log("PlantUML command: " + this.plantUmlCommand);
        System.setProperty("java.awt.headless", "true");
        System.setProperty("python.options.internalTablesImpl", "weak");
        PySystemState engineSys = new PySystemState();
        engineSys.path.append((PyObject)Py.newString((String)sphinxSourceDirectory.getPath()));
        Py.setSystemState((PySystemState)engineSys);
        this.log("Path: " + engineSys.path);
    }

    public void destroy() {
        Py.getSystemState().cleanup();
    }

    protected abstract void log(String var1);

    private int executePythonScript(String script, String functionName, List<String> args, boolean resultExpected) {
        this.log("args: " + args);
        PythonInterpreter pi = new PythonInterpreter();
        pi.exec("from os import putenv");
        PyObject env = pi.get("putenv");
        env.__call__(Py.java2py((Object)"LANG"), Py.java2py((Object)"en_US.UTF-8"));
        env.__call__(Py.java2py((Object)"LC_ALL"), Py.java2py((Object)"en_US.UTF-8"));
        env.__call__(Py.java2py((Object)"plantuml"), Py.java2py((Object)this.plantUmlCommand));
        env.__call__(Py.java2py((Object)"TZ"), Py.java2py((Object)"UTC"));
        pi.exec(script);
        PyObject func = pi.get(functionName);
        PyObject ret = func.__call__(Py.java2py(args));
        int result = 0;
        if (resultExpected) {
            result = (Integer)Py.tojava((PyObject)ret, Integer.class);
        }
        pi.close();
        pi.cleanup();
        return result;
    }

    public int runSphinx(List<String> args) {
        String invokeSphinxScript = "from sphinx import build_main";
        String functionName = "build_main";
        return this.executePythonScript(invokeSphinxScript, functionName, args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractSphinx(File sphinxSourceDirectory) {
        this.log("Extracting Sphinx into: " + sphinxSourceDirectory);
        try {
            JarFile jar = new JarFile(this.findPluginJar(), false);
            byte[] buf = new byte[65536];
            Enumeration<JarEntry> i = jar.entries();
            while (i.hasMoreElements()) {
                JarEntry e = i.nextElement();
                if (!e.getName().startsWith(DIST_PREFIX)) continue;
                File f = new File(sphinxSourceDirectory + File.separator + e.getName().substring(DIST_PREFIX.length()));
                if (e.isDirectory()) {
                    if (f.mkdirs() || f.exists()) continue;
                    throw new SphinxException("failed to create a directory: " + f);
                }
                if (f.exists()) {
                    if (f.length() == e.getSize()) continue;
                    if (!f.delete()) {
                        throw new SphinxException("failed to delete a file: " + f);
                    }
                }
                File tmpF = new File(f.getParentFile(), ".tmp-" + f.getName());
                boolean success = false;
                try (InputStream in = jar.getInputStream(e);
                     FileOutputStream out = new FileOutputStream(tmpF);){
                    int readBytes;
                    while ((readBytes = in.read(buf)) >= 0) {
                        ((OutputStream)out).write(buf, 0, readBytes);
                    }
                    success = true;
                }
                finally {
                    if (!success) {
                        tmpF.delete();
                    }
                }
                if (tmpF.renameTo(f)) continue;
                throw new SphinxException("failed to rename a file: " + tmpF + " -> " + f.getName());
            }
        }
        catch (Exception e) {
            throw new SphinxException("failed to extract Sphinx into: " + sphinxSourceDirectory, e);
        }
    }

    private File findPluginJar() {
        return this.findJar(SphinxRunner.class, "the plugin JAR");
    }

    private File findPlantUmlJar() {
        return this.findJar(UmlDiagram.class, "PlantUML JAR");
    }

    private File findJar(Class<?> type, String name) {
        File f;
        CodeSource codeSource = type.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new SphinxException("failed to get the location of " + name + " (CodeSource not available)");
        }
        URL url = codeSource.getLocation();
        this.log(name + ": " + url);
        if (!"file".equals(url.getProtocol()) || !url.getPath().toLowerCase(Locale.US).endsWith(".jar")) {
            throw new SphinxException("failed to get the location of " + name + " (unexpected URL: " + url + ')');
        }
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException ignored) {
            f = new File(url.getPath());
        }
        return f;
    }
}

